/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.ex.util;

import com.intellij.diagnostic.PluginException;
import com.intellij.lexer.FlexAdapter;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.LexerPosition;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ValidatingLexerWrapper
extends Lexer {
    private final Lexer myDelegate;
    private int myLastStartOffset;
    private int myLastEndOffset;
    private int myLastState;
    private IElementType myLastTokenType;
    private boolean myLastValuesActual;

    public ValidatingLexerWrapper(@NotNull Lexer delegate) {
        this.myDelegate = delegate;
    }

    @NotNull
    public CharSequence getTokenSequence() {
        return this.myDelegate.getTokenSequence();
    }

    @NotNull
    public String getTokenText() {
        return this.myDelegate.getTokenText();
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        this.myDelegate.start(buffer, startOffset, endOffset, initialState);
        this.myLastValuesActual = false;
    }

    public int getState() {
        return this.myLastValuesActual ? this.myLastState : this.myDelegate.getState();
    }

    @Nullable
    public IElementType getTokenType() {
        if (!this.myLastValuesActual) {
            this.myLastTokenType = this.myDelegate.getTokenType();
            if (this.myLastTokenType != null) {
                this.myLastStartOffset = this.myDelegate.getTokenStart();
                this.myLastEndOffset = this.myDelegate.getTokenEnd();
                this.myLastState = this.myDelegate.getState();
            }
            this.myLastValuesActual = true;
        }
        return this.myLastTokenType;
    }

    public int getTokenStart() {
        return this.myLastValuesActual ? this.myLastStartOffset : this.myDelegate.getTokenStart();
    }

    public int getTokenEnd() {
        return this.myLastValuesActual ? this.myLastEndOffset : this.myDelegate.getTokenEnd();
    }

    public void advance() {
        this.myDelegate.advance();
        int prevStart = 0;
        int prevEnd = 0;
        int prevState = 0;
        IElementType prevType = null;
        if (this.myLastValuesActual) {
            prevStart = this.myLastStartOffset;
            prevEnd = this.myLastEndOffset;
            prevState = this.myLastState;
            prevType = this.myLastTokenType;
        }
        this.myLastValuesActual = false;
        this.getTokenType();
        if (prevType != null && this.myLastTokenType != null) {
            if (this.myLastStartOffset > this.myLastEndOffset) {
                this.throwException("Incorrect token offsets returned by lexer");
            }
            if (this.myLastStartOffset != prevEnd) {
                this.throwException("Discontinuous sequence of tokens is generated by lexer");
            }
            if (this.myLastEndOffset == this.myLastStartOffset && prevEnd == prevStart && this.myLastState == prevState && this.myLastTokenType == prevType) {
                this.throwException("Lexer is not progressing after calling advance()");
            }
        }
    }

    @NotNull
    public LexerPosition getCurrentPosition() {
        return this.myDelegate.getCurrentPosition();
    }

    public void restore(@NotNull LexerPosition position) {
        this.myDelegate.restore(position);
        this.myLastValuesActual = false;
    }

    @NotNull
    public CharSequence getBufferSequence() {
        return this.myDelegate.getBufferSequence();
    }

    public int getBufferEnd() {
        return this.myDelegate.getBufferEnd();
    }

    private void throwException(@NotNull String message) {
        Class<?> lexerClass = this.myDelegate.getClass();
        boolean isFlexAdapter = lexerClass == FlexAdapter.class;
        throw PluginException.createByClass((String)(message + ": " + (isFlexAdapter ? this.myDelegate.toString() : lexerClass.getName())), null, isFlexAdapter ? ((FlexAdapter)this.myDelegate).getFlex().getClass() : lexerClass);
    }
}

