/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.ex.util;

import com.intellij.openapi.editor.ex.util.DataStorage;
import com.intellij.openapi.editor.ex.util.SegmentArray;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;

public class SegmentArrayWithData
extends SegmentArray {
    private DataStorage myStorage;

    public SegmentArrayWithData(DataStorage storage) {
        this.myStorage = storage;
    }

    public DataStorage createStorage() {
        return this.myStorage.createStorage();
    }

    public void setElementAt(int i2, int startOffset, int endOffset, int data2) {
        this.setElementAt(i2, startOffset, endOffset);
        this.myStorage.setData(i2, data2);
    }

    @Override
    public void remove(int startIndex, int endIndex) {
        this.myStorage.remove(startIndex, endIndex, this.mySegmentCount);
        super.remove(startIndex, endIndex);
    }

    public void replace(int startIndex, int endIndex, @NotNull SegmentArrayWithData newData) {
        int oldLen = endIndex - startIndex;
        int newLen = newData.getSegmentCount();
        int delta = newLen - oldLen;
        if (delta < 0) {
            this.remove(endIndex + delta, endIndex);
        } else if (delta > 0) {
            SegmentArrayWithData deltaData = new SegmentArrayWithData(this.myStorage.createStorage());
            for (int i2 = oldLen; i2 < newLen; ++i2) {
                deltaData.setElementAt(i2 - oldLen, newData.getSegmentStart(i2), newData.getSegmentEnd(i2), newData.getSegmentData(i2));
            }
            this.insert(deltaData, startIndex + oldLen);
        }
        int common = Math.min(newLen, oldLen);
        this.replace(startIndex, newData, common);
    }

    protected void replace(int startOffset, @NotNull SegmentArrayWithData data2, int len) {
        this.myStorage.replace(data2.myStorage, startOffset, len);
        super.replace(startOffset, data2, len);
    }

    public void insert(@NotNull SegmentArrayWithData segmentArray, int startIndex) {
        this.myStorage.insert(segmentArray.myStorage, startIndex, segmentArray.getSegmentCount(), this.mySegmentCount);
        super.insert(segmentArray, startIndex);
    }

    public int getSegmentData(int index) {
        if (index < 0 || index >= this.mySegmentCount) {
            throw new IndexOutOfBoundsException("Wrong index: " + index);
        }
        return this.myStorage.getData(index);
    }

    protected static int @NotNull [] reallocateArray(int @NotNull [] array2, int index) {
        if (index < array2.length) {
            return array2;
        }
        return ArrayUtil.realloc((int[])array2, (int)SegmentArrayWithData.calcCapacity(array2.length, index));
    }

    public SegmentArrayWithData copy() {
        SegmentArrayWithData sa = new SegmentArrayWithData(this.createStorage());
        sa.mySegmentCount = this.mySegmentCount;
        sa.myStarts = (int[])this.myStarts.clone();
        sa.myEnds = (int[])this.myEnds.clone();
        sa.myStorage = this.myStorage.copy();
        return sa;
    }

    public int unpackStateFromData(int data2) {
        return this.myStorage.unpackStateFromData(data2);
    }

    @NotNull
    public IElementType unpackTokenFromData(int data2) {
        return this.myStorage.unpackTokenFromData(data2);
    }

    public int packData(IElementType tokenType, int state, boolean isRestartableState) {
        return this.myStorage.packData(tokenType, state, isRestartableState);
    }
}

