/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.ex.util;

import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.util.DataStorage;
import com.intellij.openapi.editor.ex.util.LayerDescriptor;
import com.intellij.openapi.editor.ex.util.LayeredHighlighterIterator;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.ex.util.LimitedRangeHighlighterIterator;
import com.intellij.openapi.editor.ex.util.SegmentArray;
import com.intellij.openapi.editor.ex.util.SegmentArrayWithData;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterClient;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.text.MergingCharSequence;
import gnu.trove.TIntIntHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LayeredLexerEditorHighlighter
extends LexerEditorHighlighter {
    private static final Logger LOG = Logger.getInstance(LayeredLexerEditorHighlighter.class);
    private final Map<IElementType, LayerDescriptor> myTokensToLayer = new HashMap<IElementType, LayerDescriptor>();

    public LayeredLexerEditorHighlighter(@NotNull SyntaxHighlighter highlighter, @NotNull EditorColorsScheme scheme) {
        super(highlighter, scheme);
    }

    @Override
    @NotNull
    protected SegmentArrayWithData createSegments() {
        return new MappingSegments(this.createStorage());
    }

    public synchronized void registerLayer(@NotNull IElementType tokenType, @NotNull LayerDescriptor layerHighlighter) {
        this.myTokensToLayer.put(tokenType, layerHighlighter);
        this.getSegments().removeAll();
    }

    protected synchronized void unregisterLayer(@NotNull IElementType tokenType) {
        LayerDescriptor layer = this.myTokensToLayer.remove(tokenType);
        if (layer != null) {
            this.getSegments().myLayerBuffers.remove(layer);
            this.getSegments().removeAll();
        }
    }

    @Override
    @NotNull
    public MappingSegments getSegments() {
        return (MappingSegments)super.getSegments();
    }

    @Override
    public void setText(@NotNull CharSequence text) {
        if (this.updateLayers()) {
            this.resetText(text);
        } else {
            super.setText(text);
        }
    }

    @Override
    @NotNull
    protected LexerEditorHighlighter.TokenProcessor createTokenProcessor(final int startIndex, SegmentArrayWithData segments, final CharSequence text) {
        final MappingSegments mappingSegments = (MappingSegments)segments;
        return new LexerEditorHighlighter.TokenProcessor(){
            final Map<Mapper, LightMapper> docTexts = FactoryMap.create(key -> {
                MappedRange predecessor = key.findPredecessor(startIndex, mappingSegments);
                return new LightMapper((Mapper)key, predecessor != null ? predecessor.range.getEndOffset() : 0);
            });

            @Override
            public void addToken(int tokenIndex, int startOffset, int endOffset, int data2, @NotNull IElementType tokenType) {
                mappingSegments.setElementLight(tokenIndex, startOffset, endOffset, data2);
                Mapper mapper = mappingSegments.getMappingDocument(tokenType);
                if (mapper != null) {
                    this.docTexts.get(mapper).addToken(text.subSequence(startOffset, endOffset), tokenType, tokenIndex);
                }
            }

            @Override
            public void finish() {
                for (LightMapper mapper : this.docTexts.values()) {
                    mapper.finish();
                }
            }
        };
    }

    protected boolean updateLayers() {
        return false;
    }

    protected boolean updateLayers(@NotNull DocumentEvent e) {
        return this.updateLayers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void documentChanged(@NotNull DocumentEvent e) {
        boolean changed2 = this.updateLayers(e);
        LayeredLexerEditorHighlighter layeredLexerEditorHighlighter = this;
        synchronized (layeredLexerEditorHighlighter) {
            if (changed2) {
                super.setText(e.getDocument().getImmutableCharSequence());
            } else {
                super.documentChanged(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public HighlighterIterator createIterator(int startOffset) {
        LayeredLexerEditorHighlighter layeredLexerEditorHighlighter = this;
        synchronized (layeredLexerEditorHighlighter) {
            return new LayeredHighlighterIteratorImpl(startOffset);
        }
    }

    @NotNull
    public HighlighterIterator createBaseIterator(int startOffset) {
        return super.createIterator(startOffset);
    }

    @Override
    public void setColorScheme(@NotNull EditorColorsScheme scheme) {
        super.setColorScheme(scheme);
        for (MappedRange mapping2 : this.getSegments().myRanges) {
            Mapper mapper;
            Mapper mapper2 = mapper = mapping2 == null ? null : mapping2.mapper;
            if (mapper == null) continue;
            mapper.resetCachedTextAttributes();
        }
    }

    @Override
    protected boolean hasAdditionalData(int segmentIndex) {
        return this.getSegments().myRanges[segmentIndex] != null;
    }

    private static MappedRange @NotNull [] reallocateArray(MappedRange @NotNull [] array2, int index) {
        if (index < array2.length) {
            return array2;
        }
        return (MappedRange[])ArrayUtil.realloc((Object[])array2, (int)SegmentArray.calcCapacity(array2.length, index), MappedRange[]::new);
    }

    @Override
    public String toString() {
        return this.myText.toString();
    }

    private final class LayeredHighlighterIteratorImpl
    implements LayeredHighlighterIterator {
        private final HighlighterIterator myBaseIterator;
        private HighlighterIterator myLayerIterator;
        private int myLayerStartOffset;
        private Mapper myCurrentMapper;

        private LayeredHighlighterIteratorImpl(int offset) {
            this.myBaseIterator = LayeredLexerEditorHighlighter.this.createBaseIterator(offset);
            if (!this.myBaseIterator.atEnd()) {
                int shift = offset - this.myBaseIterator.getStart();
                this.initLayer(shift);
            }
        }

        private void initLayer(int shiftInToken) {
            if (this.myBaseIterator.atEnd()) {
                this.myLayerIterator = null;
                this.myCurrentMapper = null;
                return;
            }
            MappedRange mapping2 = LayeredLexerEditorHighlighter.this.getSegments().myRanges[((LexerEditorHighlighter.HighlighterIteratorImpl)this.myBaseIterator).currentIndex()];
            if (mapping2 != null) {
                this.myCurrentMapper = mapping2.mapper;
                this.myLayerIterator = this.myCurrentMapper.createIterator(mapping2, shiftInToken);
                this.myLayerStartOffset = this.myBaseIterator.getStart() - mapping2.range.getStartOffset();
            } else {
                this.myCurrentMapper = null;
                this.myLayerIterator = null;
            }
        }

        public TextAttributes getTextAttributes() {
            if (this.myCurrentMapper != null) {
                return this.myCurrentMapper.getAttributes(this.getTokenType());
            }
            return this.myBaseIterator.getTextAttributes();
        }

        @Override
        @NotNull
        public SyntaxHighlighter getActiveSyntaxHighlighter() {
            if (this.myCurrentMapper != null) {
                return this.myCurrentMapper.mySyntaxHighlighter;
            }
            return LayeredLexerEditorHighlighter.this.getSyntaxHighlighter();
        }

        public int getStart() {
            if (this.myLayerIterator != null) {
                return this.myLayerIterator.getStart() + this.myLayerStartOffset;
            }
            return this.myBaseIterator.getStart();
        }

        public int getEnd() {
            if (this.myLayerIterator != null) {
                return this.myLayerIterator.getEnd() + this.myLayerStartOffset;
            }
            return this.myBaseIterator.getEnd();
        }

        public IElementType getTokenType() {
            return this.myLayerIterator != null ? this.myLayerIterator.getTokenType() : this.myBaseIterator.getTokenType();
        }

        public void advance() {
            if (this.myLayerIterator != null) {
                this.myLayerIterator.advance();
                if (!this.myLayerIterator.atEnd()) {
                    return;
                }
            }
            this.myBaseIterator.advance();
            this.initLayer(0);
        }

        public void retreat() {
            if (this.myLayerIterator != null) {
                this.myLayerIterator.retreat();
                if (!this.myLayerIterator.atEnd()) {
                    return;
                }
            }
            this.myBaseIterator.retreat();
            this.initLayer(this.myBaseIterator.atEnd() ? 0 : this.myBaseIterator.getEnd() - this.myBaseIterator.getStart() - 1);
        }

        public boolean atEnd() {
            return this.myBaseIterator.atEnd();
        }

        public Document getDocument() {
            return this.myBaseIterator.getDocument();
        }
    }

    private static class MappedRange {
        private RangeMarker range;
        private final Mapper mapper;
        private final IElementType outerToken;

        MappedRange(@NotNull Mapper mapper, @NotNull RangeMarker range2, @NotNull IElementType outerToken) {
            this.mapper = mapper;
            this.range = range2;
            this.outerToken = outerToken;
            assert (mapper.doc == range2.getDocument());
        }

        public String toString() {
            return "MappedRange{range=" + this.range + ", outerToken=" + this.outerToken + '}';
        }
    }

    private final class Mapper
    implements HighlighterClient {
        private final DocumentImpl doc;
        private final EditorHighlighter highlighter;
        private final String mySeparator;
        private final Map<IElementType, TextAttributes> myAttributesMap = new HashMap<IElementType, TextAttributes>();
        @NotNull
        private final SyntaxHighlighter mySyntaxHighlighter;
        private final TextAttributesKey myBackground;

        private Mapper(LayerDescriptor descriptor2) {
            this.doc = new DocumentImpl("", true);
            this.mySyntaxHighlighter = descriptor2.getLayerHighlighter();
            this.myBackground = descriptor2.getBackgroundKey();
            this.highlighter = new LexerEditorHighlighter(this.mySyntaxHighlighter, LayeredLexerEditorHighlighter.this.getScheme());
            this.mySeparator = descriptor2.getTokenSeparator();
            this.highlighter.setEditor((HighlighterClient)this);
            this.doc.addDocumentListener((DocumentListener)this.highlighter);
        }

        @NotNull
        public TextAttributes getAttributes(IElementType tokenType) {
            TextAttributes attrs = this.myAttributesMap.get(tokenType);
            if (attrs == null) {
                attrs = LayeredLexerEditorHighlighter.this.convertAttributes(SyntaxHighlighterBase.pack((TextAttributesKey)this.myBackground, (TextAttributesKey[])this.mySyntaxHighlighter.getTokenHighlights(tokenType)));
                this.myAttributesMap.put(tokenType, attrs);
            }
            return attrs;
        }

        @NotNull
        public HighlighterIterator createIterator(@NotNull MappedRange mapper, int shift) {
            int rangeStart = mapper.range.getStartOffset();
            int rangeEnd = mapper.range.getEndOffset();
            return new LimitedRangeHighlighterIterator(this.highlighter.createIterator(rangeStart + shift), rangeStart, rangeEnd);
        }

        public Project getProject() {
            return LayeredLexerEditorHighlighter.this.getClient().getProject();
        }

        public void repaint(int start2, int end) {
        }

        public Document getDocument() {
            return LayeredLexerEditorHighlighter.this.getDocument();
        }

        void resetCachedTextAttributes() {
            this.myAttributesMap.clear();
        }

        void updateMapping(int tokenIndex, @NotNull MappedRange oldMapping) {
            CharSequence tokenText = this.getTokenText(tokenIndex);
            int start2 = oldMapping.range.getStartOffset();
            int end = oldMapping.range.getEndOffset();
            if (Comparing.equal((CharSequence)this.doc.getCharsSequence().subSequence(start2, end), (CharSequence)tokenText)) {
                return;
            }
            this.doc.replaceString(start2, end, tokenText);
            int newEnd = start2 + tokenText.length();
            if (oldMapping.range.getStartOffset() != start2 || oldMapping.range.getEndOffset() != newEnd) {
                assert (oldMapping.range.getDocument() == this.doc);
                oldMapping.range.dispose();
                oldMapping.range = this.doc.createRangeMarker(start2, newEnd);
            }
        }

        @NotNull
        private MappedRange insertMapping(int tokenIndex, @NotNull IElementType outerToken) {
            CharSequence tokenText = this.getTokenText(tokenIndex);
            int length = tokenText.length();
            MappedRange predecessor = this.findPredecessor(tokenIndex, LayeredLexerEditorHighlighter.this.getSegments());
            int insertOffset = predecessor != null ? predecessor.range.getEndOffset() : 0;
            this.doc.insertString(insertOffset, (CharSequence)new MergingCharSequence((CharSequence)this.mySeparator, tokenText));
            RangeMarker marker = this.doc.createRangeMarker(insertOffset += this.mySeparator.length(), insertOffset + length);
            return new MappedRange(this, marker, outerToken);
        }

        @NotNull
        private CharSequence getTokenText(int tokenIndex) {
            return LayeredLexerEditorHighlighter.this.myText.subSequence(LayeredLexerEditorHighlighter.this.getSegments().getSegmentStart(tokenIndex), LayeredLexerEditorHighlighter.this.getSegments().getSegmentEnd(tokenIndex));
        }

        @Nullable
        MappedRange findPredecessor(int token, MappingSegments segments) {
            --token;
            while (token >= 0) {
                MappedRange mappedRange = segments.myRanges[token];
                if (mappedRange != null && mappedRange.mapper == this) {
                    return mappedRange;
                }
                --token;
            }
            return null;
        }

        private void removeMapping(@NotNull MappedRange mapping2) {
            RangeMarker rangeMarker = mapping2.range;
            if (rangeMarker.isValid()) {
                int start2 = rangeMarker.getStartOffset();
                int end = rangeMarker.getEndOffset();
                assert (this.doc == rangeMarker.getDocument());
                this.doc.deleteString(start2 - this.mySeparator.length(), end);
                rangeMarker.dispose();
            }
        }
    }

    private final class MappingSegments
    extends SegmentArrayWithData {
        private MappedRange[] myRanges;
        private final Map<LayerDescriptor, Mapper> myLayerBuffers;

        private MappingSegments(DataStorage o) {
            super(o);
            this.myRanges = new MappedRange[64];
            this.myLayerBuffers = new HashMap<LayerDescriptor, Mapper>();
        }

        @Nullable
        Mapper getMappingDocument(@NotNull IElementType token) {
            LayerDescriptor descriptor2 = (LayerDescriptor)LayeredLexerEditorHighlighter.this.myTokensToLayer.get(token);
            if (descriptor2 == null) {
                return null;
            }
            Mapper mapper = this.myLayerBuffers.get(descriptor2);
            if (mapper == null) {
                mapper = new Mapper(descriptor2);
                this.myLayerBuffers.put(descriptor2, mapper);
            }
            return mapper;
        }

        @Override
        public void removeAll() {
            if (this.mySegmentCount != 0) {
                Arrays.fill(this.myRanges, null);
            }
            this.myLayerBuffers.clear();
            super.removeAll();
        }

        @Override
        public void setElementAt(int i2, int startOffset, int endOffset, int data2) {
            this.setElementLight(i2, startOffset, endOffset, data2);
            MappedRange range2 = this.myRanges[i2];
            if (range2 != null) {
                range2.mapper.removeMapping(range2);
                this.myRanges[i2] = null;
            }
            this.updateMappingForToken(i2);
        }

        private void setElementLight(int i2, int startOffset, int endOffset, int data2) {
            super.setElementAt(i2, startOffset, endOffset, data2);
            this.myRanges = LayeredLexerEditorHighlighter.reallocateArray(this.myRanges, i2 + 1);
        }

        @Override
        public void remove(int startIndex, int endIndex) {
            Map mins = FactoryMap.create(key -> Integer.MAX_VALUE);
            Map maxs = FactoryMap.create(key -> 0);
            for (int i2 = startIndex; i2 < endIndex; ++i2) {
                MappedRange range2 = this.myRanges[i2];
                if (range2 != null && range2.range.isValid()) {
                    mins.put(range2.mapper, Math.min((Integer)mins.get(range2.mapper), range2.range.getStartOffset()));
                    maxs.put(range2.mapper, Math.max((Integer)maxs.get(range2.mapper), range2.range.getEndOffset()));
                }
                this.myRanges[i2] = null;
            }
            for (Map.Entry entry : maxs.entrySet()) {
                Mapper mapper = (Mapper)entry.getKey();
                mapper.doc.deleteString((Integer)mins.get(mapper), (Integer)entry.getValue());
            }
            this.removeRange(this.myRanges, startIndex, endIndex);
            super.remove(startIndex, endIndex);
        }

        @Override
        public void replace(int startOffset, @NotNull SegmentArrayWithData data2, int len) {
            super.replace(startOffset, data2, len);
            for (int i2 = startOffset; i2 < startOffset + len; ++i2) {
                this.updateMappingForToken(i2);
            }
        }

        private MappedRange @NotNull [] insert(MappedRange @NotNull [] array2, MappedRange @NotNull [] insertArray, int startIndex, int insertLength) {
            MappedRange[] newArray = LayeredLexerEditorHighlighter.reallocateArray(array2, this.mySegmentCount + insertLength);
            if (startIndex < this.mySegmentCount) {
                System.arraycopy(newArray, startIndex, newArray, startIndex + insertLength, this.mySegmentCount - startIndex);
            }
            System.arraycopy(insertArray, 0, newArray, startIndex, insertLength);
            return newArray;
        }

        private <T> void removeRange(T @NotNull [] array2, int startIndex, int endIndex) {
            if (endIndex < this.mySegmentCount) {
                System.arraycopy(array2, endIndex, array2, startIndex, this.mySegmentCount - endIndex);
            }
            Arrays.fill(array2, this.mySegmentCount - (endIndex - startIndex), this.mySegmentCount, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void insert(@NotNull SegmentArrayWithData segmentArray, int startIndex) {
            LayeredLexerEditorHighlighter layeredLexerEditorHighlighter = LayeredLexerEditorHighlighter.this;
            synchronized (layeredLexerEditorHighlighter) {
                super.insert(segmentArray, startIndex);
                int newCount = segmentArray.getSegmentCount();
                MappedRange[] newRanges = new MappedRange[newCount];
                this.myRanges = this.insert(this.myRanges, newRanges, startIndex, newCount);
                int endIndex = startIndex + segmentArray.getSegmentCount();
                LexerEditorHighlighter.TokenProcessor processor2 = LayeredLexerEditorHighlighter.this.createTokenProcessor(startIndex, LayeredLexerEditorHighlighter.this.getSegments(), LayeredLexerEditorHighlighter.this.myText);
                for (int i2 = startIndex; i2 < endIndex; ++i2) {
                    int data2 = this.getSegmentData(i2);
                    IElementType token = LayeredLexerEditorHighlighter.this.getSegments().unpackTokenFromData(data2);
                    processor2.addToken(i2, this.getSegmentStart(i2), this.getSegmentEnd(i2), data2, token);
                }
                processor2.finish();
            }
        }

        private void updateMappingForToken(int i2) {
            int data2 = this.getSegmentData(i2);
            IElementType token = LayeredLexerEditorHighlighter.this.getSegments().unpackTokenFromData(data2);
            Mapper mapper = this.getMappingDocument(token);
            MappedRange oldMapping = this.myRanges[i2];
            if (mapper != null) {
                if (oldMapping != null) {
                    if (oldMapping.mapper == mapper && oldMapping.outerToken == token) {
                        mapper.updateMapping(i2, oldMapping);
                    } else {
                        oldMapping.mapper.removeMapping(oldMapping);
                        this.myRanges[i2] = mapper.insertMapping(i2, token);
                    }
                } else {
                    this.myRanges[i2] = mapper.insertMapping(i2, token);
                }
            } else if (oldMapping != null) {
                oldMapping.mapper.removeMapping(oldMapping);
                this.myRanges[i2] = null;
            }
        }
    }

    private class LightMapper {
        final Mapper mapper;
        final StringBuilder text = new StringBuilder();
        final IntArrayList lengths = new IntArrayList();
        final List<IElementType> tokenTypes = new ArrayList<IElementType>();
        final TIntIntHashMap index2Global = new TIntIntHashMap();
        private final String mySeparator;
        final int insertOffset;

        LightMapper(Mapper mapper, int insertOffset) {
            this.mapper = mapper;
            this.mySeparator = mapper.mySeparator;
            this.insertOffset = insertOffset;
        }

        void addToken(@NotNull CharSequence tokenText, @NotNull IElementType tokenType, int globalIndex) {
            this.index2Global.put(this.tokenTypes.size(), globalIndex);
            this.text.append(this.mySeparator).append(tokenText);
            this.lengths.add(tokenText.length());
            this.tokenTypes.add(tokenType);
        }

        void finish() {
            assert (this.insertOffset >= 0);
            DocumentImpl document = this.mapper.doc;
            document.insertString(this.insertOffset, this.text);
            int start2 = this.insertOffset;
            for (int i2 = 0; i2 < this.tokenTypes.size(); ++i2) {
                IElementType type = this.tokenTypes.get(i2);
                int len = this.lengths.getInt(i2);
                int globalIndex = this.index2Global.get(i2);
                MappedRange[] ranges = LayeredLexerEditorHighlighter.this.getSegments().myRanges;
                this.checkNull(type, ranges[globalIndex]);
                ranges[globalIndex] = new MappedRange(this.mapper, document.createRangeMarker(start2 += this.mySeparator.length(), start2 + len), type);
                start2 += len;
            }
        }

        private void checkNull(@NotNull IElementType type, @Nullable MappedRange range2) {
            if (range2 != null) {
                Document mainDocument = LayeredLexerEditorHighlighter.this.getDocument();
                VirtualFile file2 = mainDocument == null ? null : FileDocumentManager.getInstance().getFile(mainDocument);
                LOG.error("Expected null range on " + type + ", found " + range2 + "; highlighter=" + LayeredLexerEditorHighlighter.this.getSyntaxHighlighter(), new Attachment[]{new Attachment(file2 != null ? file2.getName() : "editorText.txt", LayeredLexerEditorHighlighter.this.myText.toString())});
            }
        }
    }
}

