/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.ex.util;

import com.intellij.diagnostic.AttachmentFactory;
import com.intellij.diagnostic.Dumpable;
import com.intellij.ide.ui.UISettings;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretActionListener;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.SoftWrap;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.ComplementaryFontsRegistry;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.openapi.editor.impl.ScrollingModelImpl;
import com.intellij.openapi.editor.impl.view.VisualLinesIterator;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.editor.textarea.TextComponentEditor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.TextEditorImpl;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ScalableIcon;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.DocumentUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JPasswordField;
import javax.swing.JScrollBar;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EditorUtil {
    private static final Logger LOG = Logger.getInstance(EditorUtil.class);

    private EditorUtil() {
    }

    public static boolean isRealFileEditor(@Nullable Editor editor) {
        return editor != null && TextEditorProvider.getInstance().getTextEditor(editor) instanceof TextEditorImpl;
    }

    public static boolean isPasswordEditor(@Nullable Editor editor) {
        return editor != null && editor.getContentComponent() instanceof JPasswordField;
    }

    @Nullable
    public static EditorEx getEditorEx(@Nullable FileEditor fileEditor) {
        Editor editor = fileEditor instanceof TextEditor ? ((TextEditor)fileEditor).getEditor() : null;
        return editor instanceof EditorEx ? (EditorEx)editor : null;
    }

    public static int getLastVisualLineColumnNumber(@NotNull Editor editor, int line) {
        if (editor instanceof EditorImpl) {
            EditorImpl editorImpl = (EditorImpl)editor;
            int lineEndOffset = line >= editorImpl.getVisibleLineCount() ? editor.getDocument().getTextLength() : new VisualLinesIterator(editorImpl, line).getVisualLineEndOffset();
            return editor.offsetToVisualPosition((int)lineEndOffset, (boolean)true, (boolean)true).column;
        }
        Document document = editor.getDocument();
        int lastLine = document.getLineCount() - 1;
        if (lastLine < 0) {
            return 0;
        }
        VisualPosition visStart = new VisualPosition(line, 0);
        LogicalPosition logStart = editor.visualToLogicalPosition(visStart);
        int lastLogLine = logStart.line;
        while (lastLogLine < document.getLineCount() - 1) {
            logStart = new LogicalPosition(logStart.line + 1, logStart.column);
            VisualPosition tryVisible = editor.logicalToVisualPosition(logStart);
            if (tryVisible.line != visStart.line) break;
            lastLogLine = logStart.line;
        }
        int resultLogLine = Math.min(lastLogLine, lastLine);
        VisualPosition resVisStart = editor.offsetToVisualPosition(document.getLineStartOffset(resultLogLine));
        VisualPosition resVisEnd = editor.offsetToVisualPosition(document.getLineEndOffset(resultLogLine));
        if (resVisStart.line == resVisEnd.line) {
            return resVisEnd.column;
        }
        int visualLinesToSkip = line - resVisStart.line;
        List softWraps = editor.getSoftWrapModel().getSoftWrapsForLine(resultLogLine);
        for (int i2 = 0; i2 < softWraps.size(); ++i2) {
            SoftWrap softWrap = (SoftWrap)softWraps.get(i2);
            CharSequence text = document.getCharsSequence();
            if (visualLinesToSkip <= 0) {
                VisualPosition visual = editor.offsetToVisualPosition(softWrap.getStart() - 1);
                int result2 = visual.column;
                int x = editor.visualPositionToXY((VisualPosition)visual).x;
                return result2 + EditorUtil.textWidthInColumns(editor, text, softWrap.getStart() - 1, softWrap.getStart(), x);
            }
            int softWrapLineFeeds = StringUtil.countNewLines((CharSequence)softWrap.getText());
            if (softWrapLineFeeds < visualLinesToSkip) {
                visualLinesToSkip -= softWrapLineFeeds;
                continue;
            }
            if (softWrapLineFeeds == visualLinesToSkip) {
                if (i2 >= softWraps.size() - 1) {
                    return resVisEnd.column;
                }
                SoftWrap nextSoftWrap = (SoftWrap)softWraps.get(i2 + 1);
                VisualPosition visual = editor.offsetToVisualPosition(nextSoftWrap.getStart() - 1);
                int result3 = visual.column;
                int x = editor.visualPositionToXY((VisualPosition)visual).x;
                result3 += EditorUtil.textWidthInColumns(editor, text, nextSoftWrap.getStart() - 1, nextSoftWrap.getStart(), x);
                int lineFeedIndex = StringUtil.indexOf((CharSequence)nextSoftWrap.getText(), (char)'\n');
                return result3 += EditorUtil.textWidthInColumns(editor, nextSoftWrap.getText(), 0, lineFeedIndex, 0);
            }
            int softWrapStartOffset = 0;
            int softWrapEndOffset = 0;
            int softWrapTextLength = softWrap.getText().length();
            while (visualLinesToSkip-- > 0) {
                softWrapStartOffset = softWrapEndOffset + 1;
                if (softWrapStartOffset >= softWrapTextLength) {
                    assert (false);
                    return resVisEnd.column;
                }
                softWrapEndOffset = StringUtil.indexOf((CharSequence)softWrap.getText(), (char)'\n', (int)softWrapStartOffset, (int)softWrapTextLength);
                if (softWrapEndOffset >= 0) continue;
                assert (false);
                return resVisEnd.column;
            }
            VisualPosition visual = editor.offsetToVisualPosition(softWrap.getStart() - 1);
            int result4 = visual.column;
            int x = editor.visualPositionToXY((VisualPosition)visual).x;
            result4 += EditorUtil.textWidthInColumns(editor, text, softWrap.getStart() - 1, softWrap.getStart(), x);
            return result4 += EditorUtil.calcColumnNumber(editor, softWrap.getText(), softWrapStartOffset, softWrapEndOffset);
        }
        String editorInfo = "editor's class: " + editor.getClass() + ", all soft wraps: " + editor.getSoftWrapModel().getSoftWrapsForRange(0, document.getTextLength()) + ", fold regions: " + Arrays.toString(editor.getFoldingModel().getAllFoldRegions());
        LOG.error("Can't calculate last visual column", new Throwable(), new Attachment[]{AttachmentFactory.createContext(String.format("Target visual line: %d, mapped logical line: %d, visual lines range for the mapped logical line: [%s]-[%s], soft wraps for the target logical line: %s. Editor info: %s", line, resultLogLine, resVisStart, resVisEnd, softWraps, editorInfo), new Object[0])});
        return resVisEnd.column;
    }

    public static int getVisualLineEndOffset(@NotNull Editor editor, int line) {
        VisualPosition endLineVisualPosition = new VisualPosition(line, EditorUtil.getLastVisualLineColumnNumber(editor, line));
        return editor.visualPositionToOffset(endLineVisualPosition);
    }

    public static float calcVerticalScrollProportion(@NotNull Editor editor) {
        Rectangle viewArea = editor.getScrollingModel().getVisibleAreaOnScrollingFinished();
        if (viewArea.height == 0) {
            return 0.0f;
        }
        LogicalPosition pos = editor.getCaretModel().getLogicalPosition();
        Point location = editor.logicalPositionToXY(pos);
        return (float)(location.y - viewArea.y) / (float)viewArea.height;
    }

    public static void setVerticalScrollProportion(@NotNull Editor editor, float proportion) {
        Rectangle viewArea = editor.getScrollingModel().getVisibleArea();
        LogicalPosition caretPosition = editor.getCaretModel().getLogicalPosition();
        Point caretLocation = editor.logicalPositionToXY(caretPosition);
        int yPos = caretLocation.y;
        yPos = (int)((float)yPos - (float)viewArea.height * proportion);
        editor.getScrollingModel().scrollVertically(yPos);
    }

    public static int calcRelativeCaretPosition(@NotNull Editor editor) {
        int caretY = editor.visualLineToY(editor.getCaretModel().getVisualPosition().line);
        int viewAreaPosition = editor.getScrollingModel().getVisibleAreaOnScrollingFinished().y;
        return caretY - viewAreaPosition;
    }

    public static void setRelativeCaretPosition(@NotNull Editor editor, int position) {
        int caretY = editor.visualLineToY(editor.getCaretModel().getVisualPosition().line);
        editor.getScrollingModel().scrollVertically(caretY - position);
    }

    public static void fillVirtualSpaceUntilCaret(@NotNull Editor editor) {
        LogicalPosition position = editor.getCaretModel().getLogicalPosition();
        EditorUtil.fillVirtualSpaceUntil(editor, position.column, position.line);
    }

    public static void fillVirtualSpaceUntil(@NotNull Editor editor, int columnNumber, int lineNumber) {
        int offset = editor.logicalPositionToOffset(new LogicalPosition(lineNumber, columnNumber));
        String filler = EditorModificationUtil.calcStringToFillVirtualSpace((Editor)editor);
        if (!filler.isEmpty()) {
            WriteAction.run(() -> {
                editor.getDocument().insertString(offset, (CharSequence)filler);
                editor.getCaretModel().moveToOffset(offset + filler.length());
            });
        }
    }

    private static int getTabLength(int colNumber, int tabSize) {
        if (tabSize <= 0) {
            tabSize = 1;
        }
        return tabSize - colNumber % tabSize;
    }

    public static int calcColumnNumber(@NotNull Editor editor, @NotNull CharSequence text, int start2, int offset) {
        return EditorUtil.calcColumnNumber(editor, text, start2, offset, EditorUtil.getTabSize(editor));
    }

    public static int calcColumnNumber(@Nullable Editor editor, @NotNull CharSequence text, int start2, int offset, int tabSize) {
        int i2;
        if (editor instanceof TextComponentEditor) {
            return offset - start2;
        }
        boolean useOptimization = true;
        if (editor != null) {
            SoftWrap softWrap = editor.getSoftWrapModel().getSoftWrap(start2);
            boolean bl = useOptimization = softWrap == null;
        }
        if (useOptimization) {
            boolean hasNonTabs = false;
            for (i2 = start2; i2 < offset; ++i2) {
                if (text.charAt(i2) == '\t') {
                    if (!hasNonTabs) continue;
                    useOptimization = false;
                    break;
                }
                hasNonTabs = true;
            }
        }
        if (editor != null && useOptimization) {
            Document document = editor.getDocument();
            if (start2 < offset - 1 && document.getLineNumber(start2) != document.getLineNumber(offset - 1)) {
                String editorInfo = editor instanceof EditorImpl ? ". Editor info: " + ((EditorImpl)editor).dumpState() : "";
                String documentInfo = text instanceof Dumpable ? ((Dumpable)text).dumpState() : "Text holder class: " + text.getClass();
                LOG.error("detected incorrect offset -> column number calculation", new Throwable(), new Attachment[]{AttachmentFactory.createContext("start: " + start2 + ", given offset: " + offset + ", given tab size: " + tabSize + ". " + documentInfo + editorInfo, new Object[0])});
            }
        }
        int shift = 0;
        for (i2 = start2; i2 < offset; ++i2) {
            char c = text.charAt(i2);
            if (c != '\t') continue;
            shift += EditorUtil.getTabLength(i2 + shift - start2, tabSize) - 1;
        }
        return offset - start2 + shift;
    }

    @NotNull
    public static FontInfo fontForChar(char c, @JdkConstants.FontStyle int style, @NotNull Editor editor) {
        EditorColorsScheme colorsScheme = editor.getColorsScheme();
        return ComplementaryFontsRegistry.getFontAbleToDisplay(c, style, colorsScheme.getFontPreferences(), FontInfo.getFontRenderContext(editor.getContentComponent()));
    }

    public static Icon scaleIconAccordingEditorFont(Icon icon2, Editor editor) {
        float scale;
        if (Registry.is((String)"editor.scale.gutter.icons") && editor instanceof EditorImpl && icon2 instanceof ScalableIcon && Math.abs(1.0f - (scale = ((EditorImpl)editor).getScale())) > 0.1f) {
            return ((ScalableIcon)icon2).scale(scale);
        }
        return icon2;
    }

    public static int charWidth(char c, @JdkConstants.FontStyle int fontType, @NotNull Editor editor) {
        return EditorUtil.fontForChar(c, fontType, editor).charWidth(c);
    }

    public static int getSpaceWidth(@JdkConstants.FontStyle int fontType, @NotNull Editor editor) {
        int width = EditorUtil.charWidth(' ', fontType, editor);
        return width > 0 ? width : 1;
    }

    public static int getPlainSpaceWidth(@NotNull Editor editor) {
        return EditorUtil.getSpaceWidth(0, editor);
    }

    public static int getTabSize(@NotNull Editor editor) {
        return editor.getSettings().getTabSize(editor.getProject());
    }

    public static int nextTabStop(int x, @NotNull Editor editor) {
        int tabSize = EditorUtil.getTabSize(editor);
        if (tabSize <= 0) {
            tabSize = 1;
        }
        return EditorUtil.nextTabStop(x, editor, tabSize);
    }

    public static int nextTabStop(int x, @NotNull Editor editor, int tabSize) {
        int leftInset = editor.getContentComponent().getInsets().left;
        return EditorUtil.nextTabStop(x - leftInset, EditorUtil.getSpaceWidth(0, editor), tabSize) + leftInset;
    }

    public static int nextTabStop(int x, int plainSpaceWidth, int tabSize) {
        if (tabSize <= 0) {
            return x + plainSpaceWidth;
        }
        int nTabs = x / (tabSize *= plainSpaceWidth);
        return (nTabs + 1) * tabSize;
    }

    public static float nextTabStop(float x, float plainSpaceWidth, int tabSize) {
        if (tabSize <= 0) {
            return x + plainSpaceWidth;
        }
        float tabSizePixels = (float)tabSize * plainSpaceWidth;
        int nTabs = (int)((x + plainSpaceWidth / 2.0f) / tabSizePixels);
        return (float)(nTabs + 1) * tabSizePixels;
    }

    public static int textWidthInColumns(@NotNull Editor editor, @NotNull CharSequence text, int start2, int end, int x) {
        int startToUse = start2;
        int lastTabSymbolIndex = -1;
        block8: for (int i2 = end - 1; i2 >= start2; --i2) {
            switch (text.charAt(i2)) {
                case '\n': {
                    startToUse = i2 + 1;
                    break block8;
                }
                case '\t': {
                    if (lastTabSymbolIndex < 0) {
                        lastTabSymbolIndex = i2;
                    }
                }
                default: {
                    continue block8;
                }
            }
        }
        if (lastTabSymbolIndex < 0) {
            return end - startToUse;
        }
        int result2 = 0;
        int spaceSize = EditorUtil.getSpaceWidth(0, editor);
        block9: for (int i3 = startToUse; i3 <= lastTabSymbolIndex; ++i3) {
            SoftWrap softWrap = editor.getSoftWrapModel().getSoftWrap(i3);
            if (softWrap != null) {
                x = softWrap.getIndentInPixels();
            }
            char c = text.charAt(i3);
            int prevX = x;
            switch (c) {
                case '\t': {
                    x = EditorUtil.nextTabStop(x, editor);
                    result2 += EditorUtil.columnsNumber(x - prevX, spaceSize);
                    continue block9;
                }
                case '\n': {
                    result2 = 0;
                    x = 0;
                    continue block9;
                }
                default: {
                    x += EditorUtil.charWidth(c, 0, editor);
                    ++result2;
                }
            }
        }
        return result2 += end - lastTabSymbolIndex - 1;
    }

    public static int columnsNumber(int width, int plainSpaceSize) {
        int result2 = width / plainSpaceSize;
        if (width % plainSpaceSize > 0) {
            ++result2;
        }
        return result2;
    }

    public static int columnsNumber(float width, float plainSpaceSize) {
        return (int)Math.ceil(width / plainSpaceSize);
    }

    public static int textWidth(@NotNull Editor editor, @NotNull CharSequence text, int start2, int end, @JdkConstants.FontStyle int fontType, int x) {
        int result2 = 0;
        for (int i2 = start2; i2 < end; ++i2) {
            char c = text.charAt(i2);
            if (c != '\t') {
                FontInfo font = EditorUtil.fontForChar(c, fontType, editor);
                result2 += font.charWidth(c);
                continue;
            }
            result2 += EditorUtil.nextTabStop(x + result2, editor) - result2 - x;
        }
        return result2;
    }

    public static Pair<LogicalPosition, LogicalPosition> calcCaretLineRange(@NotNull Editor editor) {
        return EditorUtil.calcSurroundingRange(editor, editor.getCaretModel().getVisualPosition(), editor.getCaretModel().getVisualPosition());
    }

    public static Pair<LogicalPosition, LogicalPosition> calcCaretLineRange(@NotNull Caret caret) {
        return EditorUtil.calcSurroundingRange(caret.getEditor(), caret.getVisualPosition(), caret.getVisualPosition());
    }

    public static Pair<LogicalPosition, LogicalPosition> calcSurroundingRange(@NotNull Editor editor, @NotNull VisualPosition start2, @NotNull VisualPosition end) {
        Document document = editor.getDocument();
        FoldingModel foldingModel = editor.getFoldingModel();
        LogicalPosition first = editor.visualToLogicalPosition(new VisualPosition(start2.line, 0));
        int line = first.line;
        int offset = document.getLineStartOffset(line);
        while (offset >= 0) {
            FoldRegion foldRegion = foldingModel.getCollapsedRegionAtOffset(offset);
            if (foldRegion == null) {
                first = new LogicalPosition(line, 0);
                break;
            }
            int foldEndLine = document.getLineNumber(foldRegion.getStartOffset());
            if (foldEndLine <= line) {
                first = new LogicalPosition(line, 0);
                break;
            }
            line = foldEndLine;
            offset = document.getLineStartOffset(line);
        }
        LogicalPosition second = editor.visualToLogicalPosition(new VisualPosition(end.line, 0));
        int line2 = second.line;
        int offset2 = document.getLineEndOffset(line2);
        while (offset2 <= document.getTextLength()) {
            FoldRegion foldRegion = foldingModel.getCollapsedRegionAtOffset(offset2);
            if (foldRegion == null) {
                second = new LogicalPosition(line2 + 1, 0);
                break;
            }
            int foldEndLine = document.getLineNumber(foldRegion.getEndOffset());
            if (foldEndLine <= line2) {
                second = new LogicalPosition(line2 + 1, 0);
                break;
            }
            line2 = foldEndLine;
            offset2 = document.getLineEndOffset(line2);
        }
        if (second.line >= document.getLineCount()) {
            second = editor.offsetToLogicalPosition(document.getTextLength());
        }
        return Pair.create((Object)first, (Object)second);
    }

    public static int getNotFoldedLineStartOffset(@NotNull Editor editor, int offset) {
        return EditorUtil.getNotFoldedLineStartOffset(editor, offset, false);
    }

    public static int getNotFoldedLineStartOffset(@NotNull Editor editor, int offset, boolean stopAtInvisibleFoldRegions) {
        while (true) {
            offset = DocumentUtil.getLineStartOffset(offset, editor.getDocument());
            FoldRegion foldRegion = editor.getFoldingModel().getCollapsedRegionAtOffset(offset - 1);
            if (foldRegion == null || stopAtInvisibleFoldRegions && foldRegion.getPlaceholderText().isEmpty() || foldRegion.getStartOffset() >= offset) break;
            offset = foldRegion.getStartOffset();
        }
        return offset;
    }

    public static int getNotFoldedLineEndOffset(@NotNull Editor editor, int offset) {
        return EditorUtil.getNotFoldedLineEndOffset(editor, offset, false);
    }

    public static int getNotFoldedLineEndOffset(@NotNull Editor editor, int offset, boolean stopAtInvisibleFoldRegions) {
        while (true) {
            offset = EditorUtil.getLineEndOffset(offset, editor.getDocument());
            FoldRegion foldRegion = editor.getFoldingModel().getCollapsedRegionAtOffset(offset);
            if (foldRegion == null || stopAtInvisibleFoldRegions && foldRegion.getPlaceholderText().isEmpty() || foldRegion.getEndOffset() <= offset) break;
            offset = foldRegion.getEndOffset();
        }
        return offset;
    }

    private static int getLineEndOffset(int offset, Document document) {
        if (offset >= document.getTextLength()) {
            return offset;
        }
        int lineNumber = document.getLineNumber(offset);
        return document.getLineEndOffset(lineNumber);
    }

    public static void scrollToTheEnd(@NotNull Editor editor) {
        EditorUtil.scrollToTheEnd(editor, false);
    }

    public static void scrollToTheEnd(@NotNull Editor editor, boolean preferVerticalScroll) {
        editor.getSelectionModel().removeSelection();
        Document document = editor.getDocument();
        int lastLine = Math.max(0, document.getLineCount() - 1);
        boolean caretWasAtLastLine = editor.getCaretModel().getLogicalPosition().line == lastLine;
        editor.getCaretModel().moveToOffset(document.getTextLength());
        ScrollingModel scrollingModel = editor.getScrollingModel();
        if (preferVerticalScroll && document.getLineStartOffset(lastLine) == document.getLineEndOffset(lastLine)) {
            int scrollOffset;
            if (editor instanceof EditorEx) {
                JScrollBar verticalScrollBar = ((EditorEx)editor).getScrollPane().getVerticalScrollBar();
                scrollOffset = verticalScrollBar.getMaximum() - verticalScrollBar.getModel().getExtent();
            } else {
                scrollOffset = editor.getContentComponent().getHeight() - scrollingModel.getVisibleArea().height;
            }
            scrollingModel.scrollVertically(scrollOffset);
        } else if (!caretWasAtLastLine) {
            scrollingModel.scrollTo(new LogicalPosition(lastLine, 0), ScrollType.RELATIVE);
        } else {
            scrollingModel.scrollToCaret(ScrollType.RELATIVE);
        }
    }

    public static boolean isChangeFontSize(@NotNull MouseWheelEvent e) {
        if (e.getWheelRotation() == 0) {
            return false;
        }
        return SystemInfo.isMac ? !e.isControlDown() && e.isMetaDown() && !e.isAltDown() && !e.isShiftDown() : e.isControlDown() && !e.isMetaDown() && !e.isAltDown() && !e.isShiftDown();
    }

    public static boolean isCaretInVirtualSpace(@NotNull Editor editor) {
        return EditorUtil.inVirtualSpace(editor, editor.getCaretModel().getLogicalPosition());
    }

    public static boolean inVirtualSpace(@NotNull Editor editor, @NotNull LogicalPosition logicalPosition) {
        return !editor.offsetToLogicalPosition(editor.logicalPositionToOffset(logicalPosition)).equals((Object)logicalPosition);
    }

    public static void reinitSettings() {
        EditorFactory.getInstance().refreshAllEditors();
    }

    @NotNull
    public static TextRange getSelectionInAnyMode(Editor editor) {
        SelectionModel selection = editor.getSelectionModel();
        int[] starts = selection.getBlockSelectionStarts();
        int[] ends = selection.getBlockSelectionEnds();
        int start2 = starts.length > 0 ? starts[0] : selection.getSelectionStart();
        int end = ends.length > 0 ? ends[ends.length - 1] : selection.getSelectionEnd();
        return TextRange.create((int)start2, (int)end);
    }

    public static int logicalToVisualLine(@NotNull Editor editor, int logicalLine) {
        LogicalPosition logicalPosition = new LogicalPosition(logicalLine, 0);
        VisualPosition visualPosition = editor.logicalToVisualPosition(logicalPosition);
        return visualPosition.line;
    }

    public static int yPositionToLogicalLine(@NotNull Editor editor, @NotNull MouseEvent event) {
        return EditorUtil.yPositionToLogicalLine(editor, event.getY());
    }

    public static int yPositionToLogicalLine(@NotNull Editor editor, @NotNull Point point) {
        return EditorUtil.yPositionToLogicalLine(editor, point.y);
    }

    public static int yPositionToLogicalLine(@NotNull Editor editor, int y) {
        int line = editor instanceof EditorImpl ? editor.yToVisualLine(y) : y / editor.getLineHeight();
        return editor.visualToLogicalPosition((VisualPosition)new VisualPosition((int)line, (int)0)).line;
    }

    public static int yToLogicalLineNoBlockInlays(@NotNull Editor editor, int y) {
        int visualLine = editor.yToVisualLine(y);
        int visualLineStartY = editor.visualLineToY(visualLine);
        if (y < visualLineStartY || y >= visualLineStartY + editor.getLineHeight()) {
            return -1;
        }
        return editor.visualToLogicalPosition((VisualPosition)new VisualPosition((int)visualLine, (int)0)).line;
    }

    public static boolean isAtLineEnd(@NotNull Editor editor, int offset) {
        Document document = editor.getDocument();
        if (offset < 0 || offset > document.getTextLength()) {
            return false;
        }
        int line = document.getLineNumber(offset);
        return offset == document.getLineEndOffset(line);
    }

    public static void setSelectionExpandingFoldedRegionsIfNeeded(@NotNull Editor editor, int startOffset, int endOffset) {
        FoldRegion endFoldRegion;
        FoldingModel foldingModel = editor.getFoldingModel();
        FoldRegion startFoldRegion = foldingModel.getCollapsedRegionAtOffset(startOffset);
        if (startFoldRegion != null && (startFoldRegion.getStartOffset() == startOffset || startFoldRegion.isExpanded())) {
            startFoldRegion = null;
        }
        if ((endFoldRegion = foldingModel.getCollapsedRegionAtOffset(endOffset)) != null && (endFoldRegion.getStartOffset() == endOffset || endFoldRegion.isExpanded())) {
            endFoldRegion = null;
        }
        if (startFoldRegion != null || endFoldRegion != null) {
            FoldRegion finalStartFoldRegion = startFoldRegion;
            FoldRegion finalEndFoldRegion = endFoldRegion;
            foldingModel.runBatchFoldingOperation(() -> {
                if (finalStartFoldRegion != null) {
                    finalStartFoldRegion.setExpanded(true);
                }
                if (finalEndFoldRegion != null) {
                    finalEndFoldRegion.setExpanded(true);
                }
            });
        }
        editor.getSelectionModel().setSelection(startOffset, endOffset);
    }

    public static Font getEditorFont() {
        EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
        int size = UISettings.getInstance().getPresentationMode() ? UISettings.getInstance().getPresentationModeFontSize() - 4 : scheme.getEditorFontSize();
        return UIUtil.getFontWithFallback((String)scheme.getEditorFontName(), (int)0, (int)size);
    }

    public static int getDefaultCaretWidth() {
        return Registry.intValue((String)"editor.caret.width", (int)2);
    }

    public static int getSoftWrapCountAfterLineStart(@NotNull Editor editor, @NotNull LogicalPosition position) {
        int startOffset = editor.getDocument().getLineStartOffset(position.line);
        int endOffset = editor.logicalPositionToOffset(position);
        return editor.getSoftWrapModel().getSoftWrapsForRange(startOffset, endOffset).size();
    }

    public static boolean attributesImpactFontStyleOrColor(@Nullable TextAttributes attributes) {
        return attributes == TextAttributes.ERASE_MARKER || attributes != null && (attributes.getFontType() != 0 || attributes.getForegroundColor() != null);
    }

    public static boolean isCurrentCaretPrimary(@NotNull Editor editor) {
        return editor.getCaretModel().getCurrentCaret() == editor.getCaretModel().getPrimaryCaret();
    }

    public static void disposeWithEditor(@NotNull Editor editor, @NotNull Disposable disposable2) {
        Editor hostEditor;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (Disposer.isDisposed((Disposable)disposable2)) {
            return;
        }
        if (editor.isDisposed()) {
            Disposer.dispose((Disposable)disposable2);
            return;
        }
        Editor editor2 = hostEditor = editor instanceof EditorWindow ? ((EditorWindow)editor).getDelegate() : editor;
        if (hostEditor instanceof EditorImpl) {
            Disposer.register((Disposable)((EditorImpl)hostEditor).getDisposable(), (Disposable)disposable2);
        } else {
            LOG.warn("Cannot watch for disposal of " + editor);
        }
    }

    public static void runBatchFoldingOperationOutsideOfBulkUpdate(final @NotNull Editor editor, final @NotNull Runnable operation) {
        if (editor.getDocument().isInBulkUpdate()) {
            final Disposable disposable2 = Disposer.newDisposable();
            EditorUtil.disposeWithEditor(editor, disposable2);
            editor.getDocument().addDocumentListener(new DocumentListener(){

                public void bulkUpdateFinished(@NotNull Document document) {
                    editor.getFoldingModel().runBatchFoldingOperation(operation);
                    Disposer.dispose((Disposable)disposable2);
                }
            });
        } else {
            editor.getFoldingModel().runBatchFoldingOperation(operation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runWithAnimationDisabled(@NotNull Editor editor, @NotNull Runnable taskWithScrolling) {
        ScrollingModel scrollingModel = editor.getScrollingModel();
        if (!(scrollingModel instanceof ScrollingModelImpl)) {
            taskWithScrolling.run();
        } else {
            boolean animationWasEnabled = ((ScrollingModelImpl)scrollingModel).isAnimationEnabled();
            scrollingModel.disableAnimation();
            try {
                taskWithScrolling.run();
            }
            finally {
                if (animationWasEnabled) {
                    scrollingModel.enableAnimation();
                }
            }
        }
    }

    @NotNull
    public static String displayCharInEditor(char c, @NotNull TextAttributesKey textAttributesKey, @NotNull String fallback) {
        char codePoint = c;
        if (!Character.isValidCodePoint(codePoint)) {
            return fallback;
        }
        EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
        TextAttributes textAttributes = scheme.getAttributes(textAttributesKey);
        int style = textAttributes != null ? textAttributes.getFontType() : 0;
        FontInfo fallbackFont = ComplementaryFontsRegistry.getFontAbleToDisplay(c, style, scheme.getFontPreferences(), null);
        return fallbackFont.canDisplay(codePoint) ? String.valueOf(c) : fallback;
    }

    @NotNull
    public static VisualPosition inlayAwareOffsetToVisualPosition(@NotNull Editor editor, int offset) {
        Inlay inlay;
        LogicalPosition logicalPosition = editor.offsetToLogicalPosition(offset);
        if (editor instanceof EditorWindow) {
            logicalPosition = ((EditorWindow)editor).injectedToHost(logicalPosition);
            editor = ((EditorWindow)editor).getDelegate();
        }
        VisualPosition pos = editor.logicalToVisualPosition(logicalPosition);
        while ((inlay = editor.getInlayModel().getInlineElementAt(pos)) != null && !inlay.isRelatedToPrecedingText()) {
            pos = new VisualPosition(pos.line, pos.column + 1);
        }
        return pos;
    }

    public static int getTotalInlaysHeight(@NotNull List<? extends Inlay> inlays) {
        int sum = 0;
        for (Inlay inlay : inlays) {
            sum += inlay.getHeightInPixels();
        }
        return sum;
    }

    public static int getInlaysHeight(@NotNull Editor editor, int visualLine, boolean above) {
        return EditorUtil.getTotalInlaysHeight(editor.getInlayModel().getBlockElementsForVisualLine(visualLine, above));
    }

    public static boolean isInlayFolded(@NotNull Inlay inlay) {
        Editor editor = inlay.getEditor();
        Inlay.Placement placement = inlay.getPlacement();
        int offset = inlay.getOffset();
        if (placement == Inlay.Placement.AFTER_LINE_END) {
            offset = DocumentUtil.getLineEndOffset(offset, editor.getDocument());
        } else if (!(placement != Inlay.Placement.ABOVE_LINE && placement != Inlay.Placement.BELOW_LINE || inlay.isRelatedToPrecedingText())) {
            --offset;
        }
        return editor.getFoldingModel().isOffsetCollapsed(offset);
    }

    public static int getVisualLineAreaStartY(@NotNull Editor editor, int visualLine) {
        return editor.visualLineToY(visualLine) - EditorUtil.getInlaysHeight(editor, visualLine, true);
    }

    public static int getVisualLineAreaEndY(@NotNull Editor editor, int visualLine) {
        return editor.visualLineToY(visualLine) + editor.getLineHeight() + EditorUtil.getInlaysHeight(editor, visualLine, false);
    }

    public static void addBulkSelectionListener(final @NotNull Editor editor, final @NotNull SelectionListener listener2, @NotNull Disposable disposable2) {
        final Ref selectionBeforeBulkChange = new Ref();
        final Ref selectionChangedDuringBulkChange = new Ref();
        editor.getSelectionModel().addSelectionListener(new SelectionListener(){

            public void selectionChanged(@NotNull SelectionEvent e) {
                if (selectionBeforeBulkChange.isNull()) {
                    listener2.selectionChanged(e);
                } else {
                    selectionChangedDuringBulkChange.set((Object)Boolean.TRUE);
                }
            }
        }, disposable2);
        editor.getCaretModel().addCaretActionListener(new CaretActionListener(){

            public void beforeAllCaretsAction() {
                selectionBeforeBulkChange.set(this.getSelectionOffsets());
                selectionChangedDuringBulkChange.set(null);
            }

            public void afterAllCaretsAction() {
                if (!selectionChangedDuringBulkChange.isNull()) {
                    Pair beforeBulk = (Pair)selectionBeforeBulkChange.get();
                    Pair<int[], int[]> afterBulk = this.getSelectionOffsets();
                    listener2.selectionChanged(new SelectionEvent(editor, (int[])beforeBulk.first, (int[])beforeBulk.second, (int[])afterBulk.first, (int[])afterBulk.second));
                }
                selectionBeforeBulkChange.set(null);
            }

            private Pair<int[], int[]> getSelectionOffsets() {
                return Pair.create((Object)editor.getSelectionModel().getBlockSelectionStarts(), (Object)editor.getSelectionModel().getBlockSelectionEnds());
            }
        }, disposable2);
    }

    public static void performBeforeCommandEnd(final @NotNull Runnable task2) {
        if (CommandProcessor.getInstance().getCurrentCommand() == null) {
            return;
        }
        final MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect();
        connection.subscribe(CommandListener.TOPIC, (Object)new CommandListener(){

            public void beforeCommandFinished(@NotNull CommandEvent event) {
                task2.run();
            }

            public void commandFinished(@NotNull CommandEvent event) {
                connection.disconnect();
            }
        });
    }

    public static boolean isPrimaryCaretVisible(@NotNull Editor editor) {
        Rectangle visibleArea = editor.getScrollingModel().getVisibleArea();
        Caret caret = editor.getCaretModel().getPrimaryCaret();
        Point caretPoint = editor.visualPositionToXY(caret.getVisualPosition());
        return visibleArea.contains(caretPoint);
    }

    public static boolean isPointOverText(@NotNull Editor editor, @NotNull Point point) {
        int offset;
        VisualPosition visualPosition = editor.xyToVisualPosition(point);
        int visualLineStartY = editor.visualLineToY(visualPosition.line);
        if (point.y < visualLineStartY || point.y >= visualLineStartY + editor.getLineHeight()) {
            return false;
        }
        if (editor.getSoftWrapModel().isInsideOrBeforeSoftWrap(visualPosition)) {
            return false;
        }
        LogicalPosition logicalPosition = editor.visualToLogicalPosition(visualPosition);
        if (!logicalPosition.equals((Object)editor.offsetToLogicalPosition(offset = editor.logicalPositionToOffset(logicalPosition)))) {
            return false;
        }
        List inlays = editor.getInlayModel().getInlineElementsInRange(offset, offset);
        if (!inlays.isEmpty()) {
            int relX;
            VisualPosition inlaysStart = editor.offsetToVisualPosition(offset);
            if (inlaysStart.line == visualPosition.line && (relX = point.x - editor.visualPositionToXY((VisualPosition)inlaysStart).x) >= 0 && relX < inlays.stream().mapToInt(i2 -> i2.getWidthInPixels()).sum()) {
                return false;
            }
        }
        return true;
    }
}

