/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors.impl;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontCache;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.colors.impl.AppEditorFontOptions;
import com.intellij.util.ObjectUtils;
import java.awt.Font;
import java.util.EnumMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorFontCacheImpl
extends EditorFontCache {
    @NotNull
    private final Map<EditorFontType, Font> myFonts = new EnumMap<EditorFontType, Font>(EditorFontType.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Font getFont(@Nullable EditorFontType key) {
        Map<EditorFontType, Font> map2 = this.myFonts;
        synchronized (map2) {
            if (this.myFonts.isEmpty()) {
                this.initFonts();
            }
            EditorFontType fontType = (EditorFontType)ObjectUtils.notNull((Object)key, (Object)EditorFontType.PLAIN);
            Font font = this.myFonts.get(fontType);
            assert (font != null) : "Font " + fontType + " not found.";
            UISettings uiSettings = UISettings.getInstance();
            if (uiSettings.getPresentationMode()) {
                return new Font(font.getName(), font.getStyle(), uiSettings.getPresentationModeFontSize());
            }
            return font;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Map<EditorFontType, Font> map2 = this.myFonts;
        synchronized (map2) {
            this.myFonts.clear();
        }
    }

    protected EditorColorsScheme getFontCacheScheme() {
        return EditorColorsManager.getInstance().getGlobalScheme();
    }

    private void initFonts() {
        int editorFontSize;
        EditorColorsScheme scheme = this.getFontCacheScheme();
        String editorFontName = scheme.getFontPreferences().getFontFamily();
        String fallbackName = EditorFontCacheImpl.getFallbackName(editorFontName, editorFontSize = scheme.getEditorFontSize());
        if (fallbackName != null) {
            editorFontName = fallbackName;
        }
        Font plainFont = new Font(editorFontName, 0, editorFontSize);
        Font boldFont = new Font(editorFontName, 1, editorFontSize);
        Font italicFont = new Font(editorFontName, 2, editorFontSize);
        Font boldItalicFont = new Font(editorFontName, 3, editorFontSize);
        this.myFonts.put(EditorFontType.PLAIN, plainFont);
        this.myFonts.put(EditorFontType.BOLD, boldFont);
        this.myFonts.put(EditorFontType.ITALIC, italicFont);
        this.myFonts.put(EditorFontType.BOLD_ITALIC, boldItalicFont);
        String consoleFontName = scheme.getConsoleFontName();
        int consoleFontSize = scheme.getConsoleFontSize();
        Font consolePlainFont = new Font(consoleFontName, 0, consoleFontSize);
        Font consoleBoldFont = new Font(consoleFontName, 1, consoleFontSize);
        Font consoleItalicFont = new Font(consoleFontName, 2, consoleFontSize);
        Font consoleBoldItalicFont = new Font(consoleFontName, 3, consoleFontSize);
        this.myFonts.put(EditorFontType.CONSOLE_PLAIN, consolePlainFont);
        this.myFonts.put(EditorFontType.CONSOLE_BOLD, consoleBoldFont);
        this.myFonts.put(EditorFontType.CONSOLE_ITALIC, consoleItalicFont);
        this.myFonts.put(EditorFontType.CONSOLE_BOLD_ITALIC, consoleBoldItalicFont);
    }

    @Nullable
    private static String getFallbackName(@NotNull String fontName, int fontSize) {
        Font plainFont = new Font(fontName, 0, fontSize);
        if (plainFont.getFamily().equals("Dialog") && !"Dialog".equals(fontName) && !fontName.startsWith("Dialog.")) {
            FontPreferences appPrefs = AppEditorFontOptions.getInstance().getFontPreferences();
            return appPrefs.getFontFamily();
        }
        return null;
    }
}

