/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.ui.JBColor;
import com.intellij.ui.LightweightHint;
import com.intellij.util.Alarm;
import java.awt.Point;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ShowEditorHighlighterTokensAction
extends EditorAction {
    private static final long DELAY = 200L;
    private static boolean ourEscHandlerInstalled;

    private ShowEditorHighlighterTokensAction() {
        super(new EditorActionHandler(){

            protected boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, DataContext dataContext) {
                return editor instanceof EditorEx;
            }

            protected void doExecute(@NotNull Editor editor, @Nullable Caret caret, DataContext dataContext) {
                if (editor.getUserData(Holder.LISTENER_ADDED) != null) {
                    ShowEditorHighlighterTokensAction.cleanup(editor);
                }
                HighlighterIterator it = ((EditorEx)editor).getHighlighter().createIterator(0);
                while (!it.atEnd()) {
                    RangeHighlighter h = editor.getMarkupModel().addRangeHighlighter(it.getStart(), it.getEnd(), 0, Holder.OUR_TEXT_ATTRIBUTES, HighlighterTargetArea.EXACT_RANGE);
                    IElementType tokenType = it.getTokenType();
                    h.putUserData(Holder.TOKEN_NAME, (Object)String.valueOf(tokenType));
                    it.advance();
                }
                editor.addEditorMouseMotionListener(Holder.MOUSE_MOTION_LISTENER);
                editor.putUserData(Holder.LISTENER_ADDED, (Object)true);
                if (!ourEscHandlerInstalled) {
                    ourEscHandlerInstalled = true;
                    EditorActionHandler currentHandler = EditorActionManager.getInstance().getActionHandler("EditorEscape");
                    EditorActionManager.getInstance().setActionHandler("EditorEscape", (EditorActionHandler)new EscapeHandler(currentHandler));
                }
            }
        });
    }

    private static void cleanup(Editor editor) {
        editor.putUserData(Holder.LISTENER_ADDED, null);
        editor.removeEditorMouseMotionListener(Holder.MOUSE_MOTION_LISTENER);
        for (RangeHighlighter rangeHighlighter : editor.getMarkupModel().getAllHighlighters()) {
            if (rangeHighlighter.getUserData(Holder.TOKEN_NAME) == null) continue;
            rangeHighlighter.dispose();
        }
    }

    private static class EscapeHandler
    extends EditorActionHandler {
        private final EditorActionHandler myDelegate;

        private EscapeHandler(EditorActionHandler delegate) {
            this.myDelegate = delegate;
        }

        protected boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, DataContext dataContext) {
            Editor hostEditor = editor instanceof EditorWindow ? ((EditorWindow)editor).getDelegate() : editor;
            return hostEditor.getUserData(Holder.LISTENER_ADDED) != null || this.myDelegate.isEnabled(editor, caret, dataContext);
        }

        protected void doExecute(@NotNull Editor editor, @Nullable Caret caret, DataContext dataContext) {
            Editor hostEditor;
            Editor editor2 = hostEditor = editor instanceof EditorWindow ? ((EditorWindow)editor).getDelegate() : editor;
            if (hostEditor.getUserData(Holder.LISTENER_ADDED) != null) {
                ShowEditorHighlighterTokensAction.cleanup(hostEditor);
            } else {
                this.myDelegate.execute(editor, caret, dataContext);
            }
        }
    }

    private static class Holder {
        private static final Key<String> TOKEN_NAME = Key.create((String)"token.name");
        private static final Key<Boolean> LISTENER_ADDED = Key.create((String)"token.mouse.listener.added");
        private static final TextAttributes OUR_TEXT_ATTRIBUTES = new TextAttributes(null, null, JBColor.MAGENTA, EffectType.ROUNDED_BOX, 0);
        private static final Alarm ourAlarm = new Alarm();
        private static final EditorMouseMotionListener MOUSE_MOTION_LISTENER = new EditorMouseMotionListener(){

            public void mouseMoved(@NotNull EditorMouseEvent e) {
                if (e.getArea() != EditorMouseEventArea.EDITING_AREA || !e.isOverText()) {
                    return;
                }
                Editor editor = e.getEditor();
                LogicalPosition logicalPosition = e.getLogicalPosition();
                int offset = e.getOffset();
                for (RangeHighlighter highlighter : editor.getMarkupModel().getAllHighlighters()) {
                    String text = (String)highlighter.getUserData(TOKEN_NAME);
                    if (StringUtil.isEmpty((String)text) || !(highlighter.getStartOffset() < offset && highlighter.getEndOffset() > offset || !logicalPosition.leansForward && highlighter.getEndOffset() == offset) && (!logicalPosition.leansForward || highlighter.getStartOffset() != offset)) continue;
                    int hintOffset = highlighter.getStartOffset();
                    ourAlarm.cancelAllRequests();
                    ourAlarm.addRequest(() -> {
                        LightweightHint hint = new LightweightHint(HintUtil.createInformationLabel(text));
                        Point point = HintManagerImpl.getHintPosition(hint, editor, editor.offsetToLogicalPosition(hintOffset).leanForward(true), (short)1);
                        ((HintManagerImpl)HintManager.getInstance()).showEditorHint(hint, editor, point, 0, 0, false);
                    }, 200L);
                    break;
                }
            }
        };

        private Holder() {
        }
    }
}

