/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.ex.EditorEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EscapeAction
extends EditorAction {
    public EscapeAction() {
        super((EditorActionHandler)new Handler());
        this.setInjectedContext(true);
    }

    private static class Handler
    extends EditorActionHandler {
        private Handler() {
        }

        public void doExecute(@NotNull Editor editor, @Nullable Caret caret, DataContext dataContext) {
            EditorEx editorEx;
            if (editor instanceof EditorEx && (editorEx = (EditorEx)editor).isStickySelection()) {
                editorEx.setStickySelection(false);
            }
            boolean scrollNeeded = editor.getCaretModel().getCaretCount() > 1;
            Handler.retainOldestCaret(editor.getCaretModel());
            editor.getSelectionModel().removeSelection();
            if (scrollNeeded) {
                editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            }
        }

        private static void retainOldestCaret(CaretModel caretModel) {
            while (caretModel.getCaretCount() > 1) {
                caretModel.removeCaret(caretModel.getPrimaryCaret());
            }
        }

        public boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, DataContext dataContext) {
            if (editor.isOneLineMode() && Boolean.TRUE.equals(PlatformDataKeys.IS_MODAL_CONTEXT.getData(dataContext))) {
                return false;
            }
            SelectionModel selectionModel = editor.getSelectionModel();
            CaretModel caretModel = editor.getCaretModel();
            return selectionModel.hasSelection() || caretModel.getCaretCount() > 1;
        }
    }
}

