/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.settings;

import com.intellij.application.options.colors.ColorAndFontSettingsListener;
import com.intellij.application.options.colors.PreviewPanel;
import com.intellij.diff.DiffContext;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.simple.SimpleThreesideDiffChange;
import com.intellij.diff.tools.simple.SimpleThreesideDiffViewer;
import com.intellij.diff.tools.util.base.HighlightPolicy;
import com.intellij.diff.tools.util.base.IgnorePolicy;
import com.intellij.diff.tools.util.base.TextDiffSettingsHolder;
import com.intellij.diff.util.DiffLineSeparatorRenderer;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.TextDiffTypeFactory;
import com.intellij.diff.util.ThreeSide;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.impl.settings.DiffPreviewProvider;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Cursor;
import java.util.Arrays;
import java.util.EventListener;
import java.util.List;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DiffPreviewPanel
implements PreviewPanel {
    private final JPanel myPanel;
    private final MyViewer myViewer;
    private final EventDispatcher<ColorAndFontSettingsListener> myDispatcher = EventDispatcher.create(ColorAndFontSettingsListener.class);

    DiffPreviewPanel() {
        this.myViewer = new MyViewer();
        this.myViewer.init();
        for (ThreeSide side : ThreeSide.values()) {
            EditorMouseListener motionListener = new EditorMouseListener(side);
            EditorClickListener clickListener = new EditorClickListener(side);
            EditorEx editor = this.myViewer.getEditor(side);
            editor.addEditorMouseMotionListener(motionListener);
            editor.addEditorMouseListener(clickListener);
            editor.getCaretModel().addCaretListener((CaretListener)clickListener);
        }
        this.myPanel = JBUI.Panels.simplePanel((Component)this.myViewer.getComponent()).withBorder(IdeBorderFactory.createBorder());
    }

    @Override
    public Component getPanel() {
        return this.myPanel;
    }

    @Override
    public void updateView() {
        List<SimpleThreesideDiffChange> changes = this.myViewer.getChanges();
        for (SimpleThreesideDiffChange change : changes) {
            change.reinstallHighlighters();
        }
        this.myViewer.repaint();
    }

    public void setColorScheme(EditorColorsScheme highlighterSettings) {
        for (EditorEx editorEx : this.myViewer.getEditors()) {
            editorEx.setColorsScheme(editorEx.createBoundColorSchemeDelegate(highlighterSettings));
            editorEx.getColorsScheme().setAttributes(EditorColors.FOLDED_TEXT_ATTRIBUTES, null);
            editorEx.reinitSettings();
        }
    }

    @Override
    public void addListener(@NotNull ColorAndFontSettingsListener listener2) {
        this.myDispatcher.addListener((EventListener)listener2);
    }

    private void selectColorForLine(@NotNull ThreeSide side, int line) {
        SimpleThreesideDiffChange change = this.getChange(side, line);
        if (change != null) {
            TextDiffTypeFactory.TextDiffTypeImpl diffType = (TextDiffTypeFactory.TextDiffTypeImpl)ObjectUtils.tryCast((Object)change.getDiffType(), TextDiffTypeFactory.TextDiffTypeImpl.class);
            if (diffType != null) {
                ((ColorAndFontSettingsListener)this.myDispatcher.getMulticaster()).selectionInPreviewChanged(diffType.getKey().getExternalName());
            }
            return;
        }
        FoldRegion region = this.getFoldRegion(side, line);
        if (region != null) {
            ((ColorAndFontSettingsListener)this.myDispatcher.getMulticaster()).selectionInPreviewChanged(DiffLineSeparatorRenderer.BACKGROUND.getExternalName());
        }
    }

    @Nullable
    private SimpleThreesideDiffChange getChange(@NotNull ThreeSide side, int line) {
        for (SimpleThreesideDiffChange change : this.myViewer.getChanges()) {
            int endLine;
            int startLine = change.getStartLine(side);
            if (!DiffUtil.isSelectedByLine(line, startLine, endLine = change.getEndLine(side)) || !change.isChange(side)) continue;
            return change;
        }
        return null;
    }

    @Nullable
    private FoldRegion getFoldRegion(@NotNull ThreeSide side, int line) {
        EditorEx editor = this.myViewer.getEditor(side);
        DocumentEx document = editor.getDocument();
        for (FoldRegion region : editor.getFoldingModel().getAllFoldRegions()) {
            if (region.isExpanded()) continue;
            int line1 = document.getLineNumber(region.getStartOffset());
            int line2 = document.getLineNumber(region.getEndOffset());
            if (line1 > line || line > line2) continue;
            return region;
        }
        return null;
    }

    @Override
    public void blinkSelectedHighlightType(Object selected2) {
    }

    @Override
    public void disposeUIResources() {
        Disposer.dispose((Disposable)this.myViewer);
    }

    @NotNull
    public SimpleThreesideDiffViewer testGetViewer() {
        return this.myViewer;
    }

    private static class MyViewer
    extends SimpleThreesideDiffViewer {
        MyViewer() {
            super((DiffContext)new SampleContext(), (DiffRequest)new SampleRequest());
        }

        @Override
        protected boolean forceRediffSynchronously() {
            return true;
        }

        public void repaint() {
            this.myPanel.repaint();
        }
    }

    private class EditorClickListener
    implements CaretListener,
    com.intellij.openapi.editor.event.EditorMouseListener {
        @NotNull
        private final ThreeSide mySide;

        private EditorClickListener(ThreeSide side) {
            this.mySide = side;
        }

        public void mouseClicked(@NotNull EditorMouseEvent e) {
            DiffPreviewPanel.this.selectColorForLine(this.mySide, e.getLogicalPosition().line);
        }

        public void caretPositionChanged(@NotNull CaretEvent e) {
            DiffPreviewPanel.this.selectColorForLine(this.mySide, e.getNewPosition().line);
        }
    }

    private class EditorMouseListener
    implements EditorMouseMotionListener {
        @NotNull
        private final ThreeSide mySide;

        private EditorMouseListener(ThreeSide side) {
            this.mySide = side;
        }

        public void mouseMoved(@NotNull EditorMouseEvent e) {
            int line = e.getLogicalPosition().line;
            Cursor cursor = DiffPreviewPanel.this.getChange(this.mySide, line) != null || DiffPreviewPanel.this.getFoldRegion(this.mySide, line) != null ? Cursor.getPredefinedCursor(12) : null;
            ((EditorEx)e.getEditor()).setCustomCursor(DiffPreviewPanel.class, cursor);
        }
    }

    private static class SampleContext
    extends DiffContext {
        SampleContext() {
            TextDiffSettingsHolder.TextDiffSettings settings = new TextDiffSettingsHolder.TextDiffSettings();
            settings.setHighlightPolicy(HighlightPolicy.BY_WORD);
            settings.setIgnorePolicy(IgnorePolicy.IGNORE_WHITESPACES);
            settings.setContextRange(2);
            settings.setExpandByDefault(false);
            this.putUserData(TextDiffSettingsHolder.TextDiffSettings.KEY, settings);
        }

        @Nullable
        public Project getProject() {
            return null;
        }

        public boolean isWindowFocused() {
            return false;
        }

        public boolean isFocusedInWindow() {
            return false;
        }

        public void requestFocusInWindow() {
        }
    }

    private static class SampleRequest
    extends ContentDiffRequest {
        private final List<DiffContent> myContents = Arrays.asList(DiffPreviewProvider.getContents());

        SampleRequest() {
        }

        @NotNull
        public List<DiffContent> getContents() {
            return this.myContents;
        }

        @NotNull
        public List<String> getContentTitles() {
            return Arrays.asList(null, null, null);
        }

        @Nullable
        public String getTitle() {
            return DiffBundle.message((String)"merge.color.options.dialog.title", (Object[])new Object[0]);
        }
    }
}

