/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl.stores;

import com.intellij.application.options.PathMacrosCollector;
import com.intellij.application.options.PathMacrosImpl;
import com.intellij.openapi.components.CompositePathMacroFilter;
import com.intellij.openapi.components.PathMacroSubstitutor;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jdom.Element;
import org.jdom.Parent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FileStorageCoreUtil {
    private static final Logger LOG = Logger.getInstance(FileStorageCoreUtil.class);
    public static final String COMPONENT = "component";
    public static final String NAME = "name";
    public static final String DEFAULT_EXT = ".xml";

    @NotNull
    public static Map<String, Element> load(@NotNull Element rootElement, @Nullable PathMacroSubstitutor pathMacroSubstitutor) {
        List children2;
        if (pathMacroSubstitutor != null) {
            pathMacroSubstitutor.expandPaths(rootElement);
        }
        if ((children2 = rootElement.getChildren(COMPONENT)).isEmpty() && rootElement.getName().equals(COMPONENT) && rootElement.getAttributeValue(NAME) != null) {
            children2 = new SmartList((Object)rootElement);
        }
        CompositePathMacroFilter filter2 = null;
        TreeMap<String, Element> map2 = new TreeMap<String, Element>();
        Iterator iterator2 = children2.iterator();
        while (iterator2.hasNext()) {
            Element element2 = (Element)iterator2.next();
            String name = FileStorageCoreUtil.getComponentNameIfValid(element2);
            if (name == null || element2.getAttributes().size() <= 1 && element2.getChildren().isEmpty()) continue;
            iterator2.remove();
            if (pathMacroSubstitutor instanceof TrackingPathMacroSubstitutor) {
                if (filter2 == null) {
                    filter2 = new CompositePathMacroFilter(PathMacrosCollector.MACRO_FILTER_EXTENSION_POINT_NAME.getExtensionList());
                }
                ((TrackingPathMacroSubstitutor)pathMacroSubstitutor).addUnknownMacros(name, PathMacrosCollector.getMacroNames(element2, filter2, PathMacrosImpl.getInstanceEx()));
            }
            element2.removeAttribute(NAME);
            map2.put(name, JDOMUtil.internElement((Element)element2));
        }
        return map2;
    }

    @Nullable
    static String getComponentNameIfValid(@NotNull Element element2) {
        String name = element2.getAttributeValue(NAME);
        if (StringUtil.isEmpty((String)name)) {
            LOG.warn("No name attribute for component in " + JDOMUtil.writeElement((Element)element2));
            return null;
        }
        return name;
    }

    @Nullable
    public static String findComponentName(@NotNull Element element2) {
        Parent parent;
        Element componentElement = element2;
        while ((parent = componentElement.getParent()) instanceof Element) {
            componentElement = (Element)parent;
        }
        return StringUtil.nullize((String)componentElement.getAttributeValue(NAME));
    }
}

