/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.application.DeleteOldDirectoriesDialog;
import com.intellij.openapi.application.DeleteOldDirectoriesSettings;
import com.intellij.openapi.application.IdeDirectoriesInfo;
import com.intellij.openapi.application.InstallationDetector;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AppUIUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class DeleteOldDirectoriesHelper {
    private static final Pattern SELECTOR_PATTERN = Pattern.compile("([a-zA-Z]+)(\\d+(\\.\\d+)*)?");
    private static final String PREVIEW_STRING = "Preview";

    public static void run() {
        DeleteOldDirectoriesSettings settings = new DeleteOldDirectoriesSettings();
        List<IdeDirectoriesInfo> dirsInfoList = DeleteOldDirectoriesHelper.gatherDirectories(settings);
        if (!(dirsInfoList = DeleteOldDirectoriesHelper.filterDirectoriesWithoutInstallation(dirsInfoList, settings.getApplicationInfoFilePath())).isEmpty()) {
            DeleteOldDirectoriesDialog dialog2 = new DeleteOldDirectoriesDialog(dirsInfoList);
            AppUIUtil.updateWindowIcon(dialog2);
            dialog2.setVisible(true);
        }
    }

    private static List<IdeDirectoriesInfo> filterDirectoriesWithoutInstallation(List<IdeDirectoriesInfo> dirsInfoList, String applicationInfoFilePath) {
        InstallationDetector installationDetector = new InstallationDetector(applicationInfoFilePath);
        return dirsInfoList.stream().filter(dirsInfo -> installationDetector.detectInstallation((IdeDirectoriesInfo)dirsInfo) == null).collect(Collectors.toList());
    }

    private static List<IdeDirectoriesInfo> gatherDirectories(DeleteOldDirectoriesSettings settings) {
        Path parent = settings.getUserHome();
        if (!parent.isAbsolute() || !Files.isDirectory(parent, new LinkOption[0])) {
            return new ArrayList<IdeDirectoriesInfo>();
        }
        String prefix = DeleteOldDirectoriesHelper.getDirectorySearchPrefix(settings.getSelector(), settings.isMac());
        if (prefix.isEmpty()) {
            return new ArrayList<IdeDirectoriesInfo>();
        }
        DirectorySearchFilter filter2 = new DirectorySearchFilter(prefix, settings.getSelector(), settings.getIdeDirectories());
        List<IdeDirectoriesInfo> dirsInfoList = settings.isMac() ? DeleteOldDirectoriesHelper.gatherDirectoriesMac(parent, filter2) : DeleteOldDirectoriesHelper.gatherDirectoriesNonMac(parent, filter2);
        Collections.sort(dirsInfoList);
        return dirsInfoList;
    }

    private static List<IdeDirectoriesInfo> gatherDirectoriesNonMac(Path parent, DirectorySearchFilter filter2) {
        ArrayList<IdeDirectoriesInfo> dirsInfoList = new ArrayList<IdeDirectoriesInfo>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(parent, filter2);){
            for (Path dir : stream) {
                Path systemDir;
                String selector = DeleteOldDirectoriesHelper.getSelectorFromDir(dir);
                String descriptor2 = dir.getFileName().toString();
                IdeDirectoriesInfo dirsInfo = new IdeDirectoriesInfo(selector, descriptor2, dir);
                Path configDir = dir.resolve("config");
                if (!Files.isSymbolicLink(configDir) && Files.isDirectory(configDir, new LinkOption[0])) {
                    dirsInfo.addSubDirectory("Config", configDir);
                }
                if (!Files.isSymbolicLink(systemDir = dir.resolve("system")) && Files.isDirectory(systemDir, new LinkOption[0])) {
                    dirsInfo.addSubDirectory("System", systemDir);
                }
                dirsInfoList.add(dirsInfo);
            }
        }
        catch (IOException | DirectoryIteratorException exception) {
            // empty catch block
        }
        return dirsInfoList;
    }

    private static List<IdeDirectoriesInfo> gatherDirectoriesMac(Path parent, DirectorySearchFilter filter2) {
        HashMap<String, IdeDirectoriesInfo> dirsInfoMap = new HashMap<String, IdeDirectoriesInfo>();
        List locations = Stream.of(new IdeDirectoriesInfo.DirectoryInfo("Config", parent.resolve("Library/Preferences")), new IdeDirectoriesInfo.DirectoryInfo("System", parent.resolve("Library/Caches")), new IdeDirectoriesInfo.DirectoryInfo("Plugins", parent.resolve("Library/Application Support")), new IdeDirectoriesInfo.DirectoryInfo("Log", parent.resolve("Library/Logs"))).collect(Collectors.toList());
        for (IdeDirectoriesInfo.DirectoryInfo location : locations) {
            Path directory = location.getDirectory();
            if (Files.isSymbolicLink(directory) || !Files.isDirectory(directory, new LinkOption[0])) continue;
            try {
                DirectoryStream<Path> stream = Files.newDirectoryStream(directory, filter2);
                Throwable throwable = null;
                try {
                    for (Path dir : stream) {
                        String selector = DeleteOldDirectoriesHelper.getSelectorFromDir(dir);
                        if (!dirsInfoMap.containsKey(selector)) {
                            String descriptor2 = dir.getFileName().toString();
                            dirsInfoMap.put(selector, new IdeDirectoriesInfo(selector, descriptor2, null));
                        }
                        IdeDirectoriesInfo dirsInfo = (IdeDirectoriesInfo)dirsInfoMap.get(selector);
                        dirsInfo.addSubDirectory(location.getDescriptor(), dir);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (stream == null) continue;
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    stream.close();
                }
            }
            catch (IOException | DirectoryIteratorException exception) {}
        }
        return new ArrayList<IdeDirectoriesInfo>(dirsInfoMap.values());
    }

    @NotNull
    private static String getSelectorFromDir(Path dir) {
        String dirName = dir.getFileName().toString();
        return dirName.startsWith(".") ? dirName.substring(1) : dirName;
    }

    public static boolean isValidSelector(String selector) {
        return SELECTOR_PATTERN.matcher(selector).matches();
    }

    @NotNull
    public static String getDirectorySearchPrefix(String selector, boolean isMac) {
        Matcher matcher = SELECTOR_PATTERN.matcher(selector);
        if (matcher.matches()) {
            String name = matcher.group(1);
            if (name.endsWith(PREVIEW_STRING)) {
                name = name.substring(0, name.length() - PREVIEW_STRING.length());
            }
            return isMac ? name : "." + name;
        }
        return "";
    }

    private static boolean checkIfAncestorOfIdeDirectories(Path path, List<DeleteOldDirectoriesSettings.PathWithTransformations> ideDirectories) {
        DeleteOldDirectoriesSettings.PathWithTransformations pathWithTransformations = new DeleteOldDirectoriesSettings.PathWithTransformations(path.toString());
        for (String transformedPath : pathWithTransformations) {
            if (!DeleteOldDirectoriesHelper.checkIfAncestorOfPaths(transformedPath, ideDirectories)) continue;
            return true;
        }
        return false;
    }

    private static boolean checkIfAncestorOfPaths(String ancestorPath, List<DeleteOldDirectoriesSettings.PathWithTransformations> pathsWithTransformations) {
        for (DeleteOldDirectoriesSettings.PathWithTransformations pathWithTransformations : pathsWithTransformations) {
            for (String path : pathWithTransformations) {
                if (!StringUtil.startsWithIgnoreCase((String)path, (String)ancestorPath) || path.length() != ancestorPath.length() && path.charAt(ancestorPath.length()) != File.separatorChar) continue;
                return true;
            }
        }
        return false;
    }

    private static class DirectorySearchFilter
    implements DirectoryStream.Filter<Path> {
        private final String desiredPrefix;
        private final String currentIdeSelector;
        private final List<DeleteOldDirectoriesSettings.PathWithTransformations> currentIdeDirectories;

        public DirectorySearchFilter(String desiredPrefix, String currentIdeSelector, List<DeleteOldDirectoriesSettings.PathWithTransformations> currentIdeDirectories) {
            this.desiredPrefix = desiredPrefix;
            this.currentIdeSelector = currentIdeSelector;
            this.currentIdeDirectories = currentIdeDirectories;
        }

        @Override
        public boolean accept(Path entry) {
            try {
                if (Files.isSymbolicLink(entry) || !Files.isDirectory(entry, new LinkOption[0])) {
                    return false;
                }
                if (!StringUtil.startsWithIgnoreCase((String)entry.getFileName().toString(), (String)this.desiredPrefix)) {
                    return false;
                }
                String selector = DeleteOldDirectoriesHelper.getSelectorFromDir(entry);
                if (!DeleteOldDirectoriesHelper.isValidSelector(selector) || selector.equalsIgnoreCase(this.currentIdeSelector)) {
                    return false;
                }
                return !DeleteOldDirectoriesHelper.checkIfAncestorOfIdeDirectories(entry, this.currentIdeDirectories);
            }
            catch (Exception ex) {
                return false;
            }
        }
    }
}

