/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.notification.NotificationType;
import com.intellij.notification.impl.widget.IdeNotificationArea;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBDimension;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class ShowNotificationIconsDialogAction
extends AnAction
implements DumbAware {
    public void actionPerformed(@NotNull AnActionEvent e) {
        new DialogWrapper(e.getProject()){
            private JPanel myPanel;
            {
                this.init();
                this.setResizable(false);
            }

            protected Action @NotNull [] createLeftSideActions() {
                return new Action[]{new AbstractAction(IdeBundle.message((String)"button.repaint.icons", (Object[])new Object[0])){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (myPanel != null) {
                            myPanel.removeAll();
                            this.fillPanel(myPanel);
                            myPanel.revalidate();
                        }
                    }
                }};
            }

            protected JComponent createCenterPanel() {
                this.myPanel = new JPanel();
                this.myPanel.setLayout(new BoxLayout(this.myPanel, 1));
                this.fillPanel(this.myPanel);
                return this.myPanel;
            }

            private void fillPanel(JPanel panel2) {
                panel2.add(this.createIconsRow(NotificationType.INFORMATION, true));
                panel2.add(this.createIconsRow(NotificationType.INFORMATION, false));
                panel2.add(this.createIconsRow(NotificationType.WARNING, true));
                panel2.add(this.createIconsRow(NotificationType.WARNING, false));
                panel2.add(this.createIconsRow(NotificationType.ERROR, true));
                panel2.add(this.createIconsRow(NotificationType.ERROR, false));
            }

            @NotNull
            private JPanel createIconsRow(@NotNull NotificationType notificationType, boolean forToolWindow) {
                JPanel row = new JPanel();
                row.setLayout(new BoxLayout(row, 0));
                for (int i2 = 0; i2 <= 10; ++i2) {
                    LayeredIcon icon2 = IdeNotificationArea.createIconWithNotificationCount(row, notificationType, i2, forToolWindow);
                    JBLabel label2 = new JBLabel((Icon)icon2);
                    label2.setMaximumSize((Dimension)new JBDimension(30, 20));
                    label2.setMinimumSize((Dimension)new JBDimension(30, 20));
                    row.add((Component)label2);
                }
                return row;
            }
        }.show();
    }
}

