/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.model.psi.impl;

import com.intellij.model.psi.PsiExternalReferenceHost;
import com.intellij.model.psi.PsiSymbolReferenceProviderBean;
import com.intellij.util.SmartList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;

final class LanguageReferenceProviders {
    private final List<PsiSymbolReferenceProviderBean> myBeans;
    private final Map<Class<?>, List<PsiSymbolReferenceProviderBean>> myBeansByHostClass = new ConcurrentHashMap();

    LanguageReferenceProviders(@NotNull List<PsiSymbolReferenceProviderBean> beans) {
        this.myBeans = beans;
    }

    @NotNull
    List<PsiSymbolReferenceProviderBean> byHostClass(@NotNull Class<? extends PsiExternalReferenceHost> aClass) {
        return this.myBeansByHostClass.computeIfAbsent(aClass, this::byHostClassInner);
    }

    @NotNull
    private List<PsiSymbolReferenceProviderBean> byHostClassInner(@NotNull Class<?> key) {
        SmartList result2 = new SmartList();
        for (PsiSymbolReferenceProviderBean bean : this.myBeans) {
            if (!bean.getHostElementClass().isAssignableFrom(key)) continue;
            result2.add(bean);
        }
        return result2;
    }
}

