/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.largeFilesEditor.search.searchTask;

import com.intellij.find.FindModel;
import java.lang.reflect.Field;

public class SearchTaskOptions
implements Cloneable {
    public static final int DEFAULT_CRITICAL_AMOUNT_OF_SEARCH_RESULTS = 1000;
    public static final int NO_LIMIT = -1;
    public String stringToFind;
    public boolean loopedPhase = false;
    public long leftBoundPageNumber = -1L;
    public int leftBoundCaretPageOffset = -1;
    public long rightBoundPageNumber = -1L;
    public int rightBoundCaretPageOffset = -1;
    public boolean searchForwardDirection = true;
    public boolean caseSensitive = false;
    public boolean wholeWords = false;
    public boolean regularExpression = false;
    public int contextOneSideLength = 0;
    public int criticalAmountOfSearchResults = 1000;

    public SearchTaskOptions setStringToFind(String stringToFind) {
        this.stringToFind = stringToFind;
        return this;
    }

    public SearchTaskOptions setSearchBounds(long leftBoundPageNumber, int leftBoundCaretPageOffset, long rightBoundPageNumber, int rightBoundCaretPageOffset) {
        this.leftBoundPageNumber = leftBoundPageNumber;
        this.leftBoundCaretPageOffset = leftBoundCaretPageOffset;
        this.rightBoundPageNumber = rightBoundPageNumber;
        this.rightBoundCaretPageOffset = rightBoundCaretPageOffset;
        return this;
    }

    public SearchTaskOptions setCaseSensetive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
        return this;
    }

    public SearchTaskOptions setWholeWords(boolean wholeWords) {
        this.wholeWords = wholeWords;
        return this;
    }

    public SearchTaskOptions setRegularExpression(boolean regularExpression) {
        this.regularExpression = regularExpression;
        return this;
    }

    public SearchTaskOptions setSearchDirectionForward(boolean forward) {
        this.searchForwardDirection = forward;
        return this;
    }

    public SearchTaskOptions setContextOneSideLength(int contextOneSideLength) {
        this.contextOneSideLength = contextOneSideLength;
        return this;
    }

    public SearchTaskOptions setCriticalAmountOfSearchResults(int criticalAmountOfSearchResults) {
        this.criticalAmountOfSearchResults = criticalAmountOfSearchResults;
        return this;
    }

    public SearchTaskOptions clone() throws CloneNotSupportedException {
        return (SearchTaskOptions)super.clone();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        Field[] fields2 = this.getClass().getDeclaredFields();
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append(": {");
        for (Field field : fields2) {
            stringBuilder.append(field.getName());
            stringBuilder.append("=");
            try {
                stringBuilder.append(field.get(this));
            }
            catch (IllegalAccessException e) {
                stringBuilder.append("<Illegal access>");
            }
            stringBuilder.append(", ");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public FindModel generateFindModel() {
        FindModel findModel = new FindModel();
        findModel.setStringToFind(this.stringToFind);
        findModel.setCaseSensitive(this.caseSensitive);
        findModel.setWholeWordsOnly(this.wholeWords);
        findModel.setRegularExpressions(this.regularExpression);
        return findModel;
    }
}

