/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.largeFilesEditor.actions;

import com.intellij.largeFilesEditor.actions.Utils;
import com.intellij.largeFilesEditor.editor.LargeFileEditor;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LfeBaseEditorActionHandler
extends EditorActionHandler {
    private final EditorActionHandler originalHandler;

    public LfeBaseEditorActionHandler(EditorActionHandler originalHandler) {
        this.originalHandler = originalHandler;
    }

    protected final void doExecute(@NotNull Editor editor, @Nullable Caret caret, DataContext dataContext) {
        LargeFileEditor largeFileEditor = Utils.tryGetLargeFileEditorManagerFromEditor(editor);
        if (largeFileEditor != null) {
            this.doExecuteInLfe(largeFileEditor, editor, caret, dataContext);
        } else if (this.originalHandler != null) {
            this.originalHandler.execute(editor, caret, dataContext);
        }
    }

    protected final boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, DataContext dataContext) {
        LargeFileEditor largeFileEditor = Utils.tryGetLargeFileEditorManagerFromEditor(editor);
        if (largeFileEditor != null) {
            return this.isEnabledInLfe(largeFileEditor, editor, caret, dataContext);
        }
        return this.originalHandler != null ? this.originalHandler.isEnabled(editor, caret, dataContext) : false;
    }

    protected final EditorActionHandler getOriginalHandler() {
        return this.originalHandler;
    }

    protected abstract void doExecuteInLfe(@NotNull LargeFileEditor var1, @NotNull Editor var2, @Nullable Caret var3, DataContext var4);

    protected abstract boolean isEnabledInLfe(@NotNull LargeFileEditor var1, @NotNull Editor var2, @NotNull Caret var3, DataContext var4);
}

