/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.impl;

import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ForeignLeafType;
import com.intellij.lang.ITokenTypeRemapper;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.LighterASTTokenNode;
import com.intellij.lang.LighterLazyParseableNode;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.TokenWrapper;
import com.intellij.lang.WhitespaceSkippedCallback;
import com.intellij.lang.WhitespacesAndCommentsBinder;
import com.intellij.lang.WhitespacesBinders;
import com.intellij.lang.impl.MarkerOptionalData;
import com.intellij.lang.impl.MarkerPool;
import com.intellij.lang.impl.MarkerProduction;
import com.intellij.lang.impl.TokenSequence;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UnprotectedUserDataHolder;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.BlockSupportImpl;
import com.intellij.psi.impl.DiffLog;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.source.CharTableImpl;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.ForeignLeafPsiElement;
import com.intellij.psi.impl.source.tree.LazyParseableElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.PsiWhiteSpaceImpl;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.text.BlockSupport;
import com.intellij.psi.tree.CustomLanguageASTComparator;
import com.intellij.psi.tree.ICustomParsingType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.ILazyParseableElementType;
import com.intellij.psi.tree.ILazyParseableElementTypeBase;
import com.intellij.psi.tree.ILeafElementType;
import com.intellij.psi.tree.ILightLazyParseableElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.CharTable;
import com.intellij.util.ThreeState;
import com.intellij.util.TripleFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.LimitedPool;
import com.intellij.util.containers.Stack;
import com.intellij.util.diff.DiffTreeChangeBuilder;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import com.intellij.util.diff.ShallowNodeComparator;
import com.intellij.util.text.CharArrayUtil;
import gnu.trove.TIntObjectHashMap;
import java.util.AbstractList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiBuilderImpl
extends UnprotectedUserDataHolder
implements PsiBuilder {
    private static final Logger LOG = Logger.getInstance(PsiBuilderImpl.class);
    public static final Key<TripleFunction<ASTNode, LighterASTNode, FlyweightCapableTreeStructure<LighterASTNode>, ThreeState>> CUSTOM_COMPARATOR = Key.create((String)"CUSTOM_COMPARATOR");
    private static final Key<TokenSequence> LAZY_PARSEABLE_TOKENS = Key.create((String)"LAZY_PARSEABLE_TOKENS");
    private static TokenSet ourAnyLanguageWhitespaceTokens = TokenSet.EMPTY;
    private final Project myProject;
    private PsiFile myFile;
    private final int[] myLexStarts;
    private final IElementType[] myLexTypes;
    private int myCurrentLexeme;
    private final ParserDefinition myParserDefinition;
    private final Lexer myLexer;
    private final TokenSet myWhitespaces;
    private TokenSet myComments;
    private CharTable myCharTable;
    private final CharSequence myText;
    private final CharSequence myLastCommittedText;
    private final char[] myTextArray;
    private boolean myDebugMode;
    private final int myLexemeCount;
    private boolean myTokenTypeChecked;
    private ITokenTypeRemapper myRemapper;
    private WhitespaceSkippedCallback myWhitespaceSkippedCallback;
    private final ASTNode myOriginalTree;
    private final MyTreeStructure myParentLightTree;
    private final int myOffset;
    private IElementType myCachedTokenType;
    private final TIntObjectHashMap<LazyParseableToken> myChameleonCache = new TIntObjectHashMap();
    private final MarkerPool myPool = new MarkerPool(this);
    private final MarkerOptionalData myOptionalData = new MarkerOptionalData();
    private final MarkerProduction myProduction = new MarkerProduction(this.myPool, this.myOptionalData);
    private static final String UNBALANCED_MESSAGE = "Unbalanced tree. Most probably caused by unbalanced markers. Try calling setDebugMode(true) against PsiBuilder passed to identify exact location of the problem";

    public static void registerWhitespaceToken(@NotNull IElementType type) {
        ourAnyLanguageWhitespaceTokens = TokenSet.orSet((TokenSet[])new TokenSet[]{ourAnyLanguageWhitespaceTokens, TokenSet.create((IElementType[])new IElementType[]{type})});
    }

    public PsiBuilderImpl(@Nullable Project project, @Nullable PsiFile containingFile, @NotNull ParserDefinition parserDefinition, @NotNull Lexer lexer, @Nullable CharTable charTable, @NotNull CharSequence text, @Nullable ASTNode originalTree, @Nullable MyTreeStructure parentLightTree) {
        this(project, containingFile, parserDefinition, lexer, charTable, text, originalTree, originalTree == null ? null : originalTree.getText(), parentLightTree, null);
    }

    public PsiBuilderImpl(@NotNull Project project, @NotNull ParserDefinition parserDefinition, @NotNull Lexer lexer, @NotNull ASTNode chameleon, @NotNull CharSequence text) {
        this(project, SharedImplUtil.getContainingFile(chameleon), parserDefinition, lexer, SharedImplUtil.findCharTableByTree(chameleon), text, (ASTNode)Pair.getFirst((Pair)((Pair)chameleon.getUserData(BlockSupport.TREE_TO_BE_REPARSED))), (CharSequence)Pair.getSecond((Pair)((Pair)chameleon.getUserData(BlockSupport.TREE_TO_BE_REPARSED))), null, chameleon);
    }

    public PsiBuilderImpl(@NotNull Project project, @NotNull ParserDefinition parserDefinition, @NotNull Lexer lexer, @NotNull LighterLazyParseableNode chameleon, @NotNull CharSequence text) {
        this(project, chameleon.getContainingFile(), parserDefinition, lexer, chameleon.getCharTable(), text, null, null, ((LazyParseableToken)chameleon).myParentStructure, chameleon);
    }

    private PsiBuilderImpl(@Nullable Project project, @Nullable PsiFile containingFile, @NotNull ParserDefinition parserDefinition, @NotNull Lexer lexer, @Nullable CharTable charTable, @NotNull CharSequence text, @Nullable ASTNode originalTree, @Nullable CharSequence lastCommittedText, @Nullable MyTreeStructure parentLightTree, @Nullable Object parentCachingNode) {
        this.myProject = project;
        this.myFile = containingFile;
        this.myParserDefinition = parserDefinition;
        this.myText = text;
        this.myTextArray = CharArrayUtil.fromSequenceWithoutCopying((CharSequence)text);
        this.myLexer = lexer;
        this.myWhitespaces = parserDefinition.getWhitespaceTokens();
        this.myComments = parserDefinition.getCommentTokens();
        this.myCharTable = charTable;
        this.myOriginalTree = originalTree;
        this.myLastCommittedText = lastCommittedText;
        if (originalTree == null != (lastCommittedText == null)) {
            throw new IllegalArgumentException("originalTree and lastCommittedText must be null/notnull together but got: originalTree=" + originalTree + "; lastCommittedText=" + (lastCommittedText == null ? null : "'" + StringUtil.first((CharSequence)lastCommittedText, (int)80, (boolean)true) + "'"));
        }
        this.myParentLightTree = parentLightTree;
        this.myOffset = parentCachingNode instanceof LazyParseableToken ? ((LazyParseableToken)parentCachingNode).getStartOffset() : 0;
        TokenSequence tokens = this.performLexing(parentCachingNode);
        this.myLexStarts = tokens.lexStarts;
        this.myLexTypes = tokens.lexTypes;
        this.myLexemeCount = tokens.lexemeCount;
    }

    private TokenSequence performLexing(@Nullable Object parentCachingNode) {
        TokenSequence fromParent = null;
        if (parentCachingNode instanceof LazyParseableToken && PsiBuilderImpl.shouldReuseCollapsedTokens(((LazyParseableToken)parentCachingNode).getTokenType())) {
            fromParent = ((LazyParseableToken)parentCachingNode).getParsedTokenSequence();
            assert (fromParent == null || fromParent.lexStarts[fromParent.lexemeCount] == this.myText.length());
            ProgressIndicatorProvider.checkCanceled();
        } else if (parentCachingNode instanceof LazyParseableElement) {
            LazyParseableElement parentElement = (LazyParseableElement)parentCachingNode;
            fromParent = (TokenSequence)parentElement.getUserData(LAZY_PARSEABLE_TOKENS);
            parentElement.putUserData(LAZY_PARSEABLE_TOKENS, null);
        }
        if (fromParent != null) {
            if (PsiBuilderImpl.doLexingOptimizationCorrectionCheck()) {
                fromParent.assertMatches(this.myText, this.myLexer);
            }
            return fromParent;
        }
        return TokenSequence.performLexing(this.myText, this.myLexer);
    }

    private static boolean doLexingOptimizationCorrectionCheck() {
        return false;
    }

    public Project getProject() {
        return this.myProject;
    }

    public void enforceCommentTokens(@NotNull TokenSet tokens) {
        this.myComments = tokens;
    }

    @Nullable
    public StartMarker getLatestDoneMarker() {
        for (int index = this.myProduction.size() - 1; index >= 0; --index) {
            StartMarker marker = this.myProduction.getDoneMarkerAt(index);
            if (marker == null) continue;
            return marker;
        }
        return null;
    }

    @Nullable
    public List<ProductionMarker> getProductions() {
        return new AbstractList<ProductionMarker>(){

            @Override
            public ProductionMarker get(int index) {
                return PsiBuilderImpl.this.myProduction.getMarkerAt(index);
            }

            @Override
            public int size() {
                return PsiBuilderImpl.this.myProduction.size();
            }
        };
    }

    @NotNull
    private PsiBuilder.Marker precede(StartMarker marker) {
        assert (marker.myLexemeIndex >= 0) : "Preceding disposed marker";
        if (this.myDebugMode) {
            this.myProduction.assertNoDoneMarkerAround(marker);
        }
        StartMarker pre = this.createMarker(marker.myLexemeIndex);
        this.myProduction.addBefore(pre, marker);
        return pre;
    }

    @NotNull
    public CharSequence getOriginalText() {
        return this.myText;
    }

    @Nullable
    public IElementType getTokenType() {
        IElementType cached = this.myCachedTokenType;
        if (cached == null) {
            this.myCachedTokenType = cached = this.calcTokenType();
        }
        return cached;
    }

    private void clearCachedTokenType() {
        this.myCachedTokenType = null;
    }

    private IElementType remapCurrentToken() {
        if (this.myCachedTokenType != null) {
            return this.myCachedTokenType;
        }
        if (this.myRemapper != null) {
            this.remapCurrentToken(this.myRemapper.filter(this.myLexTypes[this.myCurrentLexeme], this.myLexStarts[this.myCurrentLexeme], this.myLexStarts[this.myCurrentLexeme + 1], this.myText));
        }
        return this.myLexTypes[this.myCurrentLexeme];
    }

    private IElementType calcTokenType() {
        if (this.eof()) {
            return null;
        }
        if (this.myRemapper != null) {
            this.skipWhitespace();
        }
        return this.myLexTypes[this.myCurrentLexeme];
    }

    public void setTokenTypeRemapper(ITokenTypeRemapper remapper) {
        this.myRemapper = remapper;
        this.myTokenTypeChecked = false;
        this.clearCachedTokenType();
    }

    public void remapCurrentToken(IElementType type) {
        this.myLexTypes[this.myCurrentLexeme] = type;
        this.clearCachedTokenType();
    }

    @Nullable
    public IElementType lookAhead(int steps) {
        int cur = this.shiftOverWhitespaceForward(this.myCurrentLexeme);
        while (steps > 0) {
            cur = this.shiftOverWhitespaceForward(cur + 1);
            --steps;
        }
        return cur < this.myLexemeCount ? this.myLexTypes[cur] : null;
    }

    private int shiftOverWhitespaceForward(int lexIndex) {
        while (lexIndex < this.myLexemeCount && this.whitespaceOrComment(this.myLexTypes[lexIndex])) {
            ++lexIndex;
        }
        return lexIndex;
    }

    public IElementType rawLookup(int steps) {
        int cur = this.myCurrentLexeme + steps;
        return cur < this.myLexemeCount && cur >= 0 ? this.myLexTypes[cur] : null;
    }

    public int rawTokenTypeStart(int steps) {
        int cur = this.myCurrentLexeme + steps;
        if (cur < 0) {
            return -1;
        }
        if (cur >= this.myLexemeCount) {
            return this.getOriginalText().length();
        }
        return this.myLexStarts[cur];
    }

    public int rawTokenIndex() {
        return this.myCurrentLexeme;
    }

    public void setWhitespaceSkippedCallback(@Nullable WhitespaceSkippedCallback callback2) {
        this.myWhitespaceSkippedCallback = callback2;
    }

    public void advanceLexer() {
        ProgressIndicatorProvider.checkCanceled();
        if (this.eof()) {
            return;
        }
        this.myTokenTypeChecked = false;
        ++this.myCurrentLexeme;
        this.clearCachedTokenType();
    }

    private void skipWhitespace() {
        while (this.myCurrentLexeme < this.myLexemeCount && this.whitespaceOrComment(this.remapCurrentToken())) {
            this.onSkip(this.myLexTypes[this.myCurrentLexeme], this.myLexStarts[this.myCurrentLexeme], this.myCurrentLexeme + 1 < this.myLexemeCount ? this.myLexStarts[this.myCurrentLexeme + 1] : this.myText.length());
            ++this.myCurrentLexeme;
            this.clearCachedTokenType();
        }
    }

    private void onSkip(IElementType type, int start2, int end) {
        if (this.myWhitespaceSkippedCallback != null) {
            this.myWhitespaceSkippedCallback.onSkip(type, start2, end);
        }
    }

    public int getCurrentOffset() {
        if (this.eof()) {
            return this.getOriginalText().length();
        }
        return this.myLexStarts[this.myCurrentLexeme];
    }

    @Nullable
    public String getTokenText() {
        if (this.eof()) {
            return null;
        }
        IElementType type = this.getTokenType();
        if (type instanceof TokenWrapper) {
            return ((TokenWrapper)type).getValue();
        }
        return this.myText.subSequence(this.myLexStarts[this.myCurrentLexeme], this.myLexStarts[this.myCurrentLexeme + 1]).toString();
    }

    public boolean whitespaceOrComment(IElementType token) {
        return this.myWhitespaces.contains(token) || this.myComments.contains(token);
    }

    @NotNull
    public PsiBuilder.Marker mark() {
        if (!this.myProduction.isEmpty()) {
            this.skipWhitespace();
        }
        StartMarker marker = this.createMarker(this.myCurrentLexeme);
        this.myProduction.addMarker(marker);
        return marker;
    }

    @NotNull
    private StartMarker createMarker(int lexemeIndex) {
        StartMarker marker = this.myPool.allocateStartMarker();
        marker.myLexemeIndex = lexemeIndex;
        if (this.myDebugMode) {
            this.myOptionalData.notifyAllocated(marker.markerId);
        }
        return marker;
    }

    public final boolean eof() {
        if (!this.myTokenTypeChecked) {
            this.myTokenTypeChecked = true;
            this.skipWhitespace();
        }
        return this.myCurrentLexeme >= this.myLexemeCount;
    }

    private void rollbackTo(@NotNull StartMarker marker) {
        assert (marker.myLexemeIndex >= 0) : "The marker is already disposed";
        if (this.myDebugMode) {
            this.myProduction.assertNoDoneMarkerAround(marker);
        }
        this.myCurrentLexeme = marker.myLexemeIndex;
        this.myTokenTypeChecked = true;
        this.myProduction.rollbackTo(marker);
        this.clearCachedTokenType();
    }

    public boolean hasErrorsAfter(@NotNull PsiBuilder.Marker marker) {
        return this.myProduction.hasErrorsAfter((StartMarker)marker);
    }

    private void processDone(@NotNull StartMarker marker, @Nullable String errorMessage, @Nullable StartMarker before) {
        int doneLexeme;
        this.doValidityChecks(marker, before);
        if (errorMessage != null) {
            this.myOptionalData.setErrorMessage(marker.markerId, errorMessage);
        }
        int n = doneLexeme = before == null ? this.myCurrentLexeme : before.myLexemeIndex;
        if (marker.myType.isLeftBound() && this.isEmpty(marker.myLexemeIndex, doneLexeme)) {
            marker.setCustomEdgeTokenBinders(WhitespacesBinders.DEFAULT_RIGHT_BINDER, null);
        }
        marker.myDoneLexeme = doneLexeme;
        this.myProduction.addDone(marker, before);
    }

    private boolean isEmpty(int startIdx, int endIdx) {
        for (int i2 = startIdx; i2 < endIdx; ++i2) {
            IElementType token = this.myLexTypes[i2];
            if (this.whitespaceOrComment(token)) continue;
            return false;
        }
        return true;
    }

    private void doValidityChecks(@NotNull StartMarker marker, @Nullable StartMarker before) {
        if (marker.isDone()) {
            LOG.error("Marker already done.");
        }
        if (this.myDebugMode) {
            this.myProduction.doHeavyChecksOnMarkerDone(marker, before);
        }
    }

    public void error(@NotNull String messageText) {
        ProductionMarker lastMarker = this.myProduction.getStartMarkerAt(this.myProduction.size() - 1);
        if (lastMarker instanceof ErrorItem && lastMarker.myLexemeIndex == this.myCurrentLexeme) {
            return;
        }
        ErrorItem marker = this.myPool.allocateErrorItem();
        marker.myMessage = messageText;
        marker.myLexemeIndex = this.myCurrentLexeme;
        this.myProduction.addMarker(marker);
    }

    @NotNull
    public ASTNode getTreeBuilt() {
        return this.buildTree();
    }

    @NotNull
    private ASTNode buildTree() {
        TreeElement childNode;
        boolean possiblyTooDeep;
        StartMarker rootMarker = this.prepareLightTree();
        boolean bl = possiblyTooDeep = this.myFile != null && BlockSupport.isTooDeep((UserDataHolder)this.myFile.getOriginalFile());
        if (this.myOriginalTree != null && !possiblyTooDeep) {
            DiffLog diffLog = this.merge(this.myOriginalTree, rootMarker, this.myLastCommittedText);
            throw new BlockSupport.ReparsedSuccessfullyException(diffLog);
        }
        TreeElement rootNode = this.createRootAST(rootMarker);
        this.bind(rootMarker, (CompositeElement)rootNode);
        if (possiblyTooDeep && !(rootNode instanceof FileElement) && (childNode = rootNode.getFirstChildNode()) != null) {
            childNode.putUserData(BlockSupport.TREE_DEPTH_LIMIT_EXCEEDED, Boolean.TRUE);
        }
        assert (rootNode.getTextLength() == this.myText.length()) : rootNode.getElementType();
        return rootNode;
    }

    @NotNull
    public FlyweightCapableTreeStructure<LighterASTNode> getLightTree() {
        StartMarker rootMarker = this.prepareLightTree();
        return new MyTreeStructure(rootMarker, this.myParentLightTree);
    }

    @NotNull
    private TreeElement createRootAST(@NotNull StartMarker rootMarker) {
        CompositeElement rootNode;
        IElementType type = rootMarker.getTokenType();
        CompositeElement compositeElement = rootNode = type instanceof ILazyParseableElementType ? PsiBuilderImpl.createLazy((ILazyParseableElementType)type, null, this.getASTFactory()) : PsiBuilderImpl.createComposite(rootMarker, this.getASTFactory());
        if (this.myCharTable == null) {
            CharTableImpl charTableImpl = this.myCharTable = rootNode instanceof FileElement ? ((FileElement)rootNode).getCharTable() : new CharTableImpl();
        }
        if (!(rootNode instanceof FileElement)) {
            rootNode.putUserData(CharTable.CHAR_TABLE_KEY, this.myCharTable);
        }
        return rootNode;
    }

    @Nullable
    private ASTFactory getASTFactory() {
        return this.myParserDefinition instanceof ASTFactory ? (ASTFactory)this.myParserDefinition : null;
    }

    @NotNull
    private DiffLog merge(@NotNull ASTNode oldRoot, @NotNull StartMarker newRoot, @NotNull CharSequence lastCommittedText) {
        DiffLog diffLog = new DiffLog();
        ConvertFromTokensToASTBuilder builder2 = new ConvertFromTokensToASTBuilder(newRoot, diffLog, this.getASTFactory());
        MyTreeStructure treeStructure = new MyTreeStructure(newRoot, null);
        List customLanguageASTComparators = CustomLanguageASTComparator.getMatchingComparators((PsiFile)this.myFile);
        MyComparator comparator2 = new MyComparator(this.getUserData(CUSTOM_COMPARATOR), customLanguageASTComparators, treeStructure);
        ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        if (indicator == null) {
            indicator = new EmptyProgressIndicator();
        }
        BlockSupportImpl.diffTrees(oldRoot, builder2, comparator2, treeStructure, indicator, lastCommittedText);
        return diffLog;
    }

    @NotNull
    private StartMarker prepareLightTree() {
        StartMarker rootMarker;
        if (this.myProduction.isEmpty()) {
            LOG.error("Parser produced no markers. Text:\n" + this.myText);
        }
        if ((rootMarker = (StartMarker)Objects.requireNonNull(this.myProduction.getStartMarkerAt(0))).myFirstChild != null) {
            return rootMarker;
        }
        this.myOptionalData.compact();
        this.myTokenTypeChecked = true;
        this.balanceWhiteSpaces();
        rootMarker.myNext = null;
        rootMarker.myParent = rootMarker.myFirstChild = (rootMarker.myLastChild = null);
        StartMarker curNode = rootMarker;
        Stack nodes = new Stack();
        nodes.push((Object)rootMarker);
        int lastErrorIndex = -1;
        int maxDepth = 0;
        int curDepth = 0;
        boolean hasCollapsedChameleons = false;
        for (int i2 = 1; i2 < this.myProduction.size(); ++i2) {
            ProductionMarker item = this.myProduction.getStartMarkerAt(i2);
            if (item instanceof StartMarker) {
                StartMarker marker = (StartMarker)item;
                marker.myParent = curNode;
                marker.myNext = null;
                marker.myFirstChild = (marker.myLastChild = null);
                curNode.addChild(marker);
                nodes.push((Object)curNode);
                curNode = marker;
                if (++curDepth <= maxDepth) continue;
                maxDepth = curDepth;
                continue;
            }
            if (item instanceof ErrorItem) {
                item.myParent = curNode;
                int curToken = item.myLexemeIndex;
                if (curToken == lastErrorIndex) continue;
                lastErrorIndex = curToken;
                curNode.addChild(item);
                continue;
            }
            if (PsiBuilderImpl.isCollapsedChameleon(curNode)) {
                hasCollapsedChameleons = true;
            }
            this.assertMarkersBalanced(this.myProduction.getDoneMarkerAt(i2) == curNode, item);
            curNode = (StartMarker)nodes.pop();
            --curDepth;
        }
        if (this.myCurrentLexeme < this.myLexemeCount) {
            List missed = ContainerUtil.newArrayList((Object[])this.myLexTypes, (int)this.myCurrentLexeme, (int)this.myLexemeCount);
            LOG.error("Tokens " + missed + " were not inserted into the tree. " + (this.myFile != null ? this.myFile.getLanguage() + ", " : "") + "Text:\n" + this.myText);
        }
        if (rootMarker.getEndIndex() < this.myLexemeCount) {
            List missed = ContainerUtil.newArrayList((Object[])this.myLexTypes, (int)rootMarker.getEndIndex(), (int)this.myLexemeCount);
            LOG.error("Tokens " + missed + " are outside of root element \"" + rootMarker.myType + "\". Text:\n" + this.myText);
        }
        this.assertMarkersBalanced(curNode == rootMarker, curNode);
        this.checkTreeDepth(maxDepth, rootMarker.getTokenType() instanceof IFileElementType, hasCollapsedChameleons);
        this.clearCachedTokenType();
        return rootMarker;
    }

    private static boolean isCollapsedChameleon(StartMarker marker) {
        return marker.getTokenType() instanceof ILazyParseableElementTypeBase && marker.myFirstChild == null && marker.getTextLength() > 0;
    }

    private void assertMarkersBalanced(boolean condition, @Nullable ProductionMarker marker) {
        if (condition) {
            return;
        }
        this.reportUnbalancedMarkers(marker);
    }

    private void reportUnbalancedMarkers(@Nullable ProductionMarker marker) {
        int index = marker != null ? marker.getStartIndex() + 1 : this.myLexStarts.length;
        String context = index < this.myLexStarts.length ? this.myText.subSequence(Math.max(0, this.myLexStarts[index] - 1000), this.myLexStarts[index]) : "<none>";
        String language = this.myFile != null ? this.myFile.getLanguage() + ", " : "";
        LOG.error("Unbalanced tree. Most probably caused by unbalanced markers. Try calling setDebugMode(true) against PsiBuilder passed to identify exact location of the problem\nlanguage: " + language + "\ncontext: '" + context + "'");
    }

    private void balanceWhiteSpaces() {
        RelativeTokenTypesView wsTokens = new RelativeTokenTypesView();
        RelativeTokenTextView tokenTextGetter = new RelativeTokenTextView();
        int lastIndex = 0;
        int size = this.myProduction.size() - 1;
        for (int i2 = 1; i2 < size; ++i2) {
            int wsStartIndex;
            ProductionMarker starting = this.myProduction.getStartMarkerAt(i2);
            if (starting instanceof StartMarker) {
                this.assertMarkersBalanced(((StartMarker)starting).isDone(), starting);
            }
            boolean done = starting == null;
            ProductionMarker item = starting != null ? starting : (ProductionMarker)Objects.requireNonNull(this.myProduction.getDoneMarkerAt(i2));
            WhitespacesAndCommentsBinder binder = item.getBinder(done);
            int lexemeIndex = item.getLexemeIndex(done);
            boolean recursive = binder instanceof WhitespacesAndCommentsBinder.RecursiveBinder;
            int prevProductionLexIndex = recursive ? 0 : this.myProduction.getLexemeIndexAt(i2 - 1);
            for (wsStartIndex = Math.max(lexemeIndex, lastIndex); wsStartIndex > prevProductionLexIndex && this.whitespaceOrComment(this.myLexTypes[wsStartIndex - 1]); --wsStartIndex) {
            }
            int wsEndIndex = this.shiftOverWhitespaceForward(lexemeIndex);
            if (wsStartIndex != wsEndIndex) {
                wsTokens.configure(wsStartIndex, wsEndIndex);
                tokenTextGetter.configure(wsStartIndex);
                boolean atEnd = wsStartIndex == 0 || wsEndIndex == this.myLexemeCount;
                lexemeIndex = wsStartIndex + binder.getEdgePosition((List)wsTokens, atEnd, (WhitespacesAndCommentsBinder.TokenTextGetter)tokenTextGetter);
                item.setLexemeIndex(lexemeIndex, done);
                if (recursive) {
                    this.myProduction.confineMarkersToMaxLexeme(i2, lexemeIndex);
                }
            } else if (lexemeIndex < wsStartIndex) {
                lexemeIndex = wsStartIndex;
                item.setLexemeIndex(wsStartIndex, done);
            }
            lastIndex = lexemeIndex;
        }
    }

    private void checkTreeDepth(int maxDepth, boolean isFileRoot, boolean hasCollapsedChameleons) {
        if (this.myFile == null) {
            return;
        }
        PsiFile file2 = this.myFile.getOriginalFile();
        Boolean flag = (Boolean)file2.getUserData(BlockSupport.TREE_DEPTH_LIMIT_EXCEEDED);
        if (maxDepth > BlockSupport.INCREMENTAL_REPARSE_DEPTH_LIMIT) {
            if (!Boolean.TRUE.equals(flag)) {
                file2.putUserData(BlockSupport.TREE_DEPTH_LIMIT_EXCEEDED, (Object)Boolean.TRUE);
            }
        } else if (isFileRoot && flag != null && !hasCollapsedChameleons) {
            file2.putUserData(BlockSupport.TREE_DEPTH_LIMIT_EXCEEDED, null);
        }
    }

    private void bind(@NotNull StartMarker rootMarker, @NotNull CompositeElement rootNode) {
        ASTFactory astFactory = this.getASTFactory();
        StartMarker curMarker = rootMarker;
        CompositeElement curNode = rootNode;
        int lexIndex = rootMarker.myLexemeIndex;
        ProductionMarker item = rootMarker.myFirstChild != null ? rootMarker.myFirstChild : rootMarker;
        boolean itemDone = rootMarker.myFirstChild == null;
        while (true) {
            lexIndex = this.insertLeaves(lexIndex, item.getLexemeIndex(itemDone), curNode);
            if (item == rootMarker && itemDone) break;
            if (item instanceof StartMarker) {
                StartMarker marker = (StartMarker)item;
                if (itemDone) {
                    curMarker = (StartMarker)marker.myParent;
                    curNode = curNode.getTreeParent();
                    item = marker.myNext;
                    itemDone = false;
                } else {
                    if (!this.myOptionalData.isCollapsed(marker.markerId)) {
                        curMarker = marker;
                        CompositeElement childNode = PsiBuilderImpl.createComposite(marker, astFactory);
                        curNode.rawAddChildrenWithoutNotifications(childNode);
                        curNode = childNode;
                        item = marker.myFirstChild != null ? marker.myFirstChild : marker;
                        itemDone = marker.myFirstChild == null;
                        continue;
                    }
                    lexIndex = this.collapseLeaves(curNode, marker);
                    item = marker.myNext;
                    itemDone = false;
                }
            } else if (item instanceof ErrorItem) {
                CompositeElement errorElement = Factory.createErrorElement(((ErrorItem)item).myMessage);
                curNode.rawAddChildrenWithoutNotifications(errorElement);
                item = item.myNext;
                itemDone = false;
            }
            if (item != null) continue;
            item = curMarker;
            itemDone = true;
        }
    }

    private int insertLeaves(int curToken, int lastIdx, CompositeElement curNode) {
        lastIdx = Math.min(lastIdx, this.myLexemeCount);
        while (curToken < lastIdx) {
            ProgressIndicatorProvider.checkCanceled();
            int start2 = this.myLexStarts[curToken];
            int end = this.myLexStarts[curToken + 1];
            if (start2 < end || this.myLexTypes[curToken] instanceof ILeafElementType) {
                IElementType type = this.myLexTypes[curToken];
                TreeElement leaf = this.createLeaf(type, start2, end);
                curNode.rawAddChildrenWithoutNotifications(leaf);
            }
            ++curToken;
        }
        return curToken;
    }

    private int collapseLeaves(@NotNull CompositeElement ast, @NotNull StartMarker startMarker) {
        int start2 = this.myLexStarts[startMarker.myLexemeIndex];
        int end = this.myLexStarts[startMarker.getEndIndex()];
        IElementType markerType = startMarker.myType;
        TreeElement leaf = this.createLeaf(markerType, start2, end);
        if (PsiBuilderImpl.shouldReuseCollapsedTokens(markerType) && startMarker.myLexemeIndex < startMarker.getEndIndex()) {
            int length = startMarker.getEndIndex() - startMarker.myLexemeIndex;
            int[] relativeStarts = new int[length + 1];
            IElementType[] types = new IElementType[length + 1];
            for (int i2 = startMarker.myLexemeIndex; i2 < startMarker.getEndIndex(); ++i2) {
                relativeStarts[i2 - startMarker.myLexemeIndex] = this.myLexStarts[i2] - start2;
                types[i2 - startMarker.myLexemeIndex] = this.myLexTypes[i2];
            }
            relativeStarts[length] = end - start2;
            leaf.putUserData(LAZY_PARSEABLE_TOKENS, new TokenSequence(relativeStarts, types, length, leaf.getChars()));
        }
        ast.rawAddChildrenWithoutNotifications(leaf);
        return startMarker.getEndIndex();
    }

    private static boolean shouldReuseCollapsedTokens(IElementType collapsed) {
        return collapsed instanceof ILazyParseableElementTypeBase && ((ILazyParseableElementTypeBase)collapsed).reuseCollapsedTokens();
    }

    @NotNull
    private static CompositeElement createComposite(@NotNull StartMarker marker, @Nullable ASTFactory astFactory) {
        CompositeElement composite;
        IElementType type = marker.myType;
        if (type == TokenType.ERROR_ELEMENT) {
            String error = marker.myBuilder.myOptionalData.getDoneError(marker.markerId);
            return Factory.createErrorElement(Objects.requireNonNull(error));
        }
        if (type == null) {
            throw new RuntimeException(UNBALANCED_MESSAGE);
        }
        if (astFactory != null && (composite = astFactory.createComposite(marker.getTokenType())) != null) {
            return composite;
        }
        return ASTFactory.composite(type);
    }

    @NotNull
    private static LazyParseableElement createLazy(@NotNull ILazyParseableElementType type, @Nullable CharSequence text, @Nullable ASTFactory astFactory) {
        LazyParseableElement element2;
        if (astFactory != null && (element2 = astFactory.createLazy(type, text)) != null) {
            return element2;
        }
        return ASTFactory.lazy(type, text);
    }

    @Nullable
    public static String getErrorMessage(@NotNull LighterASTNode node) {
        StartMarker marker;
        if (node instanceof ErrorItem) {
            return ((ErrorItem)node).myMessage;
        }
        if (node instanceof StartMarker && (marker = (StartMarker)node).myType == TokenType.ERROR_ELEMENT) {
            return marker.myBuilder.myOptionalData.getDoneError(marker.markerId);
        }
        return null;
    }

    public void setDebugMode(boolean dbgMode) {
        this.myDebugMode = dbgMode;
    }

    public int getLexemeCount() {
        return this.myLexemeCount;
    }

    @NotNull
    public Lexer getLexer() {
        return this.myLexer;
    }

    @NotNull
    protected TreeElement createLeaf(@NotNull IElementType type, int start2, int end) {
        LeafElement element2;
        CharSequence text = this.myCharTable.intern(this.myText, start2, end);
        if (this.myWhitespaces.contains(type)) {
            return new PsiWhiteSpaceImpl(text);
        }
        if (type instanceof ICustomParsingType) {
            return (TreeElement)((ICustomParsingType)type).parse(text, this.myCharTable);
        }
        ASTFactory astFactory = this.getASTFactory();
        if (type instanceof ILazyParseableElementType) {
            return PsiBuilderImpl.createLazy((ILazyParseableElementType)type, text, astFactory);
        }
        if (astFactory != null && (element2 = astFactory.createLeaf(type, text)) != null) {
            return element2;
        }
        return ASTFactory.leaf(type, text);
    }

    public <T> T getUserData(@NotNull Key<T> key) {
        return (T)(key == FileContextUtil.CONTAINING_FILE_KEY ? this.myFile : super.getUserData(key));
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value2) {
        if (key == FileContextUtil.CONTAINING_FILE_KEY) {
            this.myFile = (PsiFile)value2;
        } else {
            super.putUserData(key, value2);
        }
    }

    private static class ASTConverter
    implements Function<Node, ASTNode> {
        private final StartMarker myRoot;
        private final ASTFactory myASTFactory;

        private ASTConverter(@NotNull StartMarker root, @Nullable ASTFactory astFactory) {
            this.myRoot = root;
            this.myASTFactory = astFactory;
        }

        @Override
        public ASTNode apply(Node n) {
            if (n instanceof Token) {
                Token token = (Token)n;
                return token.getBuilder().createLeaf(token.getTokenType(), token.getStartOffsetInBuilder(), token.getEndOffsetInBuilder());
            }
            if (n instanceof ErrorItem) {
                return Factory.createErrorElement(((ErrorItem)n).myMessage);
            }
            StartMarker startMarker = (StartMarker)n;
            CompositeElement composite = n == this.myRoot ? (CompositeElement)this.myRoot.myBuilder.createRootAST(this.myRoot) : PsiBuilderImpl.createComposite(startMarker, this.myASTFactory);
            startMarker.myBuilder.bind(startMarker, composite);
            return composite;
        }
    }

    private static class MyTreeStructure
    implements FlyweightCapableTreeStructure<LighterASTNode> {
        private final LimitedPool<TokenRangeNode> myRangePool;
        private final LimitedPool<SingleLexemeNode> myLexemePool;
        private final StartMarker myRoot;
        private int count;
        private LighterASTNode[] nodes;

        MyTreeStructure(@NotNull StartMarker root, @Nullable MyTreeStructure parentTree) {
            if (parentTree == null) {
                this.myRangePool = new LimitedPool(1000, (LimitedPool.ObjectFactory)new LimitedPool.ObjectFactory<TokenRangeNode>(){

                    public void cleanup(@NotNull TokenRangeNode token) {
                        token.clean();
                    }

                    @NotNull
                    public TokenRangeNode create() {
                        return new TokenRangeNode();
                    }
                });
                this.myLexemePool = new LimitedPool(1000, (LimitedPool.ObjectFactory)new LimitedPool.ObjectFactory<SingleLexemeNode>(){

                    @NotNull
                    public SingleLexemeNode create() {
                        return new SingleLexemeNode();
                    }

                    public void cleanup(@NotNull SingleLexemeNode node) {
                        node.clean();
                    }
                });
            } else {
                this.myRangePool = parentTree.myRangePool;
                this.myLexemePool = parentTree.myLexemePool;
            }
            this.myRoot = root;
        }

        @NotNull
        public LighterASTNode getRoot() {
            return this.myRoot;
        }

        public LighterASTNode getParent(@NotNull LighterASTNode node) {
            if (node instanceof ProductionMarker) {
                return ((ProductionMarker)node).myParent;
            }
            if (node instanceof Token) {
                return ((Token)node).myParentNode;
            }
            throw new UnsupportedOperationException("Unknown node type: " + node);
        }

        public int getChildren(@NotNull LighterASTNode item, @NotNull Ref<LighterASTNode[]> into) {
            if (item instanceof LazyParseableToken) {
                FlyweightCapableTreeStructure<LighterASTNode> tree = ((LazyParseableToken)item).parseContents();
                LighterASTNode root = (LighterASTNode)tree.getRoot();
                if (root instanceof ProductionMarker) {
                    ((ProductionMarker)root).myParent = ((Token)item).myParentNode;
                }
                return tree.getChildren((Object)root, into);
            }
            if (item instanceof Token || item instanceof ErrorItem) {
                return 0;
            }
            StartMarker marker = (StartMarker)item;
            this.count = 0;
            ProductionMarker child2 = marker.myFirstChild;
            int lexIndex = marker.myLexemeIndex;
            while (child2 != null) {
                lexIndex = this.insertLeaves(lexIndex, child2.myLexemeIndex, marker.myBuilder, marker);
                if (child2 instanceof StartMarker && child2.myBuilder.myOptionalData.isCollapsed(child2.markerId)) {
                    int lastIndex = child2.getEndIndex();
                    this.insertLeaf(child2.getTokenType(), marker.myBuilder, child2.myLexemeIndex, lastIndex, true, marker);
                } else {
                    this.ensureCapacity();
                    this.nodes[this.count++] = child2;
                }
                if (child2 instanceof StartMarker) {
                    lexIndex = child2.getEndIndex();
                }
                child2 = child2.myNext;
            }
            this.insertLeaves(lexIndex, marker.getEndIndex(), marker.myBuilder, marker);
            into.set((Object)(this.nodes == null ? LighterASTNode.EMPTY_ARRAY : this.nodes));
            this.nodes = null;
            return this.count;
        }

        public void disposeChildren(LighterASTNode[] nodes, int count) {
            if (nodes == null) {
                return;
            }
            for (int i2 = 0; i2 < count; ++i2) {
                LighterASTNode node = nodes[i2];
                if (node instanceof TokenRangeNode) {
                    this.myRangePool.recycle((Object)((TokenRangeNode)node));
                    continue;
                }
                if (!(node instanceof SingleLexemeNode)) continue;
                this.myLexemePool.recycle((Object)((SingleLexemeNode)node));
            }
        }

        private void ensureCapacity() {
            LighterASTNode[] old = this.nodes;
            if (old == null) {
                this.nodes = old = new LighterASTNode[10];
            } else if (this.count >= old.length) {
                LighterASTNode[] newStore = new LighterASTNode[this.count * 3 / 2];
                System.arraycopy(old, 0, newStore, 0, this.count);
                this.nodes = newStore;
            }
        }

        private int insertLeaves(int curToken, int lastIdx, PsiBuilderImpl builder2, StartMarker parent) {
            lastIdx = Math.min(lastIdx, builder2.myLexemeCount);
            while (curToken < lastIdx) {
                this.insertLeaf(builder2.myLexTypes[curToken], builder2, curToken, curToken + 1, false, parent);
                ++curToken;
            }
            return curToken;
        }

        private void insertLeaf(@NotNull IElementType type, @NotNull PsiBuilderImpl builder2, int startLexemeIndex, int endLexemeIndex, boolean forceInsertion, StartMarker parent) {
            Token lexeme;
            int end;
            int start2 = builder2.myLexStarts[startLexemeIndex];
            if (start2 > (end = builder2.myLexStarts[endLexemeIndex]) || !forceInsertion && start2 == end && !(type instanceof ILeafElementType)) {
                return;
            }
            if (type instanceof ILightLazyParseableElementType) {
                int startInFile = start2 + builder2.myOffset;
                LazyParseableToken token = (LazyParseableToken)builder2.myChameleonCache.get(startInFile);
                if (token == null) {
                    token = new LazyParseableToken(this, startLexemeIndex, endLexemeIndex);
                    token.initToken(type, parent, start2, end);
                    builder2.myChameleonCache.put(startInFile, (Object)token);
                } else if (token.getBuilder() != builder2 || token.myStartIndex != startLexemeIndex || token.myEndIndex != endLexemeIndex) {
                    throw new AssertionError((Object)"Wrong chameleon cached");
                }
                lexeme = token;
            } else if (startLexemeIndex == endLexemeIndex - 1 && type == builder2.myLexTypes[startLexemeIndex]) {
                SingleLexemeNode single = (SingleLexemeNode)this.myLexemePool.alloc();
                single.myParentNode = parent;
                single.myLexemeIndex = startLexemeIndex;
                lexeme = single;
            } else {
                TokenRangeNode collapsed = (TokenRangeNode)this.myRangePool.alloc();
                collapsed.initToken(type, parent, start2, end);
                lexeme = collapsed;
            }
            this.ensureCapacity();
            this.nodes[this.count++] = lexeme;
        }

        @NotNull
        public CharSequence toString(@NotNull LighterASTNode node) {
            return this.myRoot.myBuilder.myText.subSequence(node.getStartOffset(), node.getEndOffset());
        }

        public int getStartOffset(@NotNull LighterASTNode node) {
            return node.getStartOffset();
        }

        public int getEndOffset(@NotNull LighterASTNode node) {
            return node.getEndOffset();
        }
    }

    private static class MyComparator
    implements ShallowNodeComparator<ASTNode, LighterASTNode> {
        private final TripleFunction<ASTNode, LighterASTNode, FlyweightCapableTreeStructure<LighterASTNode>, ThreeState> myCustom;
        private final List<CustomLanguageASTComparator> myCustomLanguageASTComparators;
        private final MyTreeStructure myTreeStructure;

        private MyComparator(TripleFunction<ASTNode, LighterASTNode, FlyweightCapableTreeStructure<LighterASTNode>, ThreeState> custom, @NotNull List<CustomLanguageASTComparator> customLanguageASTComparators, @NotNull MyTreeStructure treeStructure) {
            this.myCustom = custom;
            this.myCustomLanguageASTComparators = customLanguageASTComparators;
            this.myTreeStructure = treeStructure;
        }

        @NotNull
        public ThreeState deepEqual(@NotNull ASTNode oldNode, @NotNull LighterASTNode newNode) {
            boolean newIsErrorElement;
            ProgressIndicatorProvider.checkCanceled();
            boolean oldIsErrorElement = oldNode instanceof PsiErrorElement;
            boolean bl = newIsErrorElement = newNode.getTokenType() == TokenType.ERROR_ELEMENT;
            if (oldIsErrorElement != newIsErrorElement) {
                return ThreeState.NO;
            }
            if (oldIsErrorElement) {
                PsiErrorElement e1 = (PsiErrorElement)oldNode;
                return Objects.equals(e1.getErrorDescription(), PsiBuilderImpl.getErrorMessage(newNode)) ? ThreeState.UNSURE : ThreeState.NO;
            }
            ThreeState customResult = this.customCompare(oldNode, newNode);
            if (customResult != ThreeState.UNSURE) {
                return customResult;
            }
            if (newNode instanceof Token) {
                IElementType type = newNode.getTokenType();
                Token token = (Token)newNode;
                if (oldNode instanceof ForeignLeafPsiElement) {
                    return type instanceof ForeignLeafType && ((ForeignLeafType)type).getValue().equals(oldNode.getText()) ? ThreeState.YES : ThreeState.NO;
                }
                if (oldNode instanceof LeafElement) {
                    if (type instanceof ForeignLeafType) {
                        return ThreeState.NO;
                    }
                    return ((LeafElement)oldNode).textMatches(token.getText()) ? ThreeState.YES : ThreeState.NO;
                }
                if (type instanceof ILightLazyParseableElementType) {
                    if (((TreeElement)oldNode).textMatches(token.getText())) {
                        return PsiDocumentManagerBase.isFullReparseInProgress() ? ThreeState.UNSURE : ThreeState.YES;
                    }
                    return TreeUtil.isCollapsedChameleon(oldNode) ? ThreeState.NO : ThreeState.UNSURE;
                }
                if (oldNode.getElementType() instanceof ILazyParseableElementType && type instanceof ILazyParseableElementType || oldNode.getElementType() instanceof ICustomParsingType && type instanceof ICustomParsingType) {
                    return ((TreeElement)oldNode).textMatches(token.getText()) ? ThreeState.YES : ThreeState.NO;
                }
            }
            return ThreeState.UNSURE;
        }

        @NotNull
        private ThreeState customCompare(@NotNull ASTNode oldNode, @NotNull LighterASTNode newNode) {
            ThreeState customResult;
            for (CustomLanguageASTComparator comparator2 : this.myCustomLanguageASTComparators) {
                ThreeState customComparatorResult = comparator2.compareAST(oldNode, newNode, (FlyweightCapableTreeStructure)this.myTreeStructure);
                if (customComparatorResult == ThreeState.UNSURE) continue;
                return customComparatorResult;
            }
            if (this.myCustom != null && (customResult = (ThreeState)this.myCustom.fun((Object)oldNode, (Object)newNode, (Object)this.myTreeStructure)) != ThreeState.UNSURE) {
                return customResult;
            }
            return ThreeState.UNSURE;
        }

        public boolean typesEqual(@NotNull ASTNode n1, @NotNull LighterASTNode n2) {
            IElementType n2t;
            ForeignLeafType n1t;
            if (n1 instanceof PsiWhiteSpaceImpl) {
                return ourAnyLanguageWhitespaceTokens.contains(n2.getTokenType()) || n2 instanceof Token && ((Token)n2).getBuilder().myWhitespaces.contains(n2.getTokenType());
            }
            if (n1 instanceof ForeignLeafPsiElement) {
                n1t = ((ForeignLeafPsiElement)n1).getForeignType();
                n2t = n2.getTokenType();
            } else {
                n1t = MyComparator.dereferenceToken(n1.getElementType());
                n2t = MyComparator.dereferenceToken(n2.getTokenType());
            }
            return Comparing.equal((Object)((Object)n1t), (Object)n2t);
        }

        private static IElementType dereferenceToken(IElementType probablyWrapper) {
            if (probablyWrapper instanceof TokenWrapper) {
                return MyComparator.dereferenceToken(((TokenWrapper)probablyWrapper).getDelegate());
            }
            return probablyWrapper;
        }

        public boolean hashCodesEqual(@NotNull ASTNode n1, @NotNull LighterASTNode n2) {
            PsiErrorElement e1;
            if (n1 instanceof LeafElement && n2 instanceof Token) {
                boolean isForeign1 = n1 instanceof ForeignLeafPsiElement;
                boolean isForeign2 = n2.getTokenType() instanceof ForeignLeafType;
                if (isForeign1 != isForeign2) {
                    return false;
                }
                if (isForeign1) {
                    return n1.getText().equals(((ForeignLeafType)n2.getTokenType()).getValue());
                }
                return ((LeafElement)n1).textMatches(((Token)n2).getText());
            }
            if (n1 instanceof PsiErrorElement && n2.getTokenType() == TokenType.ERROR_ELEMENT && !Objects.equals((e1 = (PsiErrorElement)n1).getErrorDescription(), PsiBuilderImpl.getErrorMessage(n2))) {
                return false;
            }
            return ((Node)n2).tokenTextMatches(n1.getChars());
        }
    }

    private final class RelativeTokenTextView
    implements WhitespacesAndCommentsBinder.TokenTextGetter {
        private int myStart;

        private RelativeTokenTextView() {
        }

        private void configure(int start2) {
            this.myStart = start2;
        }

        @NotNull
        public CharSequence get(int i2) {
            return PsiBuilderImpl.this.myText.subSequence(PsiBuilderImpl.this.myLexStarts[this.myStart + i2], PsiBuilderImpl.this.myLexStarts[this.myStart + i2 + 1]);
        }
    }

    private final class RelativeTokenTypesView
    extends AbstractList<IElementType> {
        private int myStart;
        private int mySize;

        private RelativeTokenTypesView() {
        }

        private void configure(int start2, int end) {
            this.myStart = start2;
            this.mySize = end - start2;
        }

        @Override
        public IElementType get(int index) {
            return PsiBuilderImpl.this.myLexTypes[this.myStart + index];
        }

        @Override
        public int size() {
            return this.mySize;
        }
    }

    private static class ConvertFromTokensToASTBuilder
    implements DiffTreeChangeBuilder<ASTNode, LighterASTNode> {
        private final DiffTreeChangeBuilder<? super ASTNode, ? super ASTNode> myDelegate;
        private final ASTConverter myConverter;

        private ConvertFromTokensToASTBuilder(@NotNull StartMarker rootNode, @NotNull DiffTreeChangeBuilder<? super ASTNode, ? super ASTNode> delegate, @Nullable ASTFactory astFactory) {
            this.myDelegate = delegate;
            this.myConverter = new ASTConverter(rootNode, astFactory);
        }

        public void nodeDeleted(@NotNull ASTNode oldParent, @NotNull ASTNode oldNode) {
            this.myDelegate.nodeDeleted((Object)oldParent, (Object)oldNode);
        }

        public void nodeInserted(@NotNull ASTNode oldParent, @NotNull LighterASTNode newNode, int pos) {
            this.myDelegate.nodeInserted((Object)oldParent, (Object)this.myConverter.apply((Node)newNode), pos);
        }

        public void nodeReplaced(@NotNull ASTNode oldChild, @NotNull LighterASTNode newChild) {
            ASTNode converted = this.myConverter.apply((Node)newChild);
            this.myDelegate.nodeReplaced((Object)oldChild, (Object)converted);
        }
    }

    static class ErrorItem
    extends ProductionMarker {
        private String myMessage;

        ErrorItem(int markerId, PsiBuilderImpl builder2) {
            super(markerId, builder2);
        }

        @Override
        void clean() {
            super.clean();
            this.myMessage = null;
        }

        @Override
        @NotNull
        public WhitespacesAndCommentsBinder getBinder(boolean done) {
            assert (!done);
            return WhitespacesBinders.DEFAULT_RIGHT_BINDER;
        }

        @Override
        void setLexemeIndex(int lexemeIndex, boolean done) {
            assert (!done);
            this.myLexemeIndex = lexemeIndex;
        }

        @Override
        int getLexemeIndex(boolean done) {
            assert (!done);
            return this.myLexemeIndex;
        }

        @Override
        public boolean tokenTextMatches(CharSequence chars) {
            return chars.length() == 0;
        }

        public int getEndOffset() {
            return this.getStartOffset();
        }

        @Override
        public int getEndIndex() {
            return this.getStartIndex();
        }

        @NotNull
        public IElementType getTokenType() {
            return TokenType.ERROR_ELEMENT;
        }
    }

    private static class LazyParseableToken
    extends TokenRange
    implements LighterLazyParseableNode {
        private final MyTreeStructure myParentStructure;
        private final int myStartIndex;
        private final int myEndIndex;
        private FlyweightCapableTreeStructure<LighterASTNode> myParsed;

        LazyParseableToken(MyTreeStructure parentStructure, int startIndex, int endIndex) {
            this.myParentStructure = parentStructure;
            this.myStartIndex = startIndex;
            this.myEndIndex = endIndex;
        }

        public PsiFile getContainingFile() {
            return this.getBuilder().myFile;
        }

        public CharTable getCharTable() {
            return this.getBuilder().myCharTable;
        }

        public FlyweightCapableTreeStructure<LighterASTNode> parseContents() {
            FlyweightCapableTreeStructure parsed = this.myParsed;
            if (parsed == null) {
                this.myParsed = parsed = ((ILightLazyParseableElementType)this.getTokenType()).parseContents((LighterLazyParseableNode)this);
            }
            return parsed;
        }

        public boolean accept(@NotNull LighterLazyParseableNode.Visitor visitor) {
            for (int i2 = this.myStartIndex; i2 < this.myEndIndex; ++i2) {
                IElementType type = this.getBuilder().myLexTypes[i2];
                if (visitor.visit(type)) continue;
                return false;
            }
            return true;
        }

        @Nullable
        private TokenSequence getParsedTokenSequence() {
            int tokenCount = this.myEndIndex - this.myStartIndex;
            if (tokenCount == 1) {
                return null;
            }
            int[] lexStarts = new int[tokenCount + 1];
            System.arraycopy(this.getBuilder().myLexStarts, this.myStartIndex, lexStarts, 0, tokenCount);
            int diff = this.getBuilder().myLexStarts[this.myStartIndex];
            int i2 = 0;
            while (i2 < tokenCount) {
                int n = i2++;
                lexStarts[n] = lexStarts[n] - diff;
            }
            lexStarts[tokenCount] = this.getEndOffset() - this.getStartOffset();
            IElementType[] lexTypes = new IElementType[tokenCount + 1];
            System.arraycopy(this.getBuilder().myLexTypes, this.myStartIndex, lexTypes, 0, tokenCount);
            return new TokenSequence(lexStarts, lexTypes, tokenCount, this.getText());
        }
    }

    private static class SingleLexemeNode
    extends Token
    implements LighterASTTokenNode {
        private int myLexemeIndex;

        private SingleLexemeNode() {
        }

        @Override
        int getStartOffsetInBuilder() {
            return this.getBuilder().myLexStarts[this.myLexemeIndex];
        }

        @Override
        int getEndOffsetInBuilder() {
            return this.getBuilder().myLexStarts[this.myLexemeIndex + 1];
        }

        @NotNull
        public IElementType getTokenType() {
            return this.getBuilder().myLexTypes[this.myLexemeIndex];
        }
    }

    private static class TokenRangeNode
    extends TokenRange
    implements LighterASTTokenNode {
        private TokenRangeNode() {
        }
    }

    private static abstract class TokenRange
    extends Token {
        private int myTokenStart;
        private int myTokenEnd;
        private IElementType myTokenType;

        private TokenRange() {
        }

        @Override
        int getStartOffsetInBuilder() {
            return this.myTokenStart;
        }

        @Override
        int getEndOffsetInBuilder() {
            return this.myTokenEnd;
        }

        public IElementType getTokenType() {
            return this.myTokenType;
        }

        void initToken(@NotNull IElementType type, StartMarker parent, int start2, int end) {
            this.myParentNode = parent;
            this.myTokenType = type;
            this.myTokenStart = start2;
            this.myTokenEnd = end;
        }
    }

    private static abstract class Token
    implements Node {
        StartMarker myParentNode;

        private Token() {
        }

        @Override
        public boolean tokenTextMatches(CharSequence chars) {
            int start2 = this.getStartOffsetInBuilder();
            int end = this.getEndOffsetInBuilder();
            if (end - start2 != chars.length()) {
                return false;
            }
            PsiBuilderImpl builder2 = this.getBuilder();
            return builder2.myTextArray != null ? CharArrayUtil.regionMatches((char[])builder2.myTextArray, (int)start2, (int)end, (CharSequence)chars) : CharArrayUtil.regionMatches((CharSequence)builder2.myText, (int)start2, (int)end, (CharSequence)chars);
        }

        public final int getEndOffset() {
            return this.getEndOffsetInBuilder() + this.getBuilder().myOffset;
        }

        public final int getStartOffset() {
            return this.getStartOffsetInBuilder() + this.getBuilder().myOffset;
        }

        @NotNull
        public final CharSequence getText() {
            if (this.getTokenType() instanceof TokenWrapper) {
                return ((TokenWrapper)this.getTokenType()).getValue();
            }
            return this.getBuilder().myText.subSequence(this.getStartOffsetInBuilder(), this.getEndOffsetInBuilder());
        }

        PsiBuilderImpl getBuilder() {
            return this.myParentNode.myBuilder;
        }

        abstract int getStartOffsetInBuilder();

        abstract int getEndOffsetInBuilder();

        void clean() {
            this.myParentNode = null;
        }

        public String toString() {
            return this.getText().toString();
        }
    }

    static class StartMarker
    extends ProductionMarker
    implements PsiBuilder.Marker {
        private IElementType myType;
        private int myDoneLexeme = -1;
        private ProductionMarker myFirstChild;
        private ProductionMarker myLastChild;

        StartMarker(int markerId, PsiBuilderImpl builder2) {
            super(markerId, builder2);
        }

        @Override
        void clean() {
            super.clean();
            this.myBuilder.myOptionalData.clean(this.markerId);
            this.myType = null;
            this.myDoneLexeme = -1;
            this.myLastChild = null;
            this.myFirstChild = null;
        }

        @Override
        public boolean tokenTextMatches(CharSequence chars) {
            if (this.myFirstChild != null) {
                throw new IllegalStateException("textMatches shouldn't be called on non-empty composite nodes");
            }
            return chars.length() == 0;
        }

        public int getEndOffset() {
            return this.myBuilder.myLexStarts[this.getEndIndex()] + this.myBuilder.myOffset;
        }

        @Override
        public int getEndIndex() {
            return this.myDoneLexeme;
        }

        @Override
        @NotNull
        WhitespacesAndCommentsBinder getBinder(boolean done) {
            return this.myBuilder.myOptionalData.getBinder(this.markerId, done);
        }

        @Override
        void setLexemeIndex(int lexemeIndex, boolean done) {
            if (done) {
                this.myDoneLexeme = lexemeIndex;
            } else {
                this.myLexemeIndex = lexemeIndex;
            }
        }

        @Override
        int getLexemeIndex(boolean done) {
            return done ? this.myDoneLexeme : this.myLexemeIndex;
        }

        public void addChild(@NotNull ProductionMarker node) {
            if (this.myFirstChild == null) {
                this.myFirstChild = node;
            } else {
                this.myLastChild.myNext = node;
            }
            this.myLastChild = node;
        }

        @NotNull
        public PsiBuilder.Marker precede() {
            return this.myBuilder.precede(this);
        }

        public void drop() {
            this.myBuilder.myProduction.dropMarker(this);
        }

        public void rollbackTo() {
            this.myBuilder.rollbackTo(this);
        }

        public void done(@NotNull IElementType type) {
            if (type == TokenType.ERROR_ELEMENT) {
                LOG.warn("Error elements with empty message are discouraged. Please use builder.error() instead", (Throwable)new RuntimeException());
            }
            this.myType = type;
            this.myBuilder.processDone(this, null, null);
        }

        public void collapse(@NotNull IElementType type) {
            this.done(type);
            this.myBuilder.myOptionalData.markCollapsed(this.markerId);
        }

        public void doneBefore(@NotNull IElementType type, @NotNull PsiBuilder.Marker before) {
            if (type == TokenType.ERROR_ELEMENT) {
                LOG.warn("Error elements with empty message are discouraged. Please use builder.errorBefore() instead", (Throwable)new RuntimeException());
            }
            this.myType = type;
            this.myBuilder.processDone(this, null, (StartMarker)before);
        }

        public void doneBefore(@NotNull IElementType type, @NotNull PsiBuilder.Marker before, @NotNull String errorMessage) {
            StartMarker marker = (StartMarker)before;
            ErrorItem errorItem = this.myBuilder.myPool.allocateErrorItem();
            errorItem.myMessage = errorMessage;
            errorItem.myLexemeIndex = marker.myLexemeIndex;
            this.myBuilder.myProduction.addBefore(errorItem, marker);
            this.doneBefore(type, before);
        }

        public void error(@NotNull String message) {
            this.myType = TokenType.ERROR_ELEMENT;
            this.myBuilder.processDone(this, message, null);
        }

        public void errorBefore(@NotNull String message, @NotNull PsiBuilder.Marker before) {
            this.myType = TokenType.ERROR_ELEMENT;
            this.myBuilder.processDone(this, message, (StartMarker)before);
        }

        public IElementType getTokenType() {
            return this.myType;
        }

        @Override
        public void remapTokenType(@NotNull IElementType type) {
            this.myType = type;
        }

        public void setCustomEdgeTokenBinders(WhitespacesAndCommentsBinder left, WhitespacesAndCommentsBinder right) {
            if (left != null) {
                this.myBuilder.myOptionalData.assignBinder(this.markerId, left, false);
            }
            if (right != null) {
                this.myBuilder.myOptionalData.assignBinder(this.markerId, right, true);
            }
        }

        public String toString() {
            if (this.myLexemeIndex < 0) {
                return "<dropped>";
            }
            boolean isDone = this.isDone();
            CharSequence originalText = this.myBuilder.getOriginalText();
            int startOffset = this.getStartOffset() - this.myBuilder.myOffset;
            int endOffset = isDone ? this.getEndOffset() - this.myBuilder.myOffset : this.myBuilder.getCurrentOffset();
            CharSequence text = originalText.subSequence(startOffset, endOffset);
            return isDone ? text.toString() : text + "\u2026";
        }

        boolean isDone() {
            return this.myDoneLexeme != -1;
        }
    }

    public static abstract class ProductionMarker
    implements Node {
        final int markerId;
        protected final PsiBuilderImpl myBuilder;
        protected int myLexemeIndex = -1;
        protected ProductionMarker myParent;
        protected ProductionMarker myNext;

        ProductionMarker(int markerId, @NotNull PsiBuilderImpl builder2) {
            this.markerId = markerId;
            this.myBuilder = builder2;
        }

        void clean() {
            this.myLexemeIndex = -1;
            this.myNext = null;
            this.myParent = null;
        }

        public int getStartOffset() {
            return this.myBuilder.myLexStarts[this.myLexemeIndex] + this.myBuilder.myOffset;
        }

        public void remapTokenType(@NotNull IElementType type) {
            throw new UnsupportedOperationException("Shall not be called on this kind of markers");
        }

        public int getStartIndex() {
            return this.myLexemeIndex;
        }

        public int getEndIndex() {
            throw new UnsupportedOperationException("Shall not be called on this kind of markers");
        }

        @NotNull
        abstract WhitespacesAndCommentsBinder getBinder(boolean var1);

        abstract void setLexemeIndex(int var1, boolean var2);

        abstract int getLexemeIndex(boolean var1);
    }

    private static interface Node
    extends LighterASTNode {
        public boolean tokenTextMatches(CharSequence var1);
    }
}

