/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.PerFileMappingState;
import com.intellij.lang.PerFileMappingsEx;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.impl.FilePropertyPusher;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdater;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.NonPhysicalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.reference.SoftReference;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import gnu.trove.THashMap;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PerFileMappingsBase<T>
implements PersistentStateComponent<Element>,
PerFileMappingsEx<T>,
Disposable {
    private final Project myProject;
    private List<PerFileMappingState> myDeferredMappings;
    private final Map<VirtualFile, T> myMappings = new HashMap<VirtualFile, T>();

    public PerFileMappingsBase() {
        this(null);
    }

    public PerFileMappingsBase(@Nullable Project project) {
        this.myProject = project;
        this.installDeleteUndo();
    }

    public void dispose() {
    }

    @Nullable
    protected FilePropertyPusher<T> getFilePropertyPusher() {
        return null;
    }

    @Nullable
    protected Project getProject() {
        return this.myProject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Map<VirtualFile, T> getMappings() {
        Map<VirtualFile, T> map2 = this.myMappings;
        synchronized (map2) {
            this.ensureStateLoaded();
            this.cleanup();
            return Collections.unmodifiableMap(this.myMappings);
        }
    }

    private void cleanup() {
        this.myMappings.keySet().removeIf(file2 -> file2 != null && !file2.isValid());
    }

    @Nullable
    public T getMapping(@Nullable VirtualFile file2) {
        T t = this.getConfiguredMapping(file2);
        return t == null ? this.getDefaultMapping(file2) : t;
    }

    @Nullable
    public T getConfiguredMapping(@Nullable VirtualFile file2) {
        FilePropertyPusher<T> pusher = this.getFilePropertyPusher();
        return this.getMappingInner(file2, pusher == null ? null : pusher.getFileDataKey(), false);
    }

    @Nullable
    public T getDirectlyConfiguredMapping(@Nullable VirtualFile file2) {
        return this.getMappingInner(file2, null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private T getMappingInner(@Nullable VirtualFile file2, @Nullable Key<T> pusherKey, boolean forHierarchy) {
        Object pushedValue;
        VirtualFile originalFile;
        if (file2 instanceof VirtualFileWindow) {
            VirtualFileWindow window = (VirtualFileWindow)file2;
            file2 = window.getDelegate();
        }
        VirtualFile virtualFile = originalFile = file2 instanceof LightVirtualFile ? ((LightVirtualFile)file2).getOriginalFile() : null;
        if (Comparing.equal((Object)originalFile, (Object)file2)) {
            originalFile = null;
        }
        if (file2 != null) {
            Object object = pushedValue = pusherKey == null ? null : file2.getUserData(pusherKey);
            if (pushedValue != null) {
                return (T)pushedValue;
            }
        }
        if (originalFile != null) {
            Object object = pushedValue = pusherKey == null ? null : originalFile.getUserData(pusherKey);
            if (pushedValue != null) {
                return (T)pushedValue;
            }
        }
        Map<VirtualFile, T> map2 = this.myMappings;
        synchronized (map2) {
            this.ensureStateLoaded();
            T t = PerFileMappingsBase.getMappingForHierarchy(file2, this.myMappings);
            if (t != null) {
                return t;
            }
            t = PerFileMappingsBase.getMappingForHierarchy(originalFile, this.myMappings);
            if (t != null) {
                return t;
            }
            if (forHierarchy && file2 != null) {
                return null;
            }
            return this.getNotInHierarchy(originalFile != null ? originalFile : file2, this.myMappings);
        }
    }

    @Nullable
    protected T getNotInHierarchy(@Nullable VirtualFile file2, @NotNull Map<VirtualFile, T> mappings) {
        if (this.getProject() == null || file2 == null || file2.getFileSystem() instanceof NonPhysicalFileSystem || !this.getProject().isDefault() && ProjectFileIndex.getInstance((Project)this.getProject()).isInContent(file2)) {
            return mappings.get(null);
        }
        return null;
    }

    private static <T> T getMappingForHierarchy(@Nullable VirtualFile file2, @NotNull Map<VirtualFile, T> mappings) {
        for (VirtualFile cur = file2; cur != null; cur = cur.getParent()) {
            T t = mappings.get(cur);
            if (t == null) continue;
            return t;
        }
        return null;
    }

    @Override
    @Nullable
    public T getDefaultMapping(@Nullable VirtualFile file2) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public T getImmediateMapping(@Nullable VirtualFile file2) {
        Map<VirtualFile, T> map2 = this.myMappings;
        synchronized (map2) {
            this.ensureStateLoaded();
            return this.myMappings.get(file2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMappings(@NotNull Map<VirtualFile, T> mappings) {
        ArrayList<VirtualFile> oldFiles;
        Map<VirtualFile, T> map2 = this.myMappings;
        synchronized (map2) {
            this.myDeferredMappings = null;
            oldFiles = new ArrayList<VirtualFile>(this.myMappings.keySet());
            this.myMappings.clear();
            this.myMappings.putAll(mappings);
            this.cleanup();
        }
        Project project = this.getProject();
        this.handleMappingChange(mappings.keySet(), oldFiles, project != null && !project.isDefault());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMapping(@Nullable VirtualFile file2, @Nullable T value2) {
        Map<VirtualFile, T> map2 = this.myMappings;
        synchronized (map2) {
            this.ensureStateLoaded();
            if (value2 == null) {
                this.myMappings.remove(file2);
            } else {
                this.myMappings.put(file2, value2);
            }
        }
        List files2 = ContainerUtil.createMaybeSingletonList((Object)file2);
        this.handleMappingChange(files2, files2, false);
    }

    private void handleMappingChange(Collection<? extends VirtualFile> files2, Collection<? extends VirtualFile> oldFiles, boolean includeOpenFiles) {
        Project project = this.getProject();
        FilePropertyPusher<T> pusher = this.getFilePropertyPusher();
        if (project != null && pusher != null) {
            for (VirtualFile virtualFile : oldFiles) {
                if (virtualFile == null) continue;
                virtualFile.putUserData(pusher.getFileDataKey(), null);
            }
            if (!project.isDefault()) {
                PushedFilePropertiesUpdater.getInstance((Project)project).pushAll(new FilePropertyPusher[]{pusher});
            }
        }
        if (this.shouldReparseFiles()) {
            Project[] projects;
            Project[] projectArray;
            if (project == null) {
                projectArray = ProjectManager.getInstance().getOpenProjects();
            } else {
                Project[] projectArray2 = new Project[1];
                projectArray = projectArray2;
                projectArray2[0] = project;
            }
            for (Project p : projects = projectArray) {
                PsiDocumentManager.getInstance((Project)p).reparseFiles(files2, includeOpenFiles);
            }
        }
    }

    @NotNull
    public abstract List<T> getAvailableValues();

    @Nullable
    protected abstract String serialize(T var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element getState() {
        Map<VirtualFile, T> map2 = this.myMappings;
        synchronized (map2) {
            if (this.myDeferredMappings != null) {
                return PerFileMappingState.write(this.myDeferredMappings, this.getValueAttribute());
            }
            this.cleanup();
            Element element2 = new Element("x");
            ArrayList<VirtualFile> files2 = new ArrayList<VirtualFile>(this.myMappings.keySet());
            files2.sort((o1, o2) -> {
                if (o1 == null || o2 == null) {
                    return o1 == null ? (o2 == null ? 0 : 1) : -1;
                }
                return o1.getPath().compareTo(o2.getPath());
            });
            for (VirtualFile file2 : files2) {
                String valueStr;
                T value2 = this.myMappings.get(file2);
                String string = valueStr = value2 == null ? null : this.serialize(value2);
                if (valueStr == null) continue;
                Element child2 = new Element("file");
                element2.addContent(child2);
                child2.setAttribute("url", file2 == null ? "PROJECT" : file2.getUrl());
                child2.setAttribute(this.getValueAttribute(), valueStr);
            }
            return element2;
        }
    }

    @Nullable
    protected T handleUnknownMapping(VirtualFile file2, String value2) {
        return null;
    }

    @Deprecated
    @NotNull
    protected String getValueAttribute() {
        return "value";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadState(@NotNull Element element2) {
        List<PerFileMappingState> list2 = PerFileMappingState.read(element2, this.getValueAttribute());
        Map<VirtualFile, T> map2 = this.myMappings;
        synchronized (map2) {
            if (list2.isEmpty()) {
                this.myMappings.clear();
                this.myDeferredMappings = null;
            } else {
                this.myDeferredMappings = list2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureStateLoaded() {
        Map<VirtualFile, T> map2 = this.myMappings;
        synchronized (map2) {
            List<PerFileMappingState> state = this.myDeferredMappings;
            if (state == null) {
                return;
            }
            this.myDeferredMappings = null;
            THashMap valuesMap = new THashMap();
            for (T value2 : this.getAvailableValues()) {
                String key = this.serialize(value2);
                if (key == null) continue;
                valuesMap.put((Object)key, value2);
            }
            this.myMappings.clear();
            for (PerFileMappingState entry : state) {
                String url = entry.getUrl();
                String valueStr = entry.getValue();
                VirtualFile file2 = "PROJECT".equals(url) ? null : VirtualFileManager.getInstance().findFileByUrl(url);
                Object value3 = valuesMap.get((Object)valueStr);
                if (value3 == null && (value3 = this.handleUnknownMapping(file2, valueStr)) == null || file2 == null && !url.equals("PROJECT")) continue;
                this.myMappings.put(file2, value3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupForNextTest() {
        Map<VirtualFile, T> map2 = this.myMappings;
        synchronized (map2) {
            this.myDeferredMappings = null;
            this.myMappings.clear();
        }
    }

    protected boolean shouldReparseFiles() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasMappings() {
        Map<VirtualFile, T> map2 = this.myMappings;
        synchronized (map2) {
            this.ensureStateLoaded();
            return !this.myMappings.isEmpty();
        }
    }

    private void installDeleteUndo() {
        Application app = ApplicationManager.getApplication();
        if (app == null) {
            return;
        }
        app.getMessageBus().connect((Disposable)this).subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){
            WeakReference<MyUndoableAction> lastAction;

            public void before(@NotNull List<? extends VFileEvent> events) {
                if (CommandProcessor.getInstance().isUndoTransparentActionInProgress()) {
                    return;
                }
                Project project = CommandProcessor.getInstance().getCurrentCommandProject();
                if (project == null || !project.isOpen()) {
                    return;
                }
                MyUndoableAction action2 = this.createUndoableAction(events);
                if (action2 == null) {
                    return;
                }
                action2.doRemove(action2.removed);
                this.lastAction = new WeakReference<MyUndoableAction>(action2);
                UndoManager.getInstance((Project)project).undoableActionPerformed((UndoableAction)action2);
            }

            public void after(@NotNull List<? extends VFileEvent> events) {
                MyUndoableAction action2 = (MyUndoableAction)((Object)SoftReference.dereference(this.lastAction));
                this.lastAction = null;
                if (action2 != null) {
                    ApplicationManager.getApplication().invokeLater(() -> action2.doAdd(action2.added));
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Nullable
            MyUndoableAction createUndoableAction(@NotNull List<? extends VFileEvent> events) {
                List eventsFiltered = JBIterable.from(events).filter(VFileDeleteEvent.class).toList();
                if (eventsFiltered.isEmpty()) {
                    return null;
                }
                HashMap removed = new HashMap();
                HashMap added = new HashMap();
                TreeSet navSet = null;
                Map map2 = PerFileMappingsBase.this.myMappings;
                synchronized (map2) {
                    PerFileMappingsBase.this.ensureStateLoaded();
                    for (VFileEvent event : eventsFiltered) {
                        VirtualFile child2;
                        VirtualFile file2 = event.getFile();
                        if (file2 == null) continue;
                        String fileUrl = file2.getUrl();
                        if (!file2.isDirectory()) {
                            Object m = PerFileMappingsBase.this.myMappings.get(file2);
                            if (m == null) continue;
                            removed.put(fileUrl, m);
                            continue;
                        }
                        if (navSet == null) {
                            navSet = new TreeSet((f1, f2) -> Comparing.compare((Comparable)((Object)(f1 == null ? null : f1.getUrl())), (Comparable)((Object)(f2 == null ? null : f2.getUrl()))));
                            navSet.addAll(PerFileMappingsBase.this.myMappings.keySet());
                        }
                        Iterator iterator2 = navSet.tailSet(file2).iterator();
                        while (iterator2.hasNext() && VfsUtilCore.isAncestor((VirtualFile)file2, (VirtualFile)(child2 = (VirtualFile)iterator2.next()), (boolean)false)) {
                            String childUrl = child2.getUrl();
                            Object m = PerFileMappingsBase.this.myMappings.get(child2);
                            removed.put(childUrl, m);
                        }
                    }
                }
                return removed.isEmpty() && added.isEmpty() ? null : new MyUndoableAction(added, removed);
            }
        });
    }

    private class MyUndoableAction
    extends BasicUndoableAction {
        final Map<String, T> added;
        final Map<String, T> removed;

        MyUndoableAction(Map<String, T> added, Map<String, T> removed) {
            this.added = added;
            this.removed = removed;
        }

        public void undo() {
            this.doRemove(this.added);
            this.doAdd(this.removed);
        }

        public void redo() {
            this.doRemove(this.removed);
            this.doAdd(this.added);
        }

        void doAdd(Map<String, T> toAdd) {
            if (toAdd == null) {
                return;
            }
            for (String url : toAdd.keySet()) {
                VirtualFile file2 = VirtualFileManager.getInstance().findFileByUrl(url);
                if (file2 == null) continue;
                PerFileMappingsBase.this.setMapping(file2, toAdd.get(url));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void doRemove(Map<String, T> toRemove2) {
            if (toRemove2 != null) {
                Map map2 = PerFileMappingsBase.this.myMappings;
                synchronized (map2) {
                    for (String url : toRemove2.keySet()) {
                        VirtualFile file2 = VirtualFileManager.getInstance().findFileByUrl(url);
                        if (file2 == null) continue;
                        PerFileMappingsBase.this.myMappings.remove(file2);
                    }
                }
            }
        }
    }
}

