/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jdkEx;

import com.intellij.jdkEx.DefDisplayModeEx;
import com.intellij.jdkEx.DefInputEventEx;
import com.intellij.jdkEx.DisplayModeEx;
import com.intellij.jdkEx.InputEventEx;
import com.intellij.jdkEx.JBDisplayModeEx;
import com.intellij.jdkEx.JBInputEventEx;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.MethodInvocator;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.awt.AWTAccessor;

@ApiStatus.Experimental
public final class JdkEx {
    @NotNull
    public static InputEventEx getInputEventEx() {
        if (SystemInfo.isJetBrainsJvm) {
            return new JBInputEventEx();
        }
        return new DefInputEventEx();
    }

    public static DisplayModeEx getDisplayModeEx() {
        if (SystemInfo.isJetBrainsJvm) {
            return new JBDisplayModeEx();
        }
        return new DefDisplayModeEx();
    }

    public static boolean isCustomDecorationSupported() {
        if (SystemInfo.isJetBrainsJvm && SystemInfo.isWin10OrNewer) {
            return MyCustomDecorMethods.SET_HAS_CUSTOM_DECORATION.isAvailable();
        }
        return false;
    }

    public static void setHasCustomDecoration(@NotNull Window window) {
        if (!JdkEx.isCustomDecorationSupported()) {
            return;
        }
        MyCustomDecorMethods.SET_HAS_CUSTOM_DECORATION.invoke(window, new Object[0]);
    }

    public static void setCustomDecorationHitTestSpots(@NotNull Window window, @NotNull List<Rectangle> spots) {
        if (!JdkEx.isCustomDecorationSupported()) {
            return;
        }
        MyCustomDecorMethods.SET_CUSTOM_DECORATION_HITTEST_SPOTS.invoke(AWTAccessor.getComponentAccessor().getPeer(window), spots);
    }

    public static void setCustomDecorationTitleBarHeight(@NotNull Window window, int height) {
        if (!JdkEx.isCustomDecorationSupported()) {
            return;
        }
        MyCustomDecorMethods.SET_CUSTOM_DECORATION_TITLEBAR_HEIGHT.invoke(AWTAccessor.getComponentAccessor().getPeer(window), height);
    }

    public static void setIgnoreMouseEvents(@NotNull Window window, boolean ignoreMouseEvents) {
        if (SystemInfo.isJetBrainsJvm && (SystemInfo.isMac || SystemInfo.isWindows)) {
            window.setEnabled(false);
            try {
                MethodInvocator invocator = new MethodInvocator(false, Class.forName("java.awt.Window"), "setIgnoreMouseEvents", new Class[]{Boolean.TYPE});
                if (invocator.isAvailable()) {
                    invocator.invoke((Object)window, new Object[]{ignoreMouseEvents});
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    private static class MyMethod {
        private static final MyMethod EMPTY_INSTANCE = new MyMethod(null);
        @Nullable
        MethodInvocator myInvocator;

        public static MyMethod create(@NotNull String className, @NotNull String methodName, Class<?> ... parameterTypes) {
            try {
                return MyMethod.create(Class.forName(className), methodName, parameterTypes);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return EMPTY_INSTANCE;
            }
        }

        public static MyMethod create(@NotNull Class<?> cls, @NotNull String methodName, Class<?> ... parameterTypes) {
            return new MyMethod(new MethodInvocator(false, cls, methodName, (Class[])parameterTypes));
        }

        private MyMethod(@Nullable MethodInvocator invocator) {
            this.myInvocator = invocator;
        }

        public boolean isAvailable() {
            return this.myInvocator != null && this.myInvocator.isAvailable();
        }

        @Nullable
        public Object invoke(Object object, Object ... arguments) {
            if (this.isAvailable()) {
                return this.myInvocator.invoke(object, arguments);
            }
            return null;
        }
    }

    private static final class MyCustomDecorMethods {
        public static final MyMethod SET_HAS_CUSTOM_DECORATION = MyMethod.create(Window.class, "setHasCustomDecoration", new Class[0]);
        public static final MyMethod SET_CUSTOM_DECORATION_HITTEST_SPOTS = MyMethod.create("sun.awt.windows.WWindowPeer", "setCustomDecorationHitTestSpots", List.class);
        public static final MyMethod SET_CUSTOM_DECORATION_TITLEBAR_HEIGHT = MyMethod.create("sun.awt.windows.WWindowPeer", "setCustomDecorationTitleBarHeight", Integer.TYPE);

        private MyCustomDecorMethods() {
        }
    }
}

