/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.projectView;

import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.ide.scopeView.ScopeViewPane;
import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.beans.MetricEventFactoryKt;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class ProjectViewCollector
extends ProjectUsagesCollector {
    @NonNls
    @NotNull
    public String getGroupId() {
        return "project.view.pane";
    }

    @NotNull
    protected Set<MetricEvent> getMetrics(@NotNull Project project) {
        NamedScope selectedScope;
        ProjectView projectView = ProjectView.getInstance(project);
        if (projectView == null) {
            return Collections.emptySet();
        }
        AbstractProjectViewPane currentViewPane = projectView.getCurrentProjectViewPane();
        if (currentViewPane == null) {
            return Collections.emptySet();
        }
        FeatureUsageData data2 = new FeatureUsageData().addPluginInfo(PluginInfoDetectorKt.getPluginInfo(currentViewPane.getClass())).addData("class_name", currentViewPane.getClass().getName());
        NamedScope namedScope = selectedScope = currentViewPane instanceof ScopeViewPane ? ((ScopeViewPane)currentViewPane).getSelectedScope() : null;
        if (selectedScope != null) {
            data2.addData("scope_class_name", selectedScope.getClass().getName());
        }
        return Collections.singleton(MetricEventFactoryKt.newMetric((String)"current", (FeatureUsageData)data2));
    }
}

