/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.editor;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.CodeInsightWorkspaceSettings;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.impl.tooltips.TooltipActionProvider;
import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.beans.MetricEventFactoryKt;
import com.intellij.internal.statistic.beans.MetricEventUtilKt;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.openapi.editor.actions.CaretStopBoundary;
import com.intellij.openapi.editor.actions.CaretStopOptions;
import com.intellij.openapi.editor.actions.CaretStopOptionsTransposed;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapAppliancePlaces;
import com.intellij.openapi.editor.richcopy.settings.RichCopySettings;
import com.intellij.openapi.project.Project;
import com.intellij.ui.tabs.FileColorManagerImpl;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

final class EditorSettingsStatisticsCollector
extends ApplicationUsagesCollector {
    EditorSettingsStatisticsCollector() {
    }

    @NotNull
    public String getGroupId() {
        return "editor.settings.ide";
    }

    public int getVersion() {
        return 5;
    }

    @NotNull
    public Set<MetricEvent> getMetrics() {
        HashSet<MetricEvent> set = new HashSet<MetricEvent>();
        EditorSettingsExternalizable es = EditorSettingsExternalizable.getInstance();
        EditorSettingsExternalizable esDefault = new EditorSettingsExternalizable(new EditorSettingsExternalizable.OsSpecificState());
        MetricEventUtilKt.addBoolIfDiffers(set, (Object)es, (Object)esDefault, s -> s.isVirtualSpace(), (String)"caretAfterLineEnd");
        MetricEventUtilKt.addBoolIfDiffers(set, (Object)es, (Object)esDefault, s -> s.isCaretInsideTabs(), (String)"caretInsideTabs");
        MetricEventUtilKt.addBoolIfDiffers(set, (Object)es, (Object)esDefault, s -> s.isAdditionalPageAtBottom(), (String)"virtualSpaceAtFileBottom");
        MetricEventUtilKt.addBoolIfDiffers(set, (Object)es, (Object)esDefault, s -> s.isUseSoftWraps(SoftWrapAppliancePlaces.MAIN_EDITOR), (String)"softWraps");
        MetricEventUtilKt.addBoolIfDiffers(set, (Object)es, (Object)esDefault, s -> s.isUseSoftWraps(SoftWrapAppliancePlaces.CONSOLE), (String)"softWraps.console");
        MetricEventUtilKt.addBoolIfDiffers(set, (Object)es, (Object)esDefault, s -> s.isUseSoftWraps(SoftWrapAppliancePlaces.PREVIEW), (String)"softWraps.preview");
        MetricEventUtilKt.addBoolIfDiffers(set, (Object)es, (Object)esDefault, s -> s.isUseCustomSoftWrapIndent(), (String)"softWraps.relativeIndent");
        MetricEventUtilKt.addBoolIfDiffers(set, (Object)es, (Object)esDefault, s -> s.isAllSoftWrapsShown(), (String)"softWraps.showAll");
        MetricEventUtilKt.addIfDiffers(set, (Object)es, (Object)esDefault, s -> s.getStripTrailingSpaces(), (String)"stripTrailingSpaces");
        MetricEventUtilKt.addBoolIfDiffers(set, (Object)es, (Object)esDefault, s -> s.isEnsureNewLineAtEOF(), (String)"ensureNewlineAtEOF");
        MetricEventUtilKt.addBoolIfDiffers(set, (Object)es, (Object)esDefault, s -> s.isShowQuickDocOnMouseOverElement(), (String)"quickDocOnMouseHover");
        MetricEventUtilKt.addBoolIfDiffers(set, (Object)es, (Object)esDefault, s -> s.isBlinkCaret(), (String)"blinkingCaret");
        MetricEventUtilKt.addIfDiffers(set, (Object)es, (Object)esDefault, s -> s.getBlinkPeriod(), (String)"blinkPeriod");
        MetricEventUtilKt.addBoolIfDiffers(set, (Object)es, (Object)esDefault, s -> s.isBlockCursor(), (String)"blockCaret");
        MetricEventUtilKt.addBoolIfDiffers(set, (Object)es, (Object)esDefault, s -> s.isRightMarginShown(), (String)"rightMargin");
        MetricEventUtilKt.addBoolIfDiffers(set, (Object)es, (Object)esDefault, s -> s.isLineNumbersShown(), (String)"lineNumbers");
        MetricEventUtilKt.addBoolIfDiffers(set, (Object)es, (Object)esDefault, s -> s.areGutterIconsShown(), (String)"gutterIcons");
        MetricEventUtilKt.addBoolIfDiffers(set, (Object)es, (Object)esDefault, s -> s.isFoldingOutlineShown(), (String)"foldingOutline");
        MetricEventUtilKt.addBoolIfDiffers(set, (Object)es, (Object)esDefault, s -> s.isWhitespacesShown() && s.isLeadingWhitespacesShown(), (String)"showLeadingWhitespace");
        MetricEventUtilKt.addBoolIfDiffers(set, (Object)es, (Object)esDefault, s -> s.isWhitespacesShown() && s.isInnerWhitespacesShown(), (String)"showInnerWhitespace");
        MetricEventUtilKt.addBoolIfDiffers(set, (Object)es, (Object)esDefault, s -> s.isWhitespacesShown() && s.isTrailingWhitespacesShown(), (String)"showTrailingWhitespace");
        MetricEventUtilKt.addBoolIfDiffers(set, (Object)es, (Object)esDefault, s -> s.isIndentGuidesShown(), (String)"indentGuides");
        MetricEventUtilKt.addBoolIfDiffers(set, (Object)es, (Object)esDefault, s -> s.isSmoothScrolling(), (String)"animatedScroll");
        MetricEventUtilKt.addBoolIfDiffers(set, (Object)es, (Object)esDefault, s -> s.isDndEnabled(), (String)"dragNDrop");
        MetricEventUtilKt.addBoolIfDiffers(set, (Object)es, (Object)esDefault, s -> s.isWheelFontChangeEnabled(), (String)"wheelZoom");
        MetricEventUtilKt.addBoolIfDiffers(set, (Object)es, (Object)esDefault, s -> s.isMouseClickSelectionHonorsCamelWords(), (String)"mouseCamel");
        MetricEventUtilKt.addBoolIfDiffers(set, (Object)es, (Object)esDefault, s -> s.isVariableInplaceRenameEnabled(), (String)"inplaceRename");
        MetricEventUtilKt.addBoolIfDiffers(set, (Object)es, (Object)esDefault, s -> s.isPreselectRename(), (String)"preselectOnRename");
        MetricEventUtilKt.addBoolIfDiffers(set, (Object)es, (Object)esDefault, s -> s.isShowInlineLocalDialog(), (String)"inlineDialog");
        MetricEventUtilKt.addBoolIfDiffers(set, (Object)es, (Object)esDefault, s -> s.isRefrainFromScrolling(), (String)"minimizeScrolling");
        MetricEventUtilKt.addBoolIfDiffers(set, (Object)es, (Object)esDefault, s -> s.isShowNotificationAfterReformat(), (String)"afterReformatNotification");
        MetricEventUtilKt.addBoolIfDiffers(set, (Object)es, (Object)esDefault, s -> s.isShowNotificationAfterOptimizeImports(), (String)"afterOptimizeNotification");
        MetricEventUtilKt.addBoolIfDiffers(set, (Object)es, (Object)esDefault, s -> s.isSmartHome(), (String)"smartHome");
        MetricEventUtilKt.addBoolIfDiffers(set, (Object)es, (Object)esDefault, s -> s.isCamelWords(), (String)"camelWords");
        MetricEventUtilKt.addBoolIfDiffers(set, (Object)es, (Object)esDefault, s -> s.isShowParameterNameHints(), (String)"editor.inlay.parameter.hints");
        MetricEventUtilKt.addBoolIfDiffers(set, (Object)es, (Object)esDefault, s -> s.isBreadcrumbsAbove(), (String)"breadcrumbsAbove");
        MetricEventUtilKt.addBoolIfDiffers(set, (Object)es, (Object)esDefault, s -> s.isBreadcrumbsShown(), (String)"all.breadcrumbs");
        MetricEventUtilKt.addBoolIfDiffers(set, (Object)es, (Object)esDefault, s -> s.isShowIntentionBulb(), (String)"intentionBulb");
        MetricEventUtilKt.addBoolIfDiffers(set, (Object)es, (Object)esDefault, s -> s.isDocCommentRenderingEnabled(), (String)"renderDoc");
        for (String language : es.getOptions().getLanguageBreadcrumbsMap().keySet()) {
            FeatureUsageData data2 = new FeatureUsageData().addLanguage(language);
            MetricEventUtilKt.addBoolIfDiffers(set, (Object)es, (Object)esDefault, s -> s.isBreadcrumbsShownFor(language), (String)"breadcrumbs", (FeatureUsageData)data2);
        }
        RichCopySettings rcs = RichCopySettings.getInstance();
        RichCopySettings rcsDefault = new RichCopySettings();
        MetricEventUtilKt.addBoolIfDiffers(set, (Object)rcs, (Object)rcsDefault, s -> s.isEnabled(), (String)"richCopy");
        CodeInsightSettings cis = CodeInsightSettings.getInstance();
        CodeInsightSettings cisDefault = new CodeInsightSettings();
        MetricEventUtilKt.addBoolIfDiffers(set, (Object)cis, (Object)cisDefault, s -> s.AUTO_POPUP_PARAMETER_INFO, (String)"parameterAutoPopup");
        MetricEventUtilKt.addBoolIfDiffers(set, (Object)cis, (Object)cisDefault, s -> s.AUTO_POPUP_JAVADOC_INFO, (String)"javadocAutoPopup");
        MetricEventUtilKt.addBoolIfDiffers(set, (Object)cis, (Object)cisDefault, s -> s.AUTO_POPUP_COMPLETION_LOOKUP, (String)"completionAutoPopup");
        MetricEventUtilKt.addIfDiffers(set, (Object)cis, (Object)cisDefault, s -> s.COMPLETION_CASE_SENSITIVE, (String)"completionCaseSensitivity");
        MetricEventUtilKt.addBoolIfDiffers(set, (Object)cis, (Object)cisDefault, s -> s.isSelectAutopopupSuggestionsByChars(), (String)"autoPopupCharComplete");
        MetricEventUtilKt.addBoolIfDiffers(set, (Object)cis, (Object)cisDefault, s -> s.AUTOCOMPLETE_ON_CODE_COMPLETION, (String)"autoCompleteBasic");
        MetricEventUtilKt.addBoolIfDiffers(set, (Object)cis, (Object)cisDefault, s -> s.AUTOCOMPLETE_ON_SMART_TYPE_COMPLETION, (String)"autoCompleteSmart");
        MetricEventUtilKt.addBoolIfDiffers(set, (Object)cis, (Object)cisDefault, s -> s.SHOW_FULL_SIGNATURES_IN_PARAMETER_INFO, (String)"parameterInfoFullSignature");
        MetricEventUtilKt.addIfDiffers(set, (Object)cis, (Object)cisDefault, s -> s.getBackspaceMode(), (String)"smartBackspace");
        MetricEventUtilKt.addBoolIfDiffers(set, (Object)cis, (Object)cisDefault, s -> s.SMART_INDENT_ON_ENTER, (String)"indentOnEnter");
        MetricEventUtilKt.addBoolIfDiffers(set, (Object)cis, (Object)cisDefault, s -> s.INSERT_BRACE_ON_ENTER, (String)"braceOnEnter");
        MetricEventUtilKt.addBoolIfDiffers(set, (Object)cis, (Object)cisDefault, s -> s.JAVADOC_STUB_ON_ENTER, (String)"javadocOnEnter");
        MetricEventUtilKt.addBoolIfDiffers(set, (Object)cis, (Object)cisDefault, s -> s.INSERT_SCRIPTLET_END_ON_ENTER, (String)"scriptletEndOnEnter");
        MetricEventUtilKt.addBoolIfDiffers(set, (Object)cis, (Object)cisDefault, s -> s.SMART_END_ACTION, (String)"smartEnd");
        MetricEventUtilKt.addBoolIfDiffers(set, (Object)cis, (Object)cisDefault, s -> s.JAVADOC_GENERATE_CLOSING_TAG, (String)"autoCloseJavadocTags");
        MetricEventUtilKt.addBoolIfDiffers(set, (Object)cis, (Object)cisDefault, s -> s.SURROUND_SELECTION_ON_QUOTE_TYPED, (String)"surroundByQuoteOrBrace");
        MetricEventUtilKt.addBoolIfDiffers(set, (Object)cis, (Object)cisDefault, s -> s.AUTOINSERT_PAIR_BRACKET, (String)"pairBracketAutoInsert");
        MetricEventUtilKt.addBoolIfDiffers(set, (Object)cis, (Object)cisDefault, s -> s.AUTOINSERT_PAIR_QUOTE, (String)"pairQuoteAutoInsert");
        MetricEventUtilKt.addBoolIfDiffers(set, (Object)cis, (Object)cisDefault, s -> s.REFORMAT_BLOCK_ON_RBRACE, (String)"reformatOnRBrace");
        MetricEventUtilKt.addIfDiffers(set, (Object)cis, (Object)cisDefault, s -> s.REFORMAT_ON_PASTE, (String)"reformatOnPaste");
        MetricEventUtilKt.addIfDiffers(set, (Object)cis, (Object)cisDefault, s -> s.ADD_IMPORTS_ON_PASTE, (String)"importsOnPaste");
        MetricEventUtilKt.addBoolIfDiffers(set, (Object)cis, (Object)cisDefault, s -> s.HIGHLIGHT_BRACES, (String)"bracesHighlight");
        MetricEventUtilKt.addBoolIfDiffers(set, (Object)cis, (Object)cisDefault, s -> s.HIGHLIGHT_SCOPE, (String)"scopeHighlight");
        MetricEventUtilKt.addBoolIfDiffers(set, (Object)cis, (Object)cisDefault, s -> s.HIGHLIGHT_IDENTIFIER_UNDER_CARET, (String)"identifierUnderCaretHighlight");
        MetricEventUtilKt.addBoolIfDiffers(set, (Object)cis, (Object)cisDefault, s -> s.ADD_UNAMBIGIOUS_IMPORTS_ON_THE_FLY, (String)"autoAddImports");
        MetricEventUtilKt.addBoolIfDiffers(set, (Object)cis, (Object)cisDefault, s -> s.SHOW_PARAMETER_NAME_HINTS_ON_COMPLETION, (String)"completionHints");
        MetricEventUtilKt.addBoolIfDiffers(set, (Object)cis, (Object)cisDefault, s -> s.SHOW_EXTERNAL_ANNOTATIONS_INLINE, (String)"externalAnnotationsInline");
        MetricEventUtilKt.addBoolIfDiffers(set, (Object)cis, (Object)cisDefault, s -> s.SHOW_INFERRED_ANNOTATIONS_INLINE, (String)"inferredAnnotationsInline");
        MetricEventUtilKt.addBoolIfDiffers(set, (Object)cis, (Object)cisDefault, s -> s.TAB_EXITS_BRACKETS_AND_QUOTES, (String)"tabExitsBracketsAndQuotes");
        EditorSettingsStatisticsCollector.addTooltipActionsMetricIfDiffers(set);
        DaemonCodeAnalyzerSettings dcas = DaemonCodeAnalyzerSettings.getInstance();
        DaemonCodeAnalyzerSettings dcasDefault = new DaemonCodeAnalyzerSettings();
        MetricEventUtilKt.addBoolIfDiffers(set, (Object)dcas, (Object)dcasDefault, s -> s.isNextErrorActionGoesToErrorsFirst(), (String)"nextErrorActionGoesToErrorsFirst");
        MetricEventUtilKt.addIfDiffers(set, (Object)dcas, (Object)dcasDefault, s -> s.getAutoReparseDelay(), (String)"autoReparseDelay");
        MetricEventUtilKt.addIfDiffers(set, (Object)dcas, (Object)dcasDefault, s -> s.getErrorStripeMarkMinHeight(), (String)"errorStripeMarkMinHeight");
        MetricEventUtilKt.addBoolIfDiffers(set, (Object)dcas, (Object)dcasDefault, s -> s.isSuppressWarnings(), (String)"suppressWarnings");
        MetricEventUtilKt.addBoolIfDiffers(set, (Object)dcas, (Object)dcasDefault, s -> s.isImportHintEnabled(), (String)"importHintEnabled");
        MetricEventUtilKt.addBoolIfDiffers(set, (Object)dcas, (Object)dcasDefault, s -> s.SHOW_METHOD_SEPARATORS, (String)"showMethodSeparators");
        CaretStopOptionsTransposed defaultCaretStop = CaretStopOptionsTransposed.fromCaretStopOptions(new CaretStopOptions());
        CaretStopOptionsTransposed caretStop = CaretStopOptionsTransposed.fromCaretStopOptions(es.getCaretStopOptions());
        MetricEventUtilKt.addIfDiffers(set, (Object)caretStop.getLineBoundary(), (Object)defaultCaretStop.getLineBoundary(), s -> EditorSettingsStatisticsCollector.toCaretStopValue(s), (String)"caret.movement.line");
        MetricEventUtilKt.addIfDiffers(set, (Object)caretStop.getWordBoundary(), (Object)defaultCaretStop.getWordBoundary(), s -> EditorSettingsStatisticsCollector.toCaretStopValue(s), (String)"caret.movement.word");
        if (!FileColorManagerImpl._isEnabled()) {
            set.add(MetricEventFactoryKt.newBooleanMetric((String)"fileColorsEnabled", (boolean)false));
        }
        if (!FileColorManagerImpl._isEnabledForProjectView()) {
            set.add(MetricEventFactoryKt.newBooleanMetric((String)"fileColorsEnabledForProjectView", (boolean)false));
        }
        if (!FileColorManagerImpl._isEnabledForTabs()) {
            set.add(MetricEventFactoryKt.newBooleanMetric((String)"fileColorsEnabledForTabs", (boolean)false));
        }
        return set;
    }

    @NotNull
    private static String toCaretStopValue(@NotNull CaretStopBoundary boundary) {
        if (boundary.equals(CaretStopBoundary.NONE)) {
            return "NONE";
        }
        if (boundary.equals(CaretStopBoundary.CURRENT)) {
            return "CURRENT";
        }
        if (boundary.equals(CaretStopBoundary.NEIGHBOR)) {
            return "NEIGHBOR";
        }
        if (boundary.equals(CaretStopBoundary.START)) {
            return "START";
        }
        if (boundary.equals(CaretStopBoundary.END)) {
            return "END";
        }
        if (boundary.equals(CaretStopBoundary.BOTH)) {
            return "BOTH";
        }
        return "OTHER";
    }

    private static void addTooltipActionsMetricIfDiffers(@NotNull Set<MetricEvent> set) {
        boolean value2 = TooltipActionProvider.isShowActions();
        if (!value2) {
            set.add(MetricEventFactoryKt.newBooleanMetric((String)"show.actions.in.tooltip", (boolean)value2));
        }
    }

    public static class ProjectUsages
    extends ProjectUsagesCollector {
        @NotNull
        public String getGroupId() {
            return "editor.settings.project";
        }

        public int getVersion() {
            return 2;
        }

        @NotNull
        public Set<MetricEvent> getMetrics(@NotNull Project project) {
            HashSet<MetricEvent> set = new HashSet<MetricEvent>();
            CodeInsightWorkspaceSettings ciws = CodeInsightWorkspaceSettings.getInstance(project);
            CodeInsightWorkspaceSettings ciwsDefault = new CodeInsightWorkspaceSettings();
            MetricEventUtilKt.addBoolIfDiffers(set, (Object)((Object)ciws), (Object)((Object)ciwsDefault), s -> s.isOptimizeImportsOnTheFly(), (String)"autoOptimizeImports");
            return set;
        }
    }
}

