/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.rulerguide;

import com.intellij.internal.rulerguide.RulerGuidePainter;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.SimpleTimer;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Window;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public final class RulerGuideAction
extends ToggleAction
implements DumbAware {
    private static final int QUERY_DELAY = 40;
    private final SimpleTimer timer = SimpleTimer.newInstance((String)"ruler-guide-action");
    private final RulerGuidePainter painter = new RulerGuidePainter((Disposable)ApplicationManager.getApplication());
    private boolean state;

    public RulerGuideAction() {
        this.setEnabledInModalContext(true);
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        return this.state;
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        this.state = state;
        this.fireRepaintEvent();
    }

    private void fireRepaintEvent() {
        if (this.state) {
            UIUtil.invokeAndWaitIfNeeded(this::findMousePositionAndRepaint);
            this.timer.setUp(this::fireRepaintEvent, 40L);
        } else {
            this.painter.removePainter();
        }
    }

    private void findMousePositionAndRepaint() {
        PointerInfo info = MouseInfo.getPointerInfo();
        if (info != null) {
            Point eventPoint = new Point(info.getLocation());
            for (Window window : Window.getWindows()) {
                if (window.getMousePosition() == null) continue;
                SwingUtilities.convertPointFromScreen(eventPoint, window);
                Component eventSource = SwingUtilities.getDeepestComponentAt(window, eventPoint.x, eventPoint.y);
                this.painter.repaint(eventSource, SwingUtilities.convertPoint(window, eventPoint, eventSource));
                return;
            }
        }
        this.painter.removePainter();
    }
}

