/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.psiView;

import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.internal.psiView.ViewerNodeDescriptor;
import com.intellij.lang.ASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ViewerTreeStructure
extends AbstractTreeStructure {
    private boolean myShowWhiteSpaces = true;
    private boolean myShowTreeNodes = true;
    private final Project myProject;
    private PsiElement myRootPsiElement = null;
    private final Object myRootElement = new Object();

    public ViewerTreeStructure(Project project) {
        this.myProject = project;
    }

    public void setRootPsiElement(PsiElement rootPsiElement) {
        this.myRootPsiElement = rootPsiElement;
    }

    public PsiElement getRootPsiElement() {
        return this.myRootPsiElement;
    }

    @NotNull
    public Object getRootElement() {
        return this.myRootElement;
    }

    public Object @NotNull [] getChildElements(@NotNull Object element2) {
        if (this.myRootElement == element2) {
            if (this.myRootPsiElement == null) {
                return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
            }
            if (!(this.myRootPsiElement instanceof PsiFile)) {
                return new Object[]{this.myRootPsiElement};
            }
            List files2 = ((PsiFile)this.myRootPsiElement).getViewProvider().getAllFiles();
            return PsiUtilCore.toPsiFileArray((Collection)files2);
        }
        Object[][] children2 = new Object[][]{ArrayUtilRt.EMPTY_OBJECT_ARRAY};
        ApplicationManager.getApplication().runReadAction(() -> {
            Object[] result2;
            if (this.myShowTreeNodes) {
                ASTNode root;
                ArrayList<ASTNode> list2 = new ArrayList<ASTNode>();
                Object object = element2 instanceof PsiElement ? SourceTreeToPsiMap.psiElementToTree((PsiElement)element2) : (root = element2 instanceof ASTNode ? (ASTNode)element2 : null);
                if (element2 instanceof Inject) {
                    root = SourceTreeToPsiMap.psiElementToTree(((Inject)element2).getPsi());
                }
                if (root != null) {
                    for (ASTNode child2 = root.getFirstChildNode(); child2 != null; child2 = child2.getTreeNext()) {
                        if (!this.myShowWhiteSpaces && child2.getElementType() == TokenType.WHITE_SPACE) continue;
                        PsiElement childElement = child2.getPsi();
                        list2.add((ASTNode)(childElement == null ? child2 : childElement));
                    }
                    PsiElement psi = root.getPsi();
                    if (psi instanceof PsiLanguageInjectionHost) {
                        InjectedLanguageManager.getInstance((Project)this.myProject).enumerate(psi, (injectedPsi, places) -> list2.add((ASTNode)new Inject(psi, (PsiElement)injectedPsi)));
                    }
                }
                result2 = ArrayUtil.toObjectArray(list2);
            } else {
                PsiElement[] elementChildren = ((PsiElement)element2).getChildren();
                if (!this.myShowWhiteSpaces) {
                    ArrayList<PsiElement> childrenList = new ArrayList<PsiElement>(elementChildren.length);
                    for (PsiElement psiElement : elementChildren) {
                        if (!this.myShowWhiteSpaces && psiElement instanceof PsiWhiteSpace) continue;
                        childrenList.add(psiElement);
                    }
                    result2 = PsiUtilCore.toPsiElementArray(childrenList);
                } else {
                    result2 = elementChildren;
                }
            }
            children2[0] = result2;
        });
        return children2[0];
    }

    public Object getParentElement(@NotNull Object element2) {
        if (element2 == this.myRootElement) {
            return null;
        }
        if (element2 == this.myRootPsiElement) {
            return this.myRootElement;
        }
        if (element2 instanceof PsiFile && InjectedLanguageManager.getInstance((Project)((PsiFile)element2).getProject()).getInjectionHost((PsiElement)((PsiFile)element2)) != null) {
            return new Inject((PsiElement)InjectedLanguageManager.getInstance((Project)((PsiFile)element2).getProject()).getInjectionHost((PsiElement)((PsiFile)element2)), (PsiElement)element2);
        }
        return element2 instanceof Inject ? ((Inject)element2).getParent() : ((PsiElement)element2).getContext();
    }

    public void commit() {
    }

    public boolean hasSomethingToCommit() {
        return false;
    }

    @NotNull
    public NodeDescriptor createDescriptor(@NotNull Object element2, NodeDescriptor parentDescriptor) {
        if (element2 == this.myRootElement) {
            return new NodeDescriptor(this.myProject, null){

                public boolean update() {
                    return false;
                }

                public Object getElement() {
                    return ViewerTreeStructure.this.myRootElement;
                }
            };
        }
        return new ViewerNodeDescriptor(this.myProject, element2, parentDescriptor);
    }

    public boolean isShowWhiteSpaces() {
        return this.myShowWhiteSpaces;
    }

    public void setShowWhiteSpaces(boolean showWhiteSpaces) {
        this.myShowWhiteSpaces = showWhiteSpaces;
    }

    public boolean isShowTreeNodes() {
        return this.myShowTreeNodes;
    }

    public void setShowTreeNodes(boolean showTreeNodes) {
        this.myShowTreeNodes = showTreeNodes;
    }

    static class Inject {
        private final PsiElement myParent;
        private final PsiElement myPsi;

        Inject(PsiElement parent, PsiElement psi) {
            this.myParent = parent;
            this.myPsi = psi;
        }

        public PsiElement getParent() {
            return this.myParent;
        }

        public PsiElement getPsi() {
            return this.myPsi;
        }

        public String toString() {
            return "INJECTION " + this.myPsi.getLanguage();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Inject inject = (Inject)o;
            if (!this.myParent.equals(inject.myParent)) {
                return false;
            }
            return this.myPsi.equals(inject.myPsi);
        }

        public int hashCode() {
            int result2 = this.myParent.hashCode();
            result2 = 31 * result2 + this.myPsi.hashCode();
            return result2;
        }
    }
}

