/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.focus;

import com.intellij.internal.InternalActionsBundle;
import com.intellij.internal.focus.FocusTracesDialog;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.impl.FocusManagerImpl;
import com.intellij.openapi.wm.impl.FocusRequestInfo;
import java.awt.AWTEvent;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FocusTracesAction
extends AnAction
implements DumbAware {
    private static boolean myActive = false;
    private AWTEventListener myFocusTracker;

    public FocusTracesAction() {
        this.setEnabledInModalContext(true);
    }

    public static boolean isActive() {
        return myActive;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        IdeFocusManager manager = IdeFocusManager.getGlobalInstance();
        if (!(manager instanceof FocusManagerImpl)) {
            return;
        }
        final FocusManagerImpl focusManager = (FocusManagerImpl)manager;
        boolean bl = myActive = !myActive;
        if (myActive) {
            this.myFocusTracker = new AWTEventListener(){

                @Override
                public void eventDispatched(AWTEvent event) {
                    if (event instanceof FocusEvent && event.getID() == 1004) {
                        focusManager.recordFocusRequest(((FocusEvent)event).getComponent(), false);
                    }
                }
            };
            Toolkit.getDefaultToolkit().addAWTEventListener(this.myFocusTracker, 4L);
        }
        if (!myActive) {
            List<FocusRequestInfo> requests = focusManager.getRequests();
            new FocusTracesDialog(project, new ArrayList<FocusRequestInfo>(requests)).show();
            Toolkit.getDefaultToolkit().removeAWTEventListener(this.myFocusTracker);
            this.myFocusTracker = null;
            requests.clear();
        }
    }

    public void update(@NotNull AnActionEvent e) {
        Presentation presentation2 = e.getPresentation();
        if (myActive) {
            presentation2.setText(InternalActionsBundle.messagePointer("action.presentation.FocusTracesAction.text.stop.focus.tracing", new Object[0]));
        } else {
            presentation2.setText(InternalActionsBundle.messagePointer("action.presentation.FocusTracesAction.text.start.focus.tracing", new Object[0]));
        }
        presentation2.setEnabled(e.getData(CommonDataKeys.PROJECT) != null);
    }
}

