/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.ui.icons.ImageDescriptor;
import com.intellij.ui.icons.ImageType;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IconsLoadTime
extends DumbAwareAction {
    private static final Logger LOG = Logger.getInstance(IconsLoadTime.class);
    private static final int STATS_LIMIT = 10000;
    private static final int FIXED_SCOPE = 100;
    private static final List<Integer> statsSVG = new ArrayList<Integer>();
    private static final List<Integer> statsPNG = new ArrayList<Integer>();

    public void actionPerformed(@NotNull AnActionEvent e) {
        IconsLoadTime.log(false);
    }

    public static void log(boolean measureStartupLoad) {
        IconsLoadTime.log(measureStartupLoad, ImageType.IMG);
        IconsLoadTime.log(measureStartupLoad, ImageType.SVG);
    }

    private static void log(boolean measureStartupLoad, @NotNull ImageType type) {
        StatData data2 = IconsLoadTime.getStatData(measureStartupLoad, type);
        if (data2 != null) {
            LOG.info(data2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static StatData getStatData(boolean measureStartupLoad, @NotNull ImageType type) {
        List<Integer> stats = IconsLoadTime.getStats(type);
        if (stats.isEmpty()) {
            return null;
        }
        List<Integer> list2 = stats;
        synchronized (list2) {
            int size = stats.size();
            int sum = stats.stream().mapToInt(Integer::intValue).sum();
            int average = sum / size;
            int median = size % 2 == 0 ? stats.get(size / 2 - 1) + stats.get(size / 2) : stats.get(size / 2);
            return new StatData(type, measureStartupLoad, sum, average, median, size);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void measure(@NotNull ImageType type, int duration) {
        int size;
        List<Integer> stats = IconsLoadTime.getStats(type);
        if (stats.size() > 10000) {
            ImageDescriptor.setLoadTimeConsumer(null);
        }
        List<Integer> list2 = stats;
        synchronized (list2) {
            stats.add(duration);
            size = stats.size();
        }
        if (size == 100) {
            IconsLoadTime.log(false, type);
        }
    }

    @NotNull
    private static List<Integer> getStats(@NotNull ImageType type) {
        return type == ImageType.SVG ? statsSVG : statsPNG;
    }

    static {
        if (Boolean.getBoolean("idea.measure.icon.load.time")) {
            ImageDescriptor.setLoadTimeConsumer(IconsLoadTime::measure);
        }
    }

    public static class StatData {
        public final ImageType type;
        public final boolean startup;
        public final int count;
        public final float totalTime;
        public final float averageTime;
        public final float medianTime;

        private StatData(@NotNull ImageType type, boolean startup, int totalTime, int averageTime, int medianTime, int count) {
            this.type = type;
            this.startup = startup;
            this.count = count;
            this.totalTime = (float)totalTime / 1000000.0f;
            this.averageTime = (float)averageTime / 1000000.0f;
            this.medianTime = (float)medianTime / 1000000.0f;
        }

        public String toString() {
            return this.type + " load time: " + (this.startup ? "ide_startup=" : "total=") + String.format("%.02fms", Float.valueOf(this.totalTime)) + ", average=" + String.format("%.02fms", Float.valueOf(this.averageTime)) + ", median=" + String.format("%.02fms", Float.valueOf(this.medianTime)) + "; number of icons: " + this.count;
        }
    }
}

