/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indentation;

import com.intellij.lang.ASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.Stack;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IndentationParser
implements PsiParser {
    @NotNull
    private final IElementType myEolTokenType;
    @NotNull
    private final IElementType myIndentTokenType;
    @NotNull
    private final IElementType myBlockElementType;
    @NotNull
    private final IElementType myDocumentType;
    private final List<? extends IElementType> myContainerTypes;

    public IndentationParser(@NotNull IElementType documentType, @NotNull IElementType blockElementType, @NotNull IElementType eolTokenType, @NotNull IElementType indentTokenType, List<? extends IElementType> containerTypes) {
        this.myDocumentType = documentType;
        this.myBlockElementType = blockElementType;
        this.myEolTokenType = eolTokenType;
        this.myIndentTokenType = indentTokenType;
        this.myContainerTypes = containerTypes;
    }

    public IndentationParser(@NotNull IElementType documentType, @NotNull IElementType blockElementType, @NotNull IElementType eolTokenType, @NotNull IElementType indentTokenType) {
        this(documentType, blockElementType, eolTokenType, indentTokenType, null);
    }

    @NotNull
    public final ASTNode parse(IElementType root, PsiBuilder builder2) {
        int n;
        PsiBuilder.Marker fileMarker = builder2.mark();
        ArrayList<PsiBuilder.Marker> containerMarkers = new ArrayList<PsiBuilder.Marker>();
        if (this.myContainerTypes != null) {
            for (IElementType iElementType : this.myContainerTypes) {
                PsiBuilder.Marker containerMarker = builder2.mark();
                containerMarkers.add(containerMarker);
            }
        }
        PsiBuilder.Marker documentMarker = builder2.mark();
        while (builder2.getTokenType() == this.myEolTokenType) {
            this.advanceLexer(builder2);
        }
        boolean bl = false;
        boolean eolSeen = false;
        if (builder2.getTokenType() == this.myIndentTokenType) {
            n = builder2.getTokenText().length();
            this.advanceLexer(builder2);
        }
        Stack stack = new Stack();
        stack.push((Object)new BlockInfo(n, builder2.mark(), builder2.getTokenType()));
        PsiBuilder.Marker startLineMarker = null;
        while (!builder2.eof()) {
            int n2;
            IElementType type = builder2.getTokenType();
            if (type == this.myEolTokenType) {
                if (startLineMarker == null) {
                    startLineMarker = builder2.mark();
                }
                eolSeen = true;
                n2 = 0;
            } else if (type == this.myIndentTokenType) {
                n2 = builder2.getTokenText().length();
            } else {
                if (!eolSeen && !stack.isEmpty() && n2 > 0 && n2 < ((BlockInfo)stack.peek()).getIndent()) {
                    eolSeen = true;
                }
                if (this.isCustomTagDelimiter(type)) {
                    builder2.advanceLexer();
                    stack.push((Object)new BlockInfo(n2, builder2.mark(), type));
                }
                if (eolSeen) {
                    BlockInfo blockInfo;
                    if (startLineMarker != null) {
                        startLineMarker.rollbackTo();
                        startLineMarker = null;
                    }
                    while (!stack.isEmpty() && n2 < ((BlockInfo)stack.peek()).getIndent()) {
                        blockInfo = (BlockInfo)stack.pop();
                        this.closeBlock(builder2, blockInfo.getMarker(), blockInfo.getStartTokenType());
                    }
                    if (!stack.isEmpty() && n2 >= (blockInfo = (BlockInfo)stack.peek()).getIndent()) {
                        if (n2 == blockInfo.getIndent()) {
                            BlockInfo info = (BlockInfo)stack.pop();
                            this.closeBlock(builder2, info.getMarker(), info.getStartTokenType());
                        }
                        this.passEOLsAndIndents(builder2);
                        stack.push((Object)new BlockInfo(n2, builder2.mark(), type));
                    }
                    eolSeen = false;
                    n2 = 0;
                }
            }
            this.advanceLexer(builder2);
        }
        if (startLineMarker != null) {
            startLineMarker.drop();
        }
        while (!stack.isEmpty()) {
            BlockInfo blockInfo = (BlockInfo)stack.pop();
            this.closeBlock(builder2, blockInfo.getMarker(), blockInfo.getStartTokenType());
        }
        documentMarker.done(this.myDocumentType);
        if (this.myContainerTypes != null) {
            for (int i2 = containerMarkers.size() - 1; i2 >= 0; --i2) {
                PsiBuilder.Marker marker = (PsiBuilder.Marker)containerMarkers.get(i2);
                marker.done(this.myContainerTypes.get(i2));
            }
        }
        fileMarker.done(root);
        return builder2.getTreeBuilt();
    }

    protected boolean isCustomTagDelimiter(IElementType type) {
        return false;
    }

    protected void closeBlock(@NotNull PsiBuilder builder2, @NotNull PsiBuilder.Marker marker, @Nullable IElementType startTokenType) {
        marker.done(this.myBlockElementType);
    }

    protected void advanceLexer(@NotNull PsiBuilder builder2) {
        builder2.advanceLexer();
    }

    private void passEOLsAndIndents(@NotNull PsiBuilder builder2) {
        IElementType tokenType = builder2.getTokenType();
        while (tokenType == this.myEolTokenType || tokenType == this.myIndentTokenType) {
            builder2.advanceLexer();
            tokenType = builder2.getTokenType();
        }
    }

    private static final class BlockInfo {
        private final int myIndent;
        @NotNull
        private final PsiBuilder.Marker myMarker;
        @Nullable
        private final IElementType myStartTokenType;

        private BlockInfo(int indent, @NotNull PsiBuilder.Marker marker, @Nullable IElementType type) {
            this.myIndent = indent;
            this.myMarker = marker;
            this.myStartTokenType = type;
        }

        public int getIndent() {
            return this.myIndent;
        }

        @NotNull
        public PsiBuilder.Marker getMarker() {
            return this.myMarker;
        }

        @Nullable
        public IElementType getStartTokenType() {
            return this.myStartTokenType;
        }
    }
}

