/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.gotoByName;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.GotoClassPresentationUpdater;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.gotoByName.FilteringGotoByModel;
import com.intellij.ide.util.gotoByName.LanguageRef;
import com.intellij.lang.Language;
import com.intellij.navigation.ChooseByNameContributor;
import com.intellij.navigation.GotoClassContributor;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.ui.IdeUICustomization;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GotoClassModel2
extends FilteringGotoByModel<LanguageRef> {
    private String[] mySeparators;

    public GotoClassModel2(@NotNull Project project) {
        super(project, new ChooseByNameContributor[0]);
    }

    @Override
    protected List<ChooseByNameContributor> getContributorList() {
        return ChooseByNameContributor.CLASS_EP_NAME.getExtensionList();
    }

    @Override
    protected LanguageRef filterValueFor(NavigationItem item) {
        return LanguageRef.forNavigationitem(item);
    }

    @Override
    protected synchronized Collection<LanguageRef> getFilterItems() {
        Collection result2 = super.getFilterItems();
        if (result2 == null) {
            return null;
        }
        HashSet<LanguageRef> items = new HashSet<LanguageRef>(result2);
        items.add(LanguageRef.forLanguage(Language.ANY));
        return items;
    }

    @Nullable
    public String getPromptText() {
        return IdeBundle.message((String)"prompt.gotoclass.enter.class.name", (Object[])new Object[]{StringUtil.toLowerCase((String)GotoClassPresentationUpdater.getActionTitle())});
    }

    public String getCheckBoxName() {
        return IdeUICustomization.getInstance().projectMessage("checkbox.include.non.project.items", new Object[0]);
    }

    @NotNull
    public String getNotInMessage() {
        return IdeUICustomization.getInstance().projectMessage("label.no.matches.found.in.project", new Object[0]);
    }

    @NotNull
    public String getNotFoundMessage() {
        return IdeBundle.message((String)"label.no.matches.found", (Object[])new Object[0]);
    }

    public boolean loadInitialCheckBoxState() {
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)this.myProject);
        return Boolean.TRUE.toString().equals(propertiesComponent.getValue("GoToClass.toSaveIncludeLibraries")) && Boolean.TRUE.toString().equals(propertiesComponent.getValue("GoToClass.includeLibraries"));
    }

    public void saveInitialCheckBoxState(boolean state) {
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)this.myProject);
        if (Boolean.TRUE.toString().equals(propertiesComponent.getValue("GoToClass.toSaveIncludeLibraries"))) {
            propertiesComponent.setValue("GoToClass.includeLibraries", Boolean.toString(state));
        }
    }

    public String getFullName(@NotNull Object element2) {
        if (element2 instanceof PsiElement && !((PsiElement)element2).isValid()) {
            return null;
        }
        for (ChooseByNameContributor c : this.getContributorList()) {
            String result2;
            if (!(c instanceof GotoClassContributor) || (result2 = ((GotoClassContributor)c).getQualifiedName((NavigationItem)element2)) == null) continue;
            return result2;
        }
        return this.getElementName(element2);
    }

    public String @NotNull [] getSeparators() {
        if (this.mySeparators == null) {
            this.mySeparators = GotoClassModel2.getSeparatorsFromContributors(this.getContributors());
        }
        return this.mySeparators;
    }

    public static String[] getSeparatorsFromContributors(ChooseByNameContributor[] contributors) {
        HashSet<String> separators = new HashSet<String>();
        separators.add(".");
        for (ChooseByNameContributor c : contributors) {
            if (!(c instanceof GotoClassContributor)) continue;
            ContainerUtil.addIfNotNull(separators, (Object)((GotoClassContributor)c).getQualifiedNameSeparator());
        }
        return ArrayUtilRt.toStringArray(separators);
    }

    @Override
    public String getHelpId() {
        return "procedures.navigating.goto.class";
    }

    @Override
    @NotNull
    public String removeModelSpecificMarkup(@NotNull String pattern) {
        if (pattern.startsWith("@")) {
            return pattern.substring(1);
        }
        return pattern;
    }

    public boolean willOpenEditor() {
        return true;
    }

    @Override
    public boolean sameNamesForProjectAndLibraries() {
        return false;
    }
}

