/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.gotoByName;

import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.ElementsChooser;
import com.intellij.ide.util.gotoByName.ChooseByNameFilterConfiguration;
import com.intellij.ide.util.gotoByName.ChooseByNamePopup;
import com.intellij.ide.util.gotoByName.FilteringGotoByModel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Disposer;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ChooseByNameFilter<T> {
    private final ChooseByNamePopup myParentPopup;
    private final ActionToolbar myToolbar;
    private final ElementsChooser<T> myChooser;
    private final JPanel myChooserPanel;
    private JBPopup myPopup;
    private final Project myProject;

    public ChooseByNameFilter(@NotNull ChooseByNamePopup popup2, @NotNull FilteringGotoByModel<T> model, final @NotNull ChooseByNameFilterConfiguration<T> filterConfiguration, @NotNull Project project) {
        this.myParentPopup = popup2;
        DefaultActionGroup actionGroup = DefaultActionGroup.createFlatGroup(() -> "go.to.file.filter");
        FilterAction action2 = new FilterAction(){

            @Override
            protected boolean isActive() {
                return !filterConfiguration.getState().getFilteredOutFileTypeNames().isEmpty();
            }
        };
        actionGroup.add((AnAction)action2);
        this.myToolbar = ActionManager.getInstance().createActionToolbar("gotfile.filter", (ActionGroup)actionGroup, true);
        this.myToolbar.setLayoutPolicy(0);
        this.myToolbar.updateActionsImmediately();
        this.myToolbar.getComponent().setFocusable(false);
        this.myToolbar.getComponent().setBorder(null);
        this.myProject = project;
        this.myChooser = this.createChooser(model, filterConfiguration);
        this.myChooserPanel = this.createChooserPanel();
        popup2.setToolArea(this.myToolbar.getComponent());
    }

    private JPanel createChooserPanel() {
        JPanel panel2 = new JPanel();
        panel2.setLayout(new BoxLayout(panel2, 1));
        panel2.add(this.myChooser);
        JPanel buttons = new JPanel();
        JButton all = new JButton("All");
        all.addActionListener(__ -> this.myChooser.setAllElementsMarked(true));
        buttons.add(all);
        JButton none = new JButton("None");
        none.addActionListener(__ -> this.myChooser.setAllElementsMarked(false));
        buttons.add(none);
        JButton invert = new JButton("Invert");
        invert.addActionListener(__ -> this.myChooser.invertSelection());
        buttons.add(invert);
        panel2.add(buttons);
        return panel2;
    }

    @NotNull
    protected ElementsChooser<T> createChooser(@NotNull FilteringGotoByModel<T> model, @NotNull ChooseByNameFilterConfiguration<? super T> filterConfiguration) {
        ArrayList<T> elements2 = new ArrayList<T>(this.getAllFilterValues());
        ElementsChooser chooser = new ElementsChooser<T>(elements2, true){

            @Override
            protected String getItemText(@NotNull T value2) {
                return ChooseByNameFilter.this.textForFilterValue(value2);
            }

            @Override
            protected Icon getItemIcon(@NotNull T value2) {
                return ChooseByNameFilter.this.iconForFilterValue(value2);
            }
        };
        chooser.setFocusable(false);
        int count = chooser.getElementCount();
        for (int i2 = 0; i2 < count; ++i2) {
            Object type = chooser.getElementAt(i2);
            if (DumbService.getInstance((Project)this.myProject).isDumb() || filterConfiguration.isFileTypeVisible(type)) continue;
            chooser.setElementMarked(type, false);
        }
        this.updateModel(model, chooser, true);
        chooser.addElementsMarkListener((element2, isMarked) -> {
            filterConfiguration.setVisible(element2, isMarked);
            this.updateModel(model, chooser, false);
        });
        return chooser;
    }

    protected abstract String textForFilterValue(@NotNull T var1);

    @Nullable
    protected abstract Icon iconForFilterValue(@NotNull T var1);

    @NotNull
    protected abstract Collection<T> getAllFilterValues();

    protected void updateModel(@NotNull FilteringGotoByModel<T> gotoFileModel, @NotNull ElementsChooser<T> chooser, boolean initial) {
        List<T> markedElements = chooser.getMarkedElements();
        gotoFileModel.setFilterItems(markedElements);
        this.myParentPopup.rebuildList(initial);
    }

    private void createPopup() {
        if (this.myPopup != null) {
            return;
        }
        this.myPopup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)this.myChooserPanel, this.myChooser).setModalContext(false).setFocusable(false).setResizable(true).setCancelOnClickOutside(false).setMinSize(new Dimension(200, 200)).setDimensionServiceKey(this.myProject, "GotoFile_FileTypePopup", false).createPopup();
        this.myPopup.addListener(new JBPopupListener(){

            public void onClosed(@NotNull LightweightWindowEvent event) {
                ChooseByNameFilter.this.myPopup = null;
            }
        });
        this.myPopup.showUnderneathOf((Component)this.myToolbar.getComponent());
    }

    public void close() {
        if (this.myPopup != null) {
            Disposer.dispose((Disposable)this.myPopup);
        }
    }

    private class FilterAction
    extends ToggleAction
    implements DumbAware {
        FilterAction() {
            super(IdeBundle.messagePointer((String)"action.ToggleAction.text.filter", (Object[])new Object[0]), IdeBundle.messagePointer((String)"action.ToggleAction.text.filter.files.by.type", (Object[])new Object[0]), AllIcons.General.Filter);
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            return ChooseByNameFilter.this.myPopup != null;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (state) {
                ChooseByNameFilter.this.createPopup();
            } else {
                ChooseByNameFilter.this.close();
            }
        }

        public void update(@NotNull AnActionEvent e) {
            Icon icon2 = this.getTemplatePresentation().getIcon();
            e.getPresentation().setIcon(this.isActive() ? ExecutionUtil.getLiveIndicator((Icon)icon2) : icon2);
        }

        protected boolean isActive() {
            return false;
        }
    }
}

