/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.ide.GeneralSettings;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.TipsOfTheDayUsagesCollector;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.TipAndTrickBean;
import com.intellij.ide.util.TipDialog;
import com.intellij.ide.util.TipUIUtil;
import com.intellij.ide.util.TipsOrderUtil;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TipPanel
extends JPanel
implements DialogWrapper.DoNotAskOption {
    private static final JBColor DIVIDER_COLOR = new JBColor(0xD9D9D9, 0x515151);
    private static final int DEFAULT_WIDTH = 400;
    private static final int DEFAULT_HEIGHT = 200;
    private static final String LAST_SEEN_TIP_ID = "lastSeenTip";
    private static final String SEEN_TIPS = "seenTips";
    private final TipUIUtil.Browser myBrowser;
    private final JLabel myPoweredByLabel;
    final AbstractAction myPreviousTipAction;
    final AbstractAction myNextTipAction;
    @NotNull
    private String myAlgorithm = "unknown";
    @Nullable
    private String myAlgorithmVersion = null;
    private List<TipAndTrickBean> myTips = Collections.emptyList();
    private final List<String> mySeenIds = new ArrayList<String>();
    private TipAndTrickBean myCurrentTip = null;

    public TipPanel() {
        this.setLayout(new BorderLayout());
        if (SystemInfo.isWin10OrNewer && !StartupUiUtil.isUnderDarcula()) {
            this.setBorder(JBUI.Borders.customLine((Color)Gray.xD0, (int)1, (int)0, (int)0, (int)0));
        }
        this.myBrowser = TipUIUtil.createBrowser();
        this.myBrowser.getComponent().setBorder((Border)JBUI.Borders.empty((int)8, (int)12));
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)this.myBrowser.getComponent(), (boolean)true);
        scrollPane.setBorder(JBUI.Borders.customLine((Color)DIVIDER_COLOR, (int)0, (int)0, (int)1, (int)0));
        this.add((Component)scrollPane, "Center");
        this.myPoweredByLabel = new JBLabel();
        this.myPoweredByLabel.setBorder((Border)JBUI.Borders.empty((int)0, (int)10));
        this.myPoweredByLabel.setForeground(SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES.getFgColor());
        this.add((Component)this.myPoweredByLabel, "South");
        this.myPreviousTipAction = new PreviousTipAction();
        this.myNextTipAction = new NextTipAction();
        this.mySeenIds.addAll(StringUtil.split((String)PropertiesComponent.getInstance().getValue(SEEN_TIPS, ""), (String)","));
        Collections.shuffle(this.mySeenIds);
        this.setTips(TipAndTrickBean.EP_NAME.getExtensionList());
    }

    void setTips(@NotNull List<? extends TipAndTrickBean> list2) {
        TipAndTrickBean lastSeenTip;
        TipsOrderUtil.RecommendationDescription recommendation = TipsOrderUtil.sort(list2);
        this.myTips = new ArrayList<TipAndTrickBean>(recommendation.getTips());
        this.myAlgorithm = recommendation.getAlgorithm();
        this.myAlgorithmVersion = recommendation.getVersion();
        for (String id2 : this.mySeenIds) {
            TipAndTrickBean tip = TipAndTrickBean.findByFileName(id2);
            if (tip == null || !this.myTips.remove((Object)tip)) continue;
            this.myTips.add(tip);
        }
        if (TipDialog.wereTipsShownToday() && (lastSeenTip = TipAndTrickBean.findByFileName(PropertiesComponent.getInstance().getValue(LAST_SEEN_TIP_ID))) != null && this.myTips.remove((Object)lastSeenTip)) {
            this.myTips.add(0, lastSeenTip);
        }
        this.showNext(true);
    }

    @Override
    public Dimension getPreferredSize() {
        return new JBDimension(400, 200);
    }

    private void showNext(boolean forward) {
        int index;
        if (this.myTips.size() == 0) {
            this.myBrowser.setText(IdeBundle.message((String)"error.tips.not.found", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()}));
            return;
        }
        int n = index = this.myCurrentTip != null ? this.myTips.indexOf((Object)this.myCurrentTip) : -1;
        if (forward) {
            if (index < this.myTips.size() - 1) {
                this.setTip(this.myTips.get(index + 1));
            }
        } else if (index > 0) {
            this.setTip(this.myTips.get(index - 1));
        }
    }

    private void setTip(@NotNull TipAndTrickBean tip) {
        this.myCurrentTip = tip;
        PropertiesComponent.getInstance().setValue(LAST_SEEN_TIP_ID, this.myCurrentTip.fileName);
        TipUIUtil.openTipInBrowser(this.myCurrentTip, this.myBrowser);
        this.myPoweredByLabel.setText(TipUIUtil.getPoweredByText(this.myCurrentTip));
        this.myPoweredByLabel.setVisible(!StringUtil.isEmpty((String)this.myPoweredByLabel.getText()));
        TipsOfTheDayUsagesCollector.triggerTipShown(tip, this.myAlgorithm, this.myAlgorithmVersion);
        if (!this.mySeenIds.contains(this.myCurrentTip.fileName)) {
            this.mySeenIds.add(this.myCurrentTip.fileName);
            if (this.mySeenIds.size() >= this.myTips.size()) {
                this.mySeenIds.clear();
            }
            PropertiesComponent.getInstance().setValue(SEEN_TIPS, StringUtil.join(this.mySeenIds, (String)","));
        }
        this.myPreviousTipAction.setEnabled(this.myTips.indexOf((Object)this.myCurrentTip) > 0);
        this.myNextTipAction.setEnabled(this.myTips.indexOf((Object)this.myCurrentTip) < this.myTips.size() - 1);
    }

    public boolean canBeHidden() {
        return true;
    }

    public boolean shouldSaveOptionsOnCancel() {
        return true;
    }

    public boolean isToBeShown() {
        return GeneralSettings.getInstance().isShowTipsOnStartup();
    }

    public void setToBeShown(boolean toBeShown, int exitCode) {
        GeneralSettings.getInstance().setShowTipsOnStartup(toBeShown);
    }

    @NotNull
    public String getDoNotShowMessage() {
        return IdeBundle.message((String)"checkbox.show.tips.on.startup", (Object[])new Object[0]);
    }

    private class NextTipAction
    extends AbstractAction {
        NextTipAction() {
            super(IdeBundle.message((String)"action.next.tip", (Object[])new Object[0]));
            this.putValue("DefaultAction", Boolean.TRUE);
            this.putValue("FocusedAction", Boolean.TRUE);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TipsOfTheDayUsagesCollector.NEXT_TIP.log();
            TipPanel.this.showNext(true);
        }
    }

    private class PreviousTipAction
    extends AbstractAction {
        PreviousTipAction() {
            super(IdeBundle.message((String)"action.previous.tip", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TipsOfTheDayUsagesCollector.PREVIOUS_TIP.log();
            TipPanel.this.showNext(false);
        }
    }
}

