/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.ide.util.MultiStateElementsChooser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ElementsChooser<T>
extends MultiStateElementsChooser<T, Boolean> {
    private static final BooleanMarkStateDescriptor MARK_STATE_DESCRIPTOR = new BooleanMarkStateDescriptor();

    public ElementsChooser(boolean elementsCanBeMarked) {
        super(elementsCanBeMarked, ElementsChooser.getMarkStateDescriptor());
    }

    public ElementsChooser(List<T> elements2, boolean marked) {
        super(elements2, marked, ElementsChooser.getMarkStateDescriptor());
    }

    public void addElementsMarkListener(ElementsMarkListener<T> listener2) {
        this.addElementsMarkListener(new ElementsMarkStateListenerAdapter<T>(listener2));
    }

    public void removeElementsMarkListener(ElementsMarkListener<T> listener2) {
        this.removeElementsMarkListener(new ElementsMarkStateListenerAdapter<T>(listener2));
    }

    @Override
    public void addElement(T element2, boolean isMarked) {
        this.addElement(element2, ElementsChooser.getMarkState(isMarked));
    }

    public boolean isElementMarked(T element2) {
        return (Boolean)this.getElementMarkState(element2);
    }

    public void setElementMarked(T element2, boolean marked) {
        this.setElementMarkState(element2, ElementsChooser.getMarkState(marked));
    }

    @Override
    public void addElement(T element2, boolean isMarked, MultiStateElementsChooser.ElementProperties elementProperties) {
        this.addElement(element2, ElementsChooser.getMarkState(isMarked), elementProperties);
    }

    @Override
    public void setElements(List<T> elements2, boolean marked) {
        this.setElements(elements2, ElementsChooser.getMarkState(marked));
    }

    public void markElements(Collection<T> elements2) {
        this.markElements(elements2, Boolean.TRUE);
    }

    @NotNull
    public List<T> getMarkedElements() {
        return this.getElements(true);
    }

    @NotNull
    public List<T> getElements(boolean isMarked) {
        Map elementMarkStates = this.getElementMarkStates();
        ArrayList elements2 = new ArrayList();
        for (Map.Entry entry : elementMarkStates.entrySet()) {
            if ((Boolean)entry.getValue() != isMarked) continue;
            elements2.add(entry.getKey());
        }
        return elements2;
    }

    public boolean hasUnmarkedElements() {
        Map elementMarkStates = this.getElementMarkStates();
        for (Map.Entry entry : elementMarkStates.entrySet()) {
            if (((Boolean)entry.getValue()).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public void invertSelection() {
        int count = this.getElementCount();
        for (int i2 = 0; i2 < count; ++i2) {
            Object type;
            this.setElementMarked(type, !this.isElementMarked(type = this.getElementAt(i2)));
        }
    }

    @Override
    public void setAllElementsMarked(boolean marked) {
        this.setAllElementsMarked(ElementsChooser.getMarkState(marked));
    }

    private static Boolean getMarkState(boolean marked) {
        return marked;
    }

    private static <T> MultiStateElementsChooser.MarkStateDescriptor<T, Boolean> getMarkStateDescriptor() {
        return MARK_STATE_DESCRIPTOR;
    }

    private static class ElementsMarkStateListenerAdapter<T>
    implements MultiStateElementsChooser.ElementsMarkStateListener<T, Boolean> {
        private final ElementsMarkListener<T> myListener;

        ElementsMarkStateListenerAdapter(ElementsMarkListener<T> listener2) {
            this.myListener = listener2;
        }

        @Override
        public void elementMarkChanged(T element2, Boolean markState) {
            this.myListener.elementMarkChanged(element2, markState);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ElementsMarkStateListenerAdapter that = (ElementsMarkStateListenerAdapter)o;
            return this.myListener.equals(that.myListener);
        }

        public int hashCode() {
            return this.myListener.hashCode();
        }
    }

    private static class BooleanMarkStateDescriptor<T>
    implements MultiStateElementsChooser.MarkStateDescriptor<T, Boolean> {
        private BooleanMarkStateDescriptor() {
        }

        @Override
        @NotNull
        public Boolean getDefaultState(@NotNull T element2) {
            return Boolean.FALSE;
        }

        @Override
        @NotNull
        public Boolean getNextState(@NotNull T element2, @NotNull Boolean state) {
            return state == false;
        }

        @Override
        @Nullable
        public Boolean getNextState(@NotNull Map<T, Boolean> elementsWithStates) {
            Boolean state;
            boolean currentlyMarked = true;
            Iterator<Boolean> iterator2 = elementsWithStates.values().iterator();
            while (iterator2.hasNext() && (currentlyMarked = (state = iterator2.next()).booleanValue())) {
            }
            return !currentlyMarked;
        }

        @Override
        public boolean isMarked(@NotNull Boolean state) {
            return state;
        }

        @Override
        @Nullable
        public Boolean getMarkState(@Nullable Object value2) {
            return value2 instanceof Boolean ? (Boolean)value2 : null;
        }

        @Override
        @Nullable
        public TableCellRenderer getMarkRenderer() {
            return null;
        }
    }

    public static interface ElementsMarkListener<T> {
        public void elementMarkChanged(T var1, boolean var2);
    }
}

