/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.search;

import com.intellij.ide.ui.search.IndexedCharsInterner;
import com.intellij.ide.ui.search.PorterStemmerUtil;
import com.intellij.ide.ui.search.SearchableOptionProcessor;
import com.intellij.ide.ui.search.SearchableOptionsRegistrar;
import com.intellij.ide.ui.search.SearchableOptionsRegistrarImpl;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ResourceUtil;
import com.intellij.util.text.ByteArrayCharSequence;
import com.intellij.util.text.CharSequenceHashingStrategy;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.io.InputStream;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0002\u0010\u0016\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J>\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00042\b\u0010\u0015\u001a\u0004\u0018\u00010\u00042\b\u0010\u0016\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0017\u001a\u00020\u00042\b\u0010\u0018\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J2\u0010\u001b\u001a \u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u001d\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00070\u001c2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u0007J&\u0010 \u001a \u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u001d\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00070!H\u0002J6\u0010\"\u001a\u00020\u00132\u0006\u0010#\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\u00042\b\u0010%\u001a\u0004\u0018\u00010\u00042\b\u0010\u0016\u001a\u0004\u0018\u00010\u00042\b\u0010\u0015\u001a\u0004\u0018\u00010\u0004H\u0002R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006&"}, d2={"Lcom/intellij/ide/ui/search/MySearchableOptionProcessor;", "Lcom/intellij/ide/ui/search/SearchableOptionProcessor;", "stopWords", "", "", "(Ljava/util/Set;)V", "cache", "", "identifierTable", "Lcom/intellij/ide/ui/search/IndexedCharsInterner;", "getIdentifierTable", "()Lcom/intellij/ide/ui/search/IndexedCharsInterner;", "storage", "Lgnu/trove/THashMap;", "", "", "getStorage", "()Lgnu/trove/THashMap;", "addOptions", "", "text", "path", "hit", "configurableId", "configurableDisplayName", "applyStemming", "", "computeHighlightOptionToSynonym", "", "Lkotlin/Pair;", "searchableOptions", "Ljava/net/URL;", "loadSynonyms", "", "putOptionWithHelpId", "option", "id", "groupName", "intellij.platform.ide.impl"})
public final class MySearchableOptionProcessor
extends SearchableOptionProcessor {
    private final Set<String> cache;
    @NotNull
    private final THashMap<CharSequence, long[]> storage;
    @NotNull
    private final IndexedCharsInterner identifierTable;
    private final Set<String> stopWords;

    @NotNull
    public final THashMap<CharSequence, long[]> getStorage() {
        return this.storage;
    }

    @NotNull
    public final IndexedCharsInterner getIdentifierTable() {
        return this.identifierTable;
    }

    public void addOptions(@NotNull String text, @Nullable String path, @Nullable String hit, @NotNull String configurableId, @Nullable String configurableDisplayName, boolean applyStemming) {
        this.cache.clear();
        if (applyStemming) {
            SearchableOptionsRegistrarImpl.collectProcessedWords(text, this.cache, this.stopWords);
        } else {
            SearchableOptionsRegistrarImpl.collectProcessedWordsWithoutStemming(text, this.cache, this.stopWords);
        }
        for (String word : this.cache) {
            this.putOptionWithHelpId(word, configurableId, configurableDisplayName, hit, path);
        }
    }

    @NotNull
    public final Map<Pair<String, String>, Set<String>> computeHighlightOptionToSynonym(@NotNull Set<URL> searchableOptions) {
        for (URL url : searchableOptions) {
            Element root = JDOMUtil.load((URL)url);
            for (Element configurable2 : root.getChildren("configurable")) {
                if (configurable2.getAttributeValue("id") == null) {
                    continue;
                }
                String groupName = configurable2.getAttributeValue("configurable_name");
                for (Element optionElement : configurable2.getChildren("option")) {
                    String id2;
                    String option2;
                    if (optionElement.getAttributeValue("name") == null) {
                        continue;
                    }
                    String path = optionElement.getAttributeValue("path");
                    String hit = optionElement.getAttributeValue("hit");
                    this.putOptionWithHelpId(option2, id2, groupName, hit, path);
                }
            }
        }
        return this.loadSynonyms();
    }

    /*
     * WARNING - void declaration
     */
    private final Map<Pair<String, String>, Set<String>> loadSynonyms() {
        THashMap result2 = new THashMap();
        Element root = JDOMUtil.load((InputStream)ResourceUtil.getResourceAsStream(SearchableOptionsRegistrar.class, (String)"/search/", (String)"synonyms.xml"));
        HashSet cache = new HashSet();
        for (Element configurable2 : root.getChildren("configurable")) {
            String id2;
            if (configurable2.getAttributeValue("id") == null) {
                continue;
            }
            String groupName = configurable2.getAttributeValue("configurable_name");
            List synonyms = configurable2.getChildren("synonym");
            for (Element synonymElement : synonyms) {
                String synonym;
                if (synonymElement.getTextNormalize() == null) {
                    continue;
                }
                cache.clear();
                SearchableOptionsRegistrarImpl.collectProcessedWords(synonym, cache, this.stopWords);
                for (String word : cache) {
                    this.putOptionWithHelpId(word, id2, groupName, synonym, null);
                }
            }
            for (Element optionElement : configurable2.getChildren("option")) {
                String option2 = optionElement.getAttributeValue("name");
                List list2 = optionElement.getChildren("synonym");
                for (Element synonymElement : list2) {
                    Object object;
                    void $this$getOrPut$iv;
                    Object word2;
                    String synonym;
                    if (synonymElement.getTextNormalize() == null) {
                        continue;
                    }
                    cache.clear();
                    SearchableOptionsRegistrarImpl.collectProcessedWords(synonym, cache, this.stopWords);
                    for (Object word2 : cache) {
                        this.putOptionWithHelpId((String)word2, id2, groupName, synonym, null);
                    }
                    word2 = (Map)result2;
                    Pair key$iv = new Pair((Object)option2, (Object)id2);
                    boolean $i$f$getOrPut = false;
                    Object value$iv = $this$getOrPut$iv.get(key$iv);
                    if (value$iv == null) {
                        boolean bl = false;
                        Set answer$iv = (Set)new THashSet();
                        $this$getOrPut$iv.put(key$iv, answer$iv);
                        object = answer$iv;
                    } else {
                        object = value$iv;
                    }
                    ((Set)object).add(synonym);
                }
            }
        }
        return (Map)result2;
    }

    private final void putOptionWithHelpId(String option2, String id2, String groupName, String hit, String path) {
        if (this.stopWords.contains(option2)) {
            return;
        }
        String stopWord = PorterStemmerUtil.stem(option2);
        if (stopWord == null || this.stopWords.contains(stopWord)) {
            return;
        }
        long[] configs = (long[])this.storage.get((Object)option2);
        long packed = SearchableOptionsRegistrarImpl.pack(id2, hit, path, groupName, this.identifierTable);
        if (configs == null) {
            configs = new long[]{packed};
        } else if (ArraysKt.indexOf((long[])configs, (long)packed) == -1) {
            configs = ArrayUtil.append((long[])configs, (long)packed);
        }
        this.storage.put((Object)ByteArrayCharSequence.convertToBytesIfPossible((CharSequence)option2), (Object)configs);
    }

    public MySearchableOptionProcessor(@NotNull Set<String> stopWords) {
        this.stopWords = stopWords;
        this.cache = new HashSet();
        this.storage = new THashMap(20, 0.9f, (TObjectHashingStrategy)CharSequenceHashingStrategy.CASE_SENSITIVE);
        this.identifierTable = new IndexedCharsInterner();
    }
}

