/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.customization;

import com.intellij.ide.ui.customization.ActionUrl;
import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.ide.ui.customization.CustomisedActionGroup;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.impl.ui.Group;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.diff.Diff;
import com.intellij.util.diff.FilesTooBigForDiffException;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CustomizationUtil {
    private static final Logger LOG = Logger.getInstance(CustomizationUtil.class);

    private CustomizationUtil() {
    }

    public static ActionGroup correctActionGroup(ActionGroup group, CustomActionsSchema schema, String defaultGroupName, String rootGroupName, boolean force) {
        if (!force && !schema.isCorrectActionGroup(group, defaultGroupName)) {
            return group;
        }
        String text = group.getTemplatePresentation().getText();
        int mnemonic = group.getTemplatePresentation().getMnemonic();
        if (text != null) {
            for (int i2 = 0; i2 < text.length(); ++i2) {
                if (Character.toUpperCase(text.charAt(i2)) != mnemonic) continue;
                text = text.replaceFirst(String.valueOf(text.charAt(i2)), "_" + text.charAt(i2));
                break;
            }
        }
        return new CustomisedActionGroup(text, group, schema, defaultGroupName, rootGroupName);
    }

    static AnAction[] getReordableChildren(ActionGroup group, CustomActionsSchema schema, String defaultGroupName, String rootGroupName, AnActionEvent e) {
        String text = group.getTemplatePresentation().getText();
        ActionManager actionManager = ActionManager.getInstance();
        ArrayList<Object> reorderedChildren = new ArrayList<Object>();
        ContainerUtil.addAll(reorderedChildren, (Object[])group.getChildren(e));
        List<ActionUrl> actions = schema.getActions();
        for (ActionUrl actionUrl : actions) {
            AnAction anAction;
            AnAction componentAction;
            if (!actionUrl.getParentGroup().equals(text) && !actionUrl.getParentGroup().equals(defaultGroupName) && (!actionUrl.getParentGroup().equals(actionManager.getId((AnAction)group)) || !actionUrl.getRootGroup().equals(rootGroupName)) || (componentAction = actionUrl.getComponentAction()) == null) continue;
            if (actionUrl.getActionType() == 1) {
                if (componentAction == group) {
                    LOG.error("Attempt to add group to itself; group ID=" + actionManager.getId((AnAction)group));
                    continue;
                }
                if (reorderedChildren.size() > actionUrl.getAbsolutePosition()) {
                    reorderedChildren.add(actionUrl.getAbsolutePosition(), componentAction);
                    continue;
                }
                reorderedChildren.add(componentAction);
                continue;
            }
            if (actionUrl.getActionType() != -1 || reorderedChildren.size() <= actionUrl.getAbsolutePosition() || ((anAction = (AnAction)reorderedChildren.get(actionUrl.getAbsolutePosition())).getTemplatePresentation().getText() == null ? componentAction.getTemplatePresentation().getText() != null && componentAction.getTemplatePresentation().getText().length() > 0 : !anAction.getTemplatePresentation().getText().equals(componentAction.getTemplatePresentation().getText()))) continue;
            reorderedChildren.remove(actionUrl.getAbsolutePosition());
        }
        for (int i2 = 0; i2 < reorderedChildren.size(); ++i2) {
            if (!(reorderedChildren.get(i2) instanceof ActionGroup)) continue;
            ActionGroup groupToCorrect = (ActionGroup)reorderedChildren.get(i2);
            ActionGroup correctedAction = CustomizationUtil.correctActionGroup(groupToCorrect, schema, "", rootGroupName, false);
            reorderedChildren.set(i2, correctedAction);
        }
        return reorderedChildren.toArray(AnAction.EMPTY_ARRAY);
    }

    public static void optimizeSchema(JTree tree, CustomActionsSchema schema) {
        Group rootGroup = new Group("root", null, null);
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(rootGroup);
        root.removeAllChildren();
        schema.fillActionGroups(root);
        Tree defaultTree = new Tree((TreeModel)new DefaultTreeModel(root));
        ArrayList<ActionUrl> actions = new ArrayList<ActionUrl>();
        TreeUtil.traverseDepth((TreeNode)((TreeNode)tree.getModel().getRoot()), arg_0 -> CustomizationUtil.lambda$optimizeSchema$0((JTree)defaultTree, actions, schema, arg_0));
        schema.setActions(actions);
    }

    private static void computeDiff(ActionUrl[] defaultUserObjects, ActionUrl[] currentUserObjects, @NotNull List<? super ActionUrl> actions) {
        Diff.Change change = null;
        try {
            change = Diff.buildChanges((Object[])defaultUserObjects, (Object[])currentUserObjects);
        }
        catch (FilesTooBigForDiffException e) {
            LOG.info((Throwable)e);
        }
        while (change != null) {
            ActionUrl currentUserObject;
            int idx;
            int i2;
            for (i2 = 0; i2 < change.deleted; ++i2) {
                idx = change.line0 + i2;
                currentUserObject = defaultUserObjects[idx];
                currentUserObject.setActionType(-1);
                currentUserObject.setAbsolutePosition(idx);
                actions.add(currentUserObject);
            }
            for (i2 = 0; i2 < change.inserted; ++i2) {
                idx = change.line1 + i2;
                currentUserObject = currentUserObjects[idx];
                currentUserObject.setActionType(1);
                currentUserObject.setAbsolutePosition(idx);
                actions.add(currentUserObject);
            }
            change = change.link;
        }
    }

    public static TreePath getPathByUserObjects(JTree tree, TreePath treePath) {
        ArrayList<String> path = new ArrayList<String>();
        for (int i2 = 0; i2 < treePath.getPath().length; ++i2) {
            Object o = ((DefaultMutableTreeNode)treePath.getPath()[i2]).getUserObject();
            if (!(o instanceof Group)) continue;
            path.add(((Group)o).getName());
        }
        return CustomizationUtil.getTreePath(0, path, tree.getModel().getRoot());
    }

    public static ActionUrl getActionUrl(TreePath treePath, int actionType) {
        ActionUrl url = new ActionUrl();
        for (int i2 = 0; i2 < treePath.getPath().length - 1; ++i2) {
            Object o = ((DefaultMutableTreeNode)treePath.getPath()[i2]).getUserObject();
            if (!(o instanceof Group)) continue;
            url.getGroupPath().add(((Group)o).getName());
        }
        DefaultMutableTreeNode component2 = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        url.setComponent(component2.getUserObject());
        TreeNode parent = component2.getParent();
        url.setAbsolutePosition(parent != null ? parent.getIndex(component2) : 0);
        url.setActionType(actionType);
        return url;
    }

    public static TreePath getTreePath(JTree tree, ActionUrl url) {
        return CustomizationUtil.getTreePath(0, url.getGroupPath(), tree.getModel().getRoot());
    }

    @Nullable
    private static TreePath getTreePath(int positionInPath, List<String> path, Object root) {
        TreeNode child2;
        if (!(root instanceof DefaultMutableTreeNode)) {
            return null;
        }
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)root;
        Object userObject = treeNode.getUserObject();
        if (path.size() <= positionInPath) {
            return null;
        }
        String pathElement = path.get(positionInPath);
        if (pathElement == null) {
            return null;
        }
        if (!(userObject instanceof Group)) {
            return null;
        }
        if (!pathElement.equals(((Group)userObject).getName())) {
            return null;
        }
        TreePath currentPath = new TreePath(treeNode.getPath());
        if (positionInPath == path.size() - 1) {
            return currentPath;
        }
        for (int j = 0; j < treeNode.getChildCount() && (currentPath = CustomizationUtil.getTreePath(positionInPath + 1, path, child2 = treeNode.getChildAt(j))) == null; ++j) {
        }
        return currentPath;
    }

    private static ActionUrl[] getChildUserObjects(DefaultMutableTreeNode node, ActionUrl parent) {
        ArrayList<ActionUrl> result2 = new ArrayList<ActionUrl>();
        ArrayList<String> groupPath = new ArrayList<String>(parent.getGroupPath());
        for (int i2 = 0; i2 < node.getChildCount(); ++i2) {
            DefaultMutableTreeNode child2 = (DefaultMutableTreeNode)node.getChildAt(i2);
            ActionUrl url = new ActionUrl();
            url.setGroupPath(groupPath);
            Object userObject = child2.getUserObject();
            url.setComponent(userObject instanceof Pair ? ((Pair)userObject).first : userObject);
            result2.add(url);
        }
        return result2.toArray(new ActionUrl[0]);
    }

    @NotNull
    public static MouseListener installPopupHandler(JComponent component2, final @NotNull String groupId2, String place) {
        return PopupHandler.installPopupHandler((JComponent)component2, (ActionGroup)new ActionGroup(){

            public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
                ActionGroup group = (ActionGroup)CustomActionsSchema.getInstance().getCorrectedAction(groupId2);
                return group == null ? EMPTY_ARRAY : group.getChildren(e);
            }
        }, (String)place, (ActionManager)ActionManager.getInstance(), null);
    }

    private static /* synthetic */ boolean lambda$optimizeSchema$0(JTree defaultTree, List actions, CustomActionsSchema schema, Object node) {
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)node;
        Object userObject = treeNode.getUserObject();
        if (treeNode.isLeaf() && !(userObject instanceof Group)) {
            return true;
        }
        ActionUrl url = CustomizationUtil.getActionUrl(new TreePath(treeNode.getPath()), 0);
        String groupName = ((Group)userObject).getName();
        url.getGroupPath().add(groupName);
        TreePath treePath = CustomizationUtil.getTreePath(defaultTree, url);
        if (treePath != null) {
            DefaultMutableTreeNode visited = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            ActionUrl[] defaultUserObjects = CustomizationUtil.getChildUserObjects(visited, url);
            ActionUrl[] currentUserObjects = CustomizationUtil.getChildUserObjects(treeNode, url);
            CustomizationUtil.computeDiff(defaultUserObjects, currentUserObjects, actions);
        } else {
            url.getGroupPath().remove(url.getParentGroup());
            if (actions.contains(url)) {
                url.getGroupPath().add(groupName);
                actions.addAll(schema.getChildActions(url));
            }
        }
        return true;
    }
}

