/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.gson.Gson;
import com.intellij.icons.AllIcons;
import com.intellij.ide.plugins.cl.PluginClassLoader;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.IconPathPatcher;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColorHexUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.util.SVGLoader;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import javax.swing.Icon;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.IconUIResource;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UITheme {
    public static final String FILE_EXT_ENDING = ".theme.json";
    private static final Logger LOG = Logger.getInstance(UITheme.class);
    private String name;
    private boolean dark;
    private String author;
    private String id;
    private String editorScheme;
    private Map<String, Object> ui;
    private Map<String, Object> icons;
    private IconPathPatcher patcher;
    private Map<String, Object> background;
    private Map<String, Object> emptyFrameBackground;
    private Map<String, Object> colors;
    private ClassLoader providerClassLoader = this.getClass().getClassLoader();
    private String editorSchemeName;
    private SVGLoader.SvgElementColorPatcherProvider colorPatcher;
    @NonNls
    private static final Map<String, String> colorPalette = new HashMap<String, String>();

    private UITheme() {
    }

    public String getName() {
        return this.name;
    }

    public boolean isDark() {
        return this.dark;
    }

    public String getAuthor() {
        return this.author;
    }

    public URL getResource(String path) {
        File file2;
        if (this.isTempTheme() && (file2 = new File(path)).exists()) {
            try {
                return file2.toURI().toURL();
            }
            catch (MalformedURLException e) {
                LOG.warn((Throwable)e);
            }
        }
        return this.getProviderClassLoader().getResource(path);
    }

    public InputStream getResourceAsStream(String path) {
        URL url = this.getResource(path);
        try {
            return url != null ? url.openStream() : null;
        }
        catch (IOException e) {
            return null;
        }
    }

    private boolean isTempTheme() {
        return "Temp theme".equals(this.id);
    }

    @NotNull
    public static UITheme loadFromJson(@NotNull InputStream stream, @NotNull String themeId, @Nullable ClassLoader provider) throws IllegalStateException {
        return UITheme.loadFromJson(stream, themeId, provider, s -> s);
    }

    @NotNull
    public static UITheme loadFromJson(@NotNull InputStream stream, @NotNull String themeId, @Nullable ClassLoader provider, final @NotNull Function<? super String, String> iconsMapper) throws IllegalStateException {
        final UITheme theme = (UITheme)new Gson().fromJson((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8), UITheme.class);
        theme.id = themeId;
        if (provider != null) {
            theme.providerClassLoader = provider;
        }
        if (theme.icons != null && !theme.icons.isEmpty()) {
            theme.patcher = new IconPathPatcher(){

                @Nullable
                public String patchPath(@NotNull String path, ClassLoader classLoader) {
                    Object value2;
                    if (classLoader instanceof PluginClassLoader) {
                        Object pluginIconPath;
                        String pluginId = ((PluginClassLoader)((Object)classLoader)).getPluginId().getIdString();
                        Object icons = theme.icons.get(pluginId);
                        if (icons instanceof Map && (pluginIconPath = ((Map)icons).get(path)) instanceof String) {
                            return (String)iconsMapper.apply((String)pluginIconPath);
                        }
                    }
                    return (value2 = theme.icons.get(path)) instanceof String ? (String)iconsMapper.apply((String)value2) : null;
                }

                @Nullable
                public ClassLoader getContextClassLoader(@NotNull String path, ClassLoader originalClassLoader) {
                    return theme.providerClassLoader;
                }
            };
            Object palette = theme.icons.get("ColorPalette");
            if (palette instanceof Map) {
                Map colors = (Map)palette;
                final PaletteScopeManager paletteScopeManager = new PaletteScopeManager();
                for (Object o : colors.keySet()) {
                    String colorKey = o.toString();
                    PaletteScope scope = paletteScopeManager.getScope(colorKey);
                    if (scope == null) continue;
                    String key = UITheme.toColorString(colorKey, theme.isDark());
                    Object v = colors.get(colorKey);
                    if (!(v instanceof String)) continue;
                    String value2 = (String)v;
                    String alpha = null;
                    if (value2.length() == 9) {
                        alpha = value2.substring(7);
                        value2 = value2.substring(0, 7);
                    }
                    if (ColorUtil.fromHex((String)key, null) == null || ColorUtil.fromHex((String)value2, null) == null) continue;
                    scope.newPalette.put(key, value2);
                    int fillTransparency = -1;
                    if (alpha != null) {
                        try {
                            fillTransparency = Integer.parseInt(alpha, 16);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (fillTransparency == -1) continue;
                    scope.alphas.put(value2, fillTransparency);
                }
                theme.colorPatcher = new SVGLoader.SvgElementColorPatcherProvider(){

                    @Nullable
                    public SVGLoader.SvgElementColorPatcher forURL(@Nullable URL url) {
                        PaletteScope scope = paletteScopeManager.getScopeByURL(url);
                        if (scope == null) {
                            return null;
                        }
                        byte[] digest = scope.digest();
                        Map<String, String> newPalette = scope.newPalette;
                        Map<String, Integer> alphas = scope.alphas;
                        return this.newPatcher(digest, newPalette, alphas);
                    }

                    @Nullable
                    private SVGLoader.SvgElementColorPatcher newPatcher(final byte @Nullable [] digest, final @NotNull Map<String, String> newPalette, final @NotNull Map<String, Integer> alphas) {
                        if (newPalette.isEmpty()) {
                            return null;
                        }
                        return new SVGLoader.SvgElementColorPatcher(){

                            public byte[] digest() {
                                return digest;
                            }

                            public void patchColors(@NotNull Element svg) {
                                this.patchColorAttribute(svg, "fill");
                                this.patchColorAttribute(svg, "stroke");
                                NodeList nodes = svg.getChildNodes();
                                int length = nodes.getLength();
                                for (int i2 = 0; i2 < length; ++i2) {
                                    Node item = nodes.item(i2);
                                    if (!(item instanceof Element)) continue;
                                    this.patchColors((Element)item);
                                }
                            }

                            private void patchColorAttribute(@NotNull Element svg, String attrName) {
                                String newColor;
                                String color = svg.getAttribute(attrName);
                                if (color != null && (newColor = (String)newPalette.get(StringUtil.toLowerCase((String)color))) != null) {
                                    svg.setAttribute(attrName, newColor);
                                    if (alphas.get(newColor) != null) {
                                        svg.setAttribute(attrName + "-opacity", String.valueOf(Float.valueOf(((Integer)alphas.get(newColor)).intValue()).floatValue() / 255.0f));
                                    }
                                }
                            }
                        };
                    }
                };
            }
        }
        return theme;
    }

    private static String toColorString(String key, boolean darkTheme) {
        String color;
        if (darkTheme && colorPalette.get(key + ".Dark") != null) {
            key = key + ".Dark";
        }
        return (color = colorPalette.get(key)) != null ? StringUtil.toLowerCase((String)color) : StringUtil.toLowerCase((String)key);
    }

    public String getId() {
        return this.id;
    }

    @Nullable
    public String getEditorScheme() {
        return this.editorScheme;
    }

    public Map<String, Object> getBackground() {
        return this.background;
    }

    public Map<String, Object> getEmptyFrameBackground() {
        return this.emptyFrameBackground;
    }

    public void applyProperties(UIDefaults defaults) {
        if (this.ui == null) {
            return;
        }
        this.loadColorPalette(defaults);
        for (Map.Entry<String, Object> entry : this.ui.entrySet()) {
            UITheme.apply(this, entry.getKey(), entry.getValue(), defaults);
        }
    }

    private void loadColorPalette(UIDefaults defaults) {
        if (this.colors != null) {
            for (Map.Entry<String, Object> entry : this.colors.entrySet()) {
                Color color;
                Object value2 = entry.getValue();
                if (!(value2 instanceof String) || (color = UITheme.parseColor((String)value2)) == null) continue;
                defaults.put("ColorPalette." + entry.getKey(), color);
            }
        }
    }

    public IconPathPatcher getPatcher() {
        return this.patcher;
    }

    public SVGLoader.SvgElementColorPatcherProvider getColorPatcher() {
        return this.colorPatcher;
    }

    @NotNull
    public ClassLoader getProviderClassLoader() {
        return this.providerClassLoader;
    }

    private static void apply(UITheme theme, String key, Object value2, UIDefaults defaults) {
        if (value2 instanceof Map) {
            Map map2 = (Map)value2;
            for (Map.Entry o : map2.entrySet()) {
                UITheme.apply(theme, key + "." + (String)o.getKey(), o.getValue(), defaults);
            }
        } else {
            String valueStr = value2.toString();
            Object color = null;
            if (theme.colors != null && theme.colors.containsKey(valueStr) && (color = UITheme.parseColor(String.valueOf(theme.colors.get(valueStr)))) != null && !key.startsWith("*")) {
                defaults.put(key, color);
                return;
            }
            Object object = value2 = color == null ? UITheme.parseValue(key, valueStr) : color;
            if (key.startsWith("*.")) {
                String tail = key.substring(1);
                Object finalValue = value2;
                UITheme.addPattern(key, value2, defaults);
                ((UIDefaults)defaults.clone()).keySet().stream().filter(k -> k instanceof String && ((String)k).endsWith(tail)).forEach(k -> defaults.put(k, finalValue));
            } else {
                defaults.put(key, value2);
            }
        }
    }

    private static void addPattern(String key, Object value2, UIDefaults defaults) {
        HashMap o = defaults.get("*");
        if (!(o instanceof Map)) {
            o = new HashMap();
            defaults.put("*", o);
        }
        Map map2 = o;
        if (key != null && key.startsWith("*.")) {
            map2.put(key.substring(2), value2);
        }
    }

    public static Object parseValue(String key, @NotNull String value2, @NotNull ClassLoader cl) {
        if ("null".equals(value2)) {
            return null;
        }
        if ("true".equals(value2)) {
            return Boolean.TRUE;
        }
        if ("false".equals(value2)) {
            return Boolean.FALSE;
        }
        if (key.endsWith("Insets") || key.endsWith("padding")) {
            return UITheme.parseInsets(value2);
        }
        if (key.endsWith("Border") || key.endsWith("border")) {
            try {
                List ints = StringUtil.split((String)value2, (String)",");
                if (ints.size() == 4) {
                    return new BorderUIResource.EmptyBorderUIResource(UITheme.parseInsets(value2));
                }
                if (ints.size() == 5) {
                    return JBUI.asUIResource((Border)JBUI.Borders.customLine((Color)ColorUtil.fromHex((String)((String)ints.get(4))), (int)Integer.parseInt((String)ints.get(0)), (int)Integer.parseInt((String)ints.get(1)), (int)Integer.parseInt((String)ints.get(2)), (int)Integer.parseInt((String)ints.get(3))));
                }
                Color color = ColorHexUtil.fromHexOrNull((String)value2);
                if (color != null) {
                    return JBUI.asUIResource((Border)JBUI.Borders.customLine((Color)color, (int)1));
                }
                return Class.forName(value2, true, cl).newInstance();
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
            }
        } else {
            Icon icon2;
            if (key.endsWith("Size")) {
                return UITheme.parseSize(value2);
            }
            if (key.endsWith("Width") || key.endsWith("Height")) {
                return UITheme.getInteger(value2, key);
            }
            if (key.endsWith("grayFilter")) {
                return UITheme.parseGrayFilter(value2);
            }
            Icon icon3 = icon2 = value2.startsWith("AllIcons.") ? IconLoader.getReflectiveIcon((String)value2, (ClassLoader)AllIcons.class.getClassLoader()) : null;
            if (icon2 != null) {
                return new IconUIResource(icon2);
            }
            Color color = UITheme.parseColor(value2);
            if (color != null) {
                return new ColorUIResource(color);
            }
            Integer intVal = UITheme.getInteger(value2, null);
            if (intVal != null) {
                return intVal;
            }
        }
        return value2;
    }

    public static Object parseValue(String key, @NotNull String value2) {
        ClassLoader cl = UIManager.getLookAndFeel().getClass().getClassLoader();
        return UITheme.parseValue(key, value2, cl);
    }

    private static Insets parseInsets(String value2) {
        List numbers = StringUtil.split((String)value2, (String)",");
        return new JBInsets(Integer.parseInt((String)numbers.get(0)), Integer.parseInt((String)numbers.get(1)), Integer.parseInt((String)numbers.get(2)), Integer.parseInt((String)numbers.get(3))).asUIResource();
    }

    private static UIUtil.GrayFilter parseGrayFilter(String value2) {
        List numbers = StringUtil.split((String)value2, (String)",");
        return new UIUtil.GrayFilter(Integer.parseInt((String)numbers.get(0)), Integer.parseInt((String)numbers.get(1)), Integer.parseInt((String)numbers.get(2))).asUIResource();
    }

    private static Color parseColor(String value2) {
        if (value2 != null && (value2 = StringUtil.trimStart((String)value2, (String)"#")).length() == 8) {
            Color color = ColorUtil.fromHex((String)value2.substring(0, 6));
            try {
                int alpha = Integer.parseInt(value2.substring(6, 8), 16);
                return new ColorUIResource(new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha));
            }
            catch (Exception exception) {
                return null;
            }
        }
        Color color = ColorHexUtil.fromHex((String)value2, null);
        return color == null ? null : new ColorUIResource(color);
    }

    private static Integer getInteger(String value2, @Nullable String key) {
        try {
            return Integer.parseInt(StringUtil.trimEnd((String)value2, (String)".0"));
        }
        catch (NumberFormatException e) {
            if (key != null) {
                LOG.warn(key + " = " + value2);
            }
            return null;
        }
    }

    private static Dimension parseSize(String value2) {
        List numbers = StringUtil.split((String)value2, (String)",");
        return new JBDimension(Integer.parseInt((String)numbers.get(0)), Integer.parseInt((String)numbers.get(1))).asUIResource();
    }

    public String getEditorSchemeName() {
        return this.editorSchemeName;
    }

    public void setEditorSchemeName(String editorSchemeName) {
        this.editorSchemeName = editorSchemeName;
    }

    @Contract(value="null -> false")
    public static boolean isThemeFile(@Nullable VirtualFile file2) {
        return file2 != null && StringUtil.endsWithIgnoreCase((String)file2.getName(), (String)FILE_EXT_ENDING);
    }

    private void setName(String name) {
        this.name = name;
    }

    private void setDark(boolean dark) {
        this.dark = dark;
    }

    private void setAuthor(String author) {
        this.author = author;
    }

    private void setUi(Map<String, Object> ui) {
        this.ui = ui;
    }

    private void setIcons(Map<String, Object> icons) {
        this.icons = icons;
    }

    public void setEditorScheme(String editorScheme) {
        this.editorScheme = editorScheme;
    }

    public void setBackground(Map<String, Object> background) {
        this.background = background;
    }

    public void setEmptyFrameBackground(Map<String, Object> emptyFrameBackground) {
        this.emptyFrameBackground = emptyFrameBackground;
    }

    public Map<String, Object> getColors() {
        return this.colors;
    }

    public void setColors(Map<String, Object> colors) {
        this.colors = colors;
    }

    static {
        colorPalette.put("Actions.Red", "#DB5860");
        colorPalette.put("Actions.Red.Dark", "#C75450");
        colorPalette.put("Actions.Yellow", "#EDA200");
        colorPalette.put("Actions.Yellow.Dark", "#F0A732");
        colorPalette.put("Actions.Green", "#59A869");
        colorPalette.put("Actions.Green.Dark", "#499C54");
        colorPalette.put("Actions.Blue", "#389FD6");
        colorPalette.put("Actions.Blue.Dark", "#3592C4");
        colorPalette.put("Actions.Grey", "#6E6E6E");
        colorPalette.put("Actions.Grey.Dark", "#AFB1B3");
        colorPalette.put("Actions.GreyInline", "#7F8B91");
        colorPalette.put("Actions.GreyInline.Dark", "#7F8B91");
        colorPalette.put("Objects.Grey", "#9AA7B0");
        colorPalette.put("Objects.Blue", "#40B6E0");
        colorPalette.put("Objects.Green", "#62B543");
        colorPalette.put("Objects.Yellow", "#F4AF3D");
        colorPalette.put("Objects.YellowDark", "#D9A343");
        colorPalette.put("Objects.Purple", "#B99BF8");
        colorPalette.put("Objects.Pink", "#F98B9E");
        colorPalette.put("Objects.Red", "#F26522");
        colorPalette.put("Objects.RedStatus", "#E05555");
        colorPalette.put("Objects.GreenAndroid", "#A4C639");
        colorPalette.put("Objects.BlackText", "#231F20");
        colorPalette.put("Checkbox.Background.Default", "#FFFFFF");
        colorPalette.put("Checkbox.Background.Default.Dark", "#43494A");
        colorPalette.put("Checkbox.Background.Disabled", "#F2F2F2");
        colorPalette.put("Checkbox.Background.Disabled.Dark", "#3C3F41");
        colorPalette.put("Checkbox.Border.Default", "#878787");
        colorPalette.put("Checkbox.Border.Default.Dark", "#6B6B6B");
        colorPalette.put("Checkbox.Border.Disabled", "#BDBDBD");
        colorPalette.put("Checkbox.Border.Disabled.Dark", "#545556");
        colorPalette.put("Checkbox.Focus.Thin.Default", "#7B9FC7");
        colorPalette.put("Checkbox.Focus.Thin.Default.Dark", "#466D94");
        colorPalette.put("Checkbox.Focus.Wide", "#97C3F3");
        colorPalette.put("Checkbox.Focus.Wide.Dark", "#3D6185");
        colorPalette.put("Checkbox.Foreground.Disabled", "#ABABAB");
        colorPalette.put("Checkbox.Foreground.Disabled.Dark", "#606060");
        colorPalette.put("Checkbox.Background.Selected", "#4D89C9");
        colorPalette.put("Checkbox.Background.Selected.Dark", "#43494A");
        colorPalette.put("Checkbox.Border.Selected", "#4982CC");
        colorPalette.put("Checkbox.Border.Selected.Dark", "#6B6B6B");
        colorPalette.put("Checkbox.Foreground.Selected", "#FFFFFF");
        colorPalette.put("Checkbox.Foreground.Selected.Dark", "#A7A7A7");
        colorPalette.put("Checkbox.Focus.Thin.Selected", "#ACCFF7");
        colorPalette.put("Checkbox.Focus.Thin.Selected.Dark", "#466D94");
        colorPalette.put("Tree.iconColor", "#808080");
        colorPalette.put("Tree.iconColor.Dark", "#AFB1B3");
    }

    static class PaletteScopeManager {
        final PaletteScope ui = new PaletteScope();
        final PaletteScope checkBoxes = new PaletteScope();
        final PaletteScope radioButtons = new PaletteScope();
        final PaletteScope trees = new PaletteScope();

        PaletteScopeManager() {
        }

        PaletteScope getScope(String colorKey) {
            if (colorKey.startsWith("Checkbox.")) {
                return this.checkBoxes;
            }
            if (colorKey.startsWith("Radio.")) {
                return this.radioButtons;
            }
            if (colorKey.startsWith("Tree.iconColor")) {
                return this.trees;
            }
            if (colorKey.startsWith("Objects.")) {
                return this.ui;
            }
            if (colorKey.startsWith("Actions.")) {
                return this.ui;
            }
            if (colorKey.startsWith("#")) {
                return this.ui;
            }
            LOG.warn("No color scope defined for key: " + colorKey);
            return null;
        }

        @Nullable
        PaletteScope getScopeByURL(@Nullable URL url) {
            if (url != null) {
                String path = url.toString();
                String file2 = path.substring(path.lastIndexOf(47) + 1);
                if (path.contains("/com/intellij/ide/ui/laf/icons/")) {
                    if (file2.equals("treeCollapsed.svg") || file2.equals("treeExpanded.svg")) {
                        return this.trees;
                    }
                    if (file2.startsWith("check")) {
                        return this.checkBoxes;
                    }
                    if (file2.startsWith("radio")) {
                        return this.checkBoxes;
                    }
                    return null;
                }
            }
            return this.ui;
        }
    }

    static class PaletteScope {
        final Map<String, String> newPalette = new HashMap<String, String>();
        final Map<String, Integer> alphas = new HashMap<String, Integer>();
        private byte[] hash = null;

        PaletteScope() {
        }

        byte @NotNull [] digest() {
            if (this.hash != null) {
                return this.hash;
            }
            Hasher hasher = Hashing.sha256().newHasher();
            for (Map.Entry<String, String> entry : new TreeMap<String, String>(this.newPalette).entrySet()) {
                hasher.putString((CharSequence)entry.getKey(), StandardCharsets.UTF_8);
                hasher.putString((CharSequence)entry.getValue(), StandardCharsets.UTF_8);
            }
            for (Map.Entry<String, Object> entry : new TreeMap<String, Integer>(this.alphas).entrySet()) {
                hasher.putString((CharSequence)entry.getKey(), StandardCharsets.UTF_8);
                Integer value2 = (Integer)entry.getValue();
                if (value2 == null) continue;
                hasher.putInt(value2.intValue());
            }
            this.hash = hasher.hash().asBytes();
            return this.hash;
        }
    }
}

