/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.ide.ui.ExperimentalFeatureBooleanOptionDescriptor;
import com.intellij.ide.ui.OptionsSearchTopHitProvider;
import com.intellij.ide.ui.RegistryBooleanOptionDescriptor;
import com.intellij.ide.ui.RegistryTextOptionDescriptor;
import com.intellij.ide.ui.search.OptionDescription;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ExperimentalFeature;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

final class RegistryOptionsTopHitProvider
implements OptionsSearchTopHitProvider.ApplicationLevelProvider {
    RegistryOptionsTopHitProvider() {
        if (!ApplicationManager.getApplication().isInternal()) {
            throw ExtensionNotApplicableException.INSTANCE;
        }
    }

    @Override
    @NotNull
    public Collection<OptionDescription> getOptions() {
        return Holder.ourValues;
    }

    @Override
    @NotNull
    public String getId() {
        return "registry";
    }

    private static class Holder {
        private static final List<OptionDescription> ourValues = Holder.initValues();

        private Holder() {
        }

        private static List<OptionDescription> initValues() {
            ArrayList<OptionDescription> result2 = new ArrayList<OptionDescription>();
            for (RegistryValue value2 : Registry.getAll()) {
                if (value2.isBoolean()) {
                    String key = value2.getKey();
                    RegistryBooleanOptionDescriptor optionDescriptor = new RegistryBooleanOptionDescriptor(key, key);
                    if (value2.isChangedFromDefault()) {
                        result2.add(0, (OptionDescription)optionDescriptor);
                        continue;
                    }
                    result2.add((OptionDescription)optionDescriptor);
                    continue;
                }
                result2.add(new RegistryTextOptionDescriptor(value2));
            }
            for (ExperimentalFeature feature : (ExperimentalFeature[])Experiments.EP_NAME.getExtensions()) {
                ExperimentalFeatureBooleanOptionDescriptor descriptor2 = new ExperimentalFeatureBooleanOptionDescriptor(feature.id, feature.id);
                if (Experiments.getInstance().isChanged(feature.id)) {
                    result2.add(0, (OptionDescription)descriptor2);
                    continue;
                }
                result2.add((OptionDescription)descriptor2);
            }
            return result2;
        }
    }
}

