/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo.nodes;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.todo.HighlightedRegionProvider;
import com.intellij.ide.todo.SmartTodoItemPointer;
import com.intellij.ide.todo.TodoTreeBuilder;
import com.intellij.ide.todo.nodes.BaseToDoNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.search.TodoItem;
import com.intellij.ui.HighlightedRegion;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public final class TodoItemNode
extends BaseToDoNode<SmartTodoItemPointer>
implements HighlightedRegionProvider {
    private static final Logger LOG = Logger.getInstance(TodoItem.class);
    private final List<HighlightedRegion> myHighlightedRegions;
    private final List<HighlightedRegionProvider> myAdditionalLines;

    public TodoItemNode(Project project, @NotNull SmartTodoItemPointer value2, TodoTreeBuilder builder2) {
        super(project, value2, builder2);
        RangeMarker rangeMarker = value2.getRangeMarker();
        LOG.assertTrue(rangeMarker.isValid());
        this.myHighlightedRegions = ContainerUtil.createConcurrentList();
        this.myAdditionalLines = ContainerUtil.createConcurrentList();
    }

    @Override
    public boolean contains(Object element2) {
        return this.canRepresent(element2);
    }

    public boolean canRepresent(Object element2) {
        SmartTodoItemPointer value2 = (SmartTodoItemPointer)this.getValue();
        TodoItem item = value2 != null ? value2.getTodoItem() : null;
        return Comparing.equal((Object)item, (Object)element2);
    }

    @Override
    public int getFileCount(SmartTodoItemPointer val) {
        return 1;
    }

    @Override
    public int getTodoItemCount(SmartTodoItemPointer val) {
        return 1;
    }

    public List<HighlightedRegion> getHighlightedRegions() {
        return this.myHighlightedRegions;
    }

    @NotNull
    public Collection<AbstractTreeNode<?>> getChildren() {
        return Collections.emptyList();
    }

    public void update(@NotNull PresentationData presentation2) {
        int lineStartOffset;
        SmartTodoItemPointer todoItemPointer = (SmartTodoItemPointer)this.getValue();
        assert (todoItemPointer != null);
        TodoItem todoItem = todoItemPointer.getTodoItem();
        RangeMarker myRangeMarker = todoItemPointer.getRangeMarker();
        if (!todoItem.getFile().isValid() || !myRangeMarker.isValid() || myRangeMarker.getStartOffset() == myRangeMarker.getEndOffset()) {
            myRangeMarker.dispose();
            this.setValue(null);
            return;
        }
        this.myHighlightedRegions.clear();
        this.myAdditionalLines.clear();
        Document document = todoItemPointer.getDocument();
        CharSequence chars = document.getCharsSequence();
        int startOffset = myRangeMarker.getStartOffset();
        int endOffset = myRangeMarker.getEndOffset();
        int lineNumber = document.getLineNumber(startOffset);
        int columnNumber = startOffset - lineStartOffset;
        for (lineStartOffset = document.getLineStartOffset(lineNumber); lineStartOffset < document.getTextLength() && (chars.charAt(lineStartOffset) == '\t' || chars.charAt(lineStartOffset) == ' '); ++lineStartOffset) {
        }
        int lineEndOffset = document.getLineEndOffset(lineNumber);
        String lineColumnPrefix = "(" + (lineNumber + 1) + ", " + (columnNumber + 1) + ") ";
        String highlightedText = chars.subSequence(lineStartOffset, Math.min(lineEndOffset, chars.length())).toString();
        String newName = lineColumnPrefix + highlightedText;
        Icon newIcon = todoItem.getPattern().getAttributes().getIcon();
        this.myHighlightedRegions.clear();
        EditorHighlighter highlighter = this.myBuilder.getHighlighter(todoItem.getFile(), document);
        TodoItemNode.collectHighlights(this.myHighlightedRegions, highlighter, lineStartOffset, lineEndOffset, lineColumnPrefix.length());
        TextAttributes attributes = todoItem.getPattern().getAttributes().getTextAttributes();
        this.myHighlightedRegions.add(new HighlightedRegion(lineColumnPrefix.length() + startOffset - lineStartOffset, lineColumnPrefix.length() + endOffset - lineStartOffset, attributes));
        presentation2.setPresentableText(newName);
        presentation2.setIcon(newIcon);
        for (RangeMarker additionalMarker : todoItemPointer.getAdditionalRangeMarkers()) {
            if (!additionalMarker.isValid()) break;
            ArrayList<HighlightedRegion> highlights = new ArrayList<HighlightedRegion>();
            int lineNum = document.getLineNumber(additionalMarker.getStartOffset());
            int lineStart = document.getLineStartOffset(lineNum);
            int lineEnd = document.getLineEndOffset(lineNum);
            int lineStartNonWs = CharArrayUtil.shiftForward((CharSequence)chars, (int)lineStart, (String)" \t");
            if (lineStartNonWs > additionalMarker.getStartOffset() || lineEnd < additionalMarker.getEndOffset()) break;
            TodoItemNode.collectHighlights(highlights, highlighter, lineStartNonWs, lineEnd, 0);
            highlights.add(new HighlightedRegion(additionalMarker.getStartOffset() - lineStartNonWs, additionalMarker.getEndOffset() - lineStartNonWs, attributes));
            this.myAdditionalLines.add(new AdditionalTodoLine(document.getText(new TextRange(lineStartNonWs, lineEnd)), highlights));
        }
    }

    private static void collectHighlights(@NotNull List<? super HighlightedRegion> highlights, @NotNull EditorHighlighter highlighter, int startOffset, int endOffset, int highlightOffsetShift) {
        HighlighterIterator iterator2 = highlighter.createIterator(startOffset);
        while (!iterator2.atEnd()) {
            int start2 = Math.max(iterator2.getStart(), startOffset);
            int end = Math.min(iterator2.getEnd(), endOffset);
            if (start2 >= endOffset) break;
            TextAttributes attributes = iterator2.getTextAttributes();
            int fontType = attributes.getFontType();
            if ((fontType & 1) != 0) {
                attributes = attributes.clone();
                attributes.setFontType(fontType & 0xFFFFFFFE);
            }
            HighlightedRegion region = new HighlightedRegion(highlightOffsetShift + start2 - startOffset, highlightOffsetShift + end - startOffset, attributes);
            highlights.add((HighlightedRegion)region);
            iterator2.advance();
        }
    }

    public String getTestPresentation() {
        return "Item: " + ((SmartTodoItemPointer)this.getValue()).getTodoItem().getTextRange();
    }

    public int getWeight() {
        return 5;
    }

    @NotNull
    public List<HighlightedRegionProvider> getAdditionalLines() {
        return this.myAdditionalLines;
    }

    private static class AdditionalTodoLine
    implements HighlightedRegionProvider {
        private final String myText;
        private final List<HighlightedRegion> myHighlights;

        private AdditionalTodoLine(String text, List<HighlightedRegion> highlights) {
            this.myText = text;
            this.myHighlights = highlights;
        }

        @Override
        public Iterable<HighlightedRegion> getHighlightedRegions() {
            return this.myHighlights;
        }

        public String toString() {
            return this.myText;
        }
    }
}

