/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.todo.AllTodosTreeBuilder;
import com.intellij.ide.todo.CurrentFileTodosPanel;
import com.intellij.ide.todo.CurrentFileTodosTreeBuilder;
import com.intellij.ide.todo.ScopeBasedTodosPanel;
import com.intellij.ide.todo.TodoConfiguration;
import com.intellij.ide.todo.TodoPanel;
import com.intellij.ide.todo.TodoPanelSettings;
import com.intellij.ide.todo.TodoTreeBuilder;
import com.intellij.ide.todo.TodoTreeBuilderFactory;
import com.intellij.ide.todo.TodoViewChangesSupport;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.fileTypes.FileTypeEvent;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.ui.IdeUICustomization;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.concurrency.NonUrgentExecutor;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.OptionTag;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import javax.swing.JComponent;
import javax.swing.JTree;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="TodoView", storages={@Storage(value="$PRODUCT_WORKSPACE_FILE$"), @Storage(value="$WORKSPACE_FILE$", deprecated=true)})
public class TodoView
implements PersistentStateComponent<State>,
Disposable {
    private final Project myProject;
    private ContentManager myContentManager;
    private TodoPanel myAllTodos;
    @Nullable
    private TodoPanel myChangeListTodosPanel;
    private CurrentFileTodosPanel myCurrentFileTodosPanel;
    private ScopeBasedTodosPanel myScopeBasedTodosPanel;
    private final List<TodoPanel> myPanels = new ArrayList<TodoPanel>();
    private final List<Content> myNotAddedContent = new ArrayList<Content>();
    private State state = new State();
    private final TodoViewChangesSupport myChangesSupport;
    private final TodoViewChangesSupport.Listener myChangesListener;
    private Content myChangeListTodosContent;

    public TodoView(@NotNull Project project) {
        this.myProject = project;
        this.state.all.arePackagesShown = true;
        this.state.all.isAutoScrollToSource = true;
        this.state.current.isAutoScrollToSource = true;
        MessageBusConnection connection = project.getMessageBus().connect((Disposable)this);
        connection.subscribe(TodoConfiguration.PROPERTY_CHANGE, (Object)new MyPropertyChangeListener());
        connection.subscribe(FileTypeManager.TOPIC, (Object)new MyFileTypeListener());
        this.myChangesSupport = (TodoViewChangesSupport)project.getService(TodoViewChangesSupport.class);
        this.myChangesListener = this.myChangesSupport.installListener(project, connection, (Function0<? extends ContentManager>)((Function0)() -> this.myContentManager), (Function0<? extends Content>)((Function0)() -> this.myChangeListTodosContent));
    }

    public void loadState(@NotNull State state) {
        this.state = state;
    }

    public State getState() {
        if (this.myContentManager != null) {
            Content content2 = this.myContentManager.getSelectedContent();
            this.state.selectedIndex = content2 == null ? -1 : this.myContentManager.getIndexOfContent(content2);
        }
        return this.state;
    }

    public void dispose() {
    }

    public TodoTreeBuilder getBuilderAndAllowUpdatesOnIt(Scope scope) {
        TodoTreeBuilder builder2 = null;
        switch (scope) {
            case AllTodos: {
                builder2 = this.myAllTodos.myTodoTreeBuilder;
                break;
            }
            case ChangeList: {
                builder2 = this.myChangeListTodosPanel.myTodoTreeBuilder;
                break;
            }
            case CurrentFile: {
                builder2 = this.myCurrentFileTodosPanel.myTodoTreeBuilder;
                break;
            }
            case ScopeBased: {
                builder2 = this.myScopeBasedTodosPanel.myTodoTreeBuilder;
            }
        }
        builder2.setUpdatable(true);
        return builder2;
    }

    public void initToolWindow(@NotNull ToolWindow toolWindow) {
        ContentFactory contentFactory = ContentFactory.SERVICE.getInstance();
        Content allTodosContent = contentFactory.createContent(null, IdeUICustomization.getInstance().projectMessage("tab.title.project", new Object[0]), false);
        toolWindow.setHelpId("find.todoList");
        this.myAllTodos = new TodoPanel(this.myProject, this.state.all, false, allTodosContent){

            @Override
            protected TodoTreeBuilder createTreeBuilder(JTree tree, Project project) {
                AllTodosTreeBuilder builder2 = TodoView.this.createAllTodoBuilder(tree, project);
                builder2.init();
                return builder2;
            }
        };
        allTodosContent.setComponent(this.wrapWithDumbModeSpoiler(this.myAllTodos));
        allTodosContent.setPreferredFocusableComponent((JComponent)this.myAllTodos.getTree());
        Disposer.register((Disposable)this, (Disposable)this.myAllTodos);
        if (toolWindow instanceof ToolWindowEx) {
            DefaultActionGroup group = new DefaultActionGroup(){
                {
                    this.getTemplatePresentation().setText(IdeBundle.messagePointer((String)"group.view.options", (Object[])new Object[0]));
                    this.setPopup(true);
                    this.add(TodoView.this.myAllTodos.createAutoScrollToSourceAction());
                    this.addSeparator();
                    this.addAll((ActionGroup)TodoView.this.myAllTodos.createGroupByActionGroup());
                }
            };
            ((ToolWindowEx)toolWindow).setAdditionalGearActions((ActionGroup)group);
        }
        Content currentFileTodosContent = contentFactory.createContent(null, IdeBundle.message((String)"title.todo.current.file", (Object[])new Object[0]), false);
        this.myCurrentFileTodosPanel = new CurrentFileTodosPanel(this.myProject, this.state.current, currentFileTodosContent){

            @Override
            protected TodoTreeBuilder createTreeBuilder(JTree tree, Project project) {
                CurrentFileTodosTreeBuilder builder2 = new CurrentFileTodosTreeBuilder(tree, project);
                builder2.init();
                return builder2;
            }
        };
        Disposer.register((Disposable)this, (Disposable)this.myCurrentFileTodosPanel);
        currentFileTodosContent.setComponent(this.wrapWithDumbModeSpoiler(this.myCurrentFileTodosPanel));
        currentFileTodosContent.setPreferredFocusableComponent((JComponent)this.myCurrentFileTodosPanel.getTree());
        String tabName = this.myChangesSupport.getTabName(this.myProject);
        this.myChangeListTodosContent = contentFactory.createContent(null, tabName, false);
        this.myChangeListTodosPanel = this.myChangesSupport.createPanel(this.myProject, this.state.current, this.myChangeListTodosContent);
        if (this.myChangeListTodosPanel != null) {
            Disposer.register((Disposable)this, (Disposable)this.myChangeListTodosPanel);
            this.myChangeListTodosContent.setComponent(this.wrapWithDumbModeSpoiler(this.myChangeListTodosPanel));
            this.myChangeListTodosContent.setPreferredFocusableComponent((JComponent)this.myCurrentFileTodosPanel.getTree());
        }
        Content scopeBasedTodoContent = contentFactory.createContent(null, LangBundle.message((String)"tab.title.scope.based", (Object[])new Object[0]), false);
        this.myScopeBasedTodosPanel = new ScopeBasedTodosPanel(this.myProject, this.state.current, scopeBasedTodoContent);
        Disposer.register((Disposable)this, (Disposable)this.myScopeBasedTodosPanel);
        scopeBasedTodoContent.setComponent(this.wrapWithDumbModeSpoiler(this.myScopeBasedTodosPanel));
        this.myContentManager = toolWindow.getContentManager();
        this.myContentManager.addContent(allTodosContent);
        this.myContentManager.addContent(currentFileTodosContent);
        this.myContentManager.addContent(scopeBasedTodoContent);
        if (this.myChangesSupport.isContentVisible(this.myProject)) {
            this.myChangesListener.setVisible(true);
            this.myContentManager.addContent(this.myChangeListTodosContent);
        }
        for (Content content2 : this.myNotAddedContent) {
            this.myContentManager.addContent(content2);
        }
        this.myChangeListTodosContent.setCloseable(false);
        allTodosContent.setCloseable(false);
        currentFileTodosContent.setCloseable(false);
        scopeBasedTodoContent.setCloseable(false);
        Content content3 = this.myContentManager.getContent(this.state.selectedIndex);
        this.myContentManager.setSelectedContent(content3 == null ? allTodosContent : content3);
        this.myPanels.add(this.myAllTodos);
        if (this.myChangeListTodosPanel != null) {
            this.myPanels.add(this.myChangeListTodosPanel);
        }
        this.myPanels.add(this.myCurrentFileTodosPanel);
        this.myPanels.add(this.myScopeBasedTodosPanel);
    }

    public void disposePanels() {
        Disposer.dispose((Disposable)this.myAllTodos);
        if (this.myChangeListTodosPanel != null) {
            Disposer.dispose((Disposable)this.myChangeListTodosPanel);
        }
        Disposer.dispose((Disposable)this.myCurrentFileTodosPanel);
        Disposer.dispose((Disposable)this.myScopeBasedTodosPanel);
    }

    @NotNull
    static String getTabNameForChangeList(@NotNull String changelistName) {
        String suffix;
        return StringUtil.endsWithIgnoreCase((String)(changelistName = changelistName.trim()), (String)(suffix = "Changelist")) ? changelistName : changelistName + " " + suffix;
    }

    @NotNull
    protected AllTodosTreeBuilder createAllTodoBuilder(JTree tree, Project project) {
        return new AllTodosTreeBuilder(tree, project);
    }

    public void refresh() {
        HashMap files2 = new HashMap();
        ReadAction.nonBlocking(() -> {
            if (this.myAllTodos == null) {
                return;
            }
            for (TodoPanel panel2 : this.myPanels) {
                panel2.myTodoTreeBuilder.collectFiles((Processor<? super VirtualFile>)((Processor)virtualFile -> {
                    files2.computeIfAbsent(panel2, p -> new HashSet()).add(virtualFile);
                    return true;
                }));
            }
        }).finishOnUiThread(ModalityState.NON_MODAL, __ -> {
            for (TodoPanel panel2 : this.myPanels) {
                panel2.rebuildCache((Set)ObjectUtils.notNull(files2.get((Object)panel2), new HashSet()));
                panel2.updateTree();
                this.notifyUpdateFinished();
            }
        }).inSmartMode(this.myProject).submit((Executor)NonUrgentExecutor.getInstance());
    }

    protected void notifyUpdateFinished() {
    }

    public void addCustomTodoView(TodoTreeBuilderFactory factory2, String title, TodoPanelSettings settings) {
        Content content2 = ContentFactory.SERVICE.getInstance().createContent(null, title, true);
        final TodoPanel panel2 = this.myChangesSupport.createPanel(this.myProject, settings, content2, factory2);
        if (panel2 == null) {
            return;
        }
        content2.setComponent(this.wrapWithDumbModeSpoiler(panel2));
        Disposer.register((Disposable)this, (Disposable)panel2);
        if (this.myContentManager == null) {
            this.myNotAddedContent.add(content2);
        } else {
            this.myContentManager.addContent(content2);
        }
        this.myPanels.add(panel2);
        content2.setCloseable(true);
        content2.setDisposer(new Disposable(){

            public void dispose() {
                TodoView.this.myPanels.remove((Object)panel2);
            }
        });
    }

    @NotNull
    private JComponent wrapWithDumbModeSpoiler(@NotNull TodoPanel panel2) {
        return DumbService.getInstance((Project)this.myProject).wrapWithSpoiler((JComponent)((Object)panel2), () -> ApplicationManager.getApplication().invokeLater(() -> {
            panel2.rebuildCache();
            panel2.updateTree();
        }, this.myProject.getDisposed()), (Disposable)panel2);
    }

    private final class MyFileTypeListener
    implements FileTypeListener {
        private MyFileTypeListener() {
        }

        public void fileTypesChanged(@NotNull FileTypeEvent e) {
            TodoView.this.refresh();
        }
    }

    private final class MyPropertyChangeListener
    implements PropertyChangeListener {
        private MyPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if ("todoPatterns".equals(e.getPropertyName()) || "todoFilters".equals(e.getPropertyName())) {
                this.updateFilters();
            }
        }

        private void updateFilters() {
            try {
                for (TodoPanel panel2 : TodoView.this.myPanels) {
                    panel2.updateTodoFilter();
                }
            }
            catch (ProcessCanceledException processCanceledException) {
                // empty catch block
            }
        }
    }

    public static enum Scope {
        AllTodos,
        ChangeList,
        CurrentFile,
        ScopeBased;

    }

    static class State {
        @Attribute(value="selected-index")
        public int selectedIndex;
        @OptionTag(value="selected-file", nameAttribute="id", tag="todo-panel", valueAttribute="")
        public TodoPanelSettings current = new TodoPanelSettings();
        @OptionTag(value="all", nameAttribute="id", tag="todo-panel", valueAttribute="")
        public TodoPanelSettings all = new TodoPanelSettings();
        @OptionTag(value="default-changelist", nameAttribute="id", tag="todo-panel", valueAttribute="")
        public TodoPanelSettings changeList = new TodoPanelSettings();

        State() {
        }
    }
}

