/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup;

import com.intellij.configurationStore.StorageUtilKt;
import com.intellij.internal.statistic.collectors.fus.project.ProjectFsStatsCollector;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.local.FileWatcher;
import com.intellij.openapi.vfs.impl.local.LocalFileSystemImpl;
import com.intellij.project.ProjectKt;
import com.intellij.util.PathUtil;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.concurrency.NonUrgentExecutor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/ide/startup/CheckFsSanityAndProjectRootPostStartUpActivity;", "Lcom/intellij/openapi/startup/StartupActivity$DumbAware;", "()V", "checkFsSanity", "", "project", "Lcom/intellij/openapi/project/Project;", "checkProjectRoots", "runActivity", "Companion", "intellij.platform.ide.impl"})
public final class CheckFsSanityAndProjectRootPostStartUpActivity
implements StartupActivity.DumbAware {
    private static final Logger LOG;
    public static final Companion Companion;

    public void runActivity(@NotNull Project project) {
        try {
            this.checkFsSanity(project);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
        NonUrgentExecutor.getInstance().execute(new Runnable(this, project){
            final /* synthetic */ CheckFsSanityAndProjectRootPostStartUpActivity this$0;
            final /* synthetic */ Project $project;

            public final void run() {
                CheckFsSanityAndProjectRootPostStartUpActivity.access$checkProjectRoots(this.this$0, this.$project);
                StorageUtilKt.checkUnknownMacros(this.$project, true);
            }
            {
                this.this$0 = checkFsSanityAndProjectRootPostStartUpActivity;
                this.$project = project;
            }
        });
    }

    private final void checkFsSanity(Project project) {
        boolean bl;
        String path = project.getProjectFilePath();
        if (path == null || FileUtil.isAncestor((String)PathManager.getConfigPath(), (String)path, (boolean)true)) {
            return;
        }
        if (ProjectKt.isDirectoryBased(project)) {
            path = PathUtil.getParentPath((String)path);
        }
        boolean expected = SystemInfo.isFileSystemCaseSensitive;
        try {
            bl = FileUtil.isFileSystemCaseSensitive((String)path);
        }
        catch (FileNotFoundException ignore) {
            return;
        }
        boolean actual = bl;
        LOG.info(path + " case-sensitivity: expected=" + expected + " actual=" + actual);
        if (actual != expected) {
            int prefix = expected ? 1 : 0;
            String title = ApplicationBundle.message((String)"fs.case.sensitivity.mismatch.title", (Object[])new Object[0]);
            String text = ApplicationBundle.message((String)"fs.case.sensitivity.mismatch.message", (Object[])new Object[]{prefix});
            Notifications.Bus.notify((Notification)new Notification("System Messages", title, text, NotificationType.WARNING, NotificationListener.URL_OPENING_LISTENER), (Project)project);
        }
        ProjectFsStatsCollector.caseSensitivity(project, actual);
    }

    private final void checkProjectRoots(Project project) {
        VirtualFile[] roots;
        VirtualFile[] virtualFileArray = roots = ProjectRootManager.getInstance((Project)project).getContentRoots();
        boolean bl = false;
        if (virtualFileArray.length == 0) {
            return;
        }
        LocalFileSystem localFileSystem2 = LocalFileSystem.getInstance();
        if (!(localFileSystem2 instanceof LocalFileSystemImpl)) {
            localFileSystem2 = null;
        }
        LocalFileSystemImpl localFileSystemImpl = (LocalFileSystemImpl)localFileSystem2;
        if (localFileSystemImpl == null) {
            return;
        }
        FileWatcher watcher = localFileSystemImpl.getFileWatcher();
        if (!watcher.isOperational()) {
            ProjectFsStatsCollector.watchedRoots(project, -1);
            return;
        }
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(project, watcher, roots){
            final /* synthetic */ Project $project;
            final /* synthetic */ FileWatcher $watcher;
            final /* synthetic */ VirtualFile[] $roots;

            public final void run() {
                CheckFsSanityAndProjectRootPostStartUpActivity.access$getLOG$cp().debug("FW/roots waiting started");
                while (true) {
                    if (this.$project.isDisposed()) {
                        return;
                    }
                    if (!this.$watcher.isSettingRoots()) break;
                    TimeoutUtil.sleep((long)10L);
                }
                CheckFsSanityAndProjectRootPostStartUpActivity.access$getLOG$cp().debug("FW/roots waiting finished");
                Collection<String> manualWatchRoots = this.$watcher.getManualWatchRoots();
                int pctNonWatched = 0;
                if (!manualWatchRoots.isEmpty()) {
                    List nonWatched = null;
                    for (VirtualFile root : this.$roots) {
                        if (!(root.getFileSystem() instanceof LocalFileSystem)) continue;
                        String rootPath = root.getPath();
                        Iterator<String> iterator2 = manualWatchRoots.iterator();
                        while (iterator2.hasNext()) {
                            String manualWatchRoot;
                            String string = manualWatchRoot = iterator2.next();
                            if (string == null) {
                                Intrinsics.throwNpe();
                            }
                            if (!FileUtil.isAncestor((String)string, (String)rootPath, (boolean)false)) continue;
                            if (nonWatched == null) {
                                boolean bl = false;
                                nonWatched = new ArrayList<E>();
                            }
                            nonWatched.add(rootPath);
                        }
                    }
                    if (nonWatched != null) {
                        String message = ApplicationBundle.message((String)"watcher.non.watchable.project", (Object[])new Object[0]);
                        this.$watcher.notifyOnFailure(message, null);
                        CheckFsSanityAndProjectRootPostStartUpActivity.access$getLOG$cp().info("unwatched roots: " + nonWatched);
                        CheckFsSanityAndProjectRootPostStartUpActivity.access$getLOG$cp().info("manual watches: " + manualWatchRoots);
                        pctNonWatched = (int)(100.0 * (double)nonWatched.size() / (double)this.$roots.length);
                    }
                }
                ProjectFsStatsCollector.watchedRoots(this.$project, pctNonWatched);
            }
            {
                this.$project = project;
                this.$watcher = fileWatcher;
                this.$roots = virtualFileArray;
            }
        });
    }

    public CheckFsSanityAndProjectRootPostStartUpActivity() {
        if (ApplicationManager.getApplication().isHeadlessEnvironment() || ApplicationManager.getApplication().isUnitTestMode()) {
            throw (Throwable)ExtensionNotApplicableException.INSTANCE;
        }
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        LOG = Logger.getInstance(CheckFsSanityAndProjectRootPostStartUpActivity.class);
    }

    public static final /* synthetic */ void access$checkProjectRoots(CheckFsSanityAndProjectRootPostStartUpActivity $this, Project project) {
        $this.checkProjectRoots(project);
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ide/startup/CheckFsSanityAndProjectRootPostStartUpActivity$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

