/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.script;

import com.intellij.ide.script.IdeScriptEngine;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.extensions.PluginDescriptor;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IdeScriptEngineManager {
    public static IdeScriptEngineManager getInstance() {
        return (IdeScriptEngineManager)ServiceManager.getService(IdeScriptEngineManager.class);
    }

    @NotNull
    public abstract List<EngineInfo> getEngineInfos();

    @Nullable
    public abstract IdeScriptEngine getEngine(@NotNull EngineInfo var1, @Nullable ClassLoader var2);

    @Nullable
    public abstract IdeScriptEngine getEngineByName(@NotNull String var1, @Nullable ClassLoader var2);

    @Nullable
    public abstract IdeScriptEngine getEngineByFileExtension(@NotNull String var1, @Nullable ClassLoader var2);

    public abstract boolean isInitialized();

    public static class EngineInfo {
        public final String engineName;
        public final String engineVersion;
        public final String languageName;
        public final String languageVersion;
        public final List<String> fileExtensions;
        public final String factoryClass;
        public final PluginDescriptor plugin;

        EngineInfo(@NotNull String engineName, @Nullable String engineVersion, @NotNull String languageName, @Nullable String languageVersion, @NotNull List<String> fileExtensions, @NotNull String factoryClass, @Nullable PluginDescriptor plugin) {
            this.engineName = engineName;
            this.engineVersion = engineVersion;
            this.languageName = languageName;
            this.languageVersion = languageVersion;
            this.fileExtensions = fileExtensions;
            this.factoryClass = factoryClass;
            this.plugin = plugin;
        }
    }
}

