/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scratch;

import com.intellij.icons.AllIcons;
import com.intellij.ide.FileIconProvider;
import com.intellij.ide.navigationToolbar.AbstractNavBarModelExtension;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ProjectViewNodeDecorator;
import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.ide.scratch.ScratchesSearchScope;
import com.intellij.lang.LangBundle;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.PerFileMappings;
import com.intellij.lang.PerFileMappingsBase;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.impl.EditorTabTitleProvider;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.fileEditor.impl.NonProjectFileWritingAccessExtension;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.fileTypes.SyntaxHighlighterProvider;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageDependencies.ui.PackageDependenciesNode;
import com.intellij.psi.LanguageSubstitutor;
import com.intellij.psi.LanguageSubstitutors;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.UseScopeEnlarger;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.usages.impl.rules.UsageType;
import com.intellij.usages.impl.rules.UsageTypeProvider;
import com.intellij.util.FileContentUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.IndexableSetContributor;
import com.intellij.util.indexing.LightDirectoryIndex;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;

@State(name="ScratchFileService", storages={@Storage(value="scratches.xml", roamingType=RoamingType.DISABLED)})
public class ScratchFileServiceImpl
extends ScratchFileService
implements PersistentStateComponent<Element>,
Disposable {
    private static final RootType NO_ROOT_TYPE = new RootType("", "NO_ROOT_TYPE"){};
    private final LightDirectoryIndex<RootType> myIndex;
    private final MyLanguages myScratchMapping = new MyLanguages();

    protected ScratchFileServiceImpl() {
        Disposer.register((Disposable)this, (Disposable)this.myScratchMapping);
        this.myIndex = new LightDirectoryIndex<RootType>((Disposable)ApplicationManager.getApplication(), NO_ROOT_TYPE, index -> {
            LocalFileSystem fileSystem = LocalFileSystem.getInstance();
            for (RootType r : RootType.getAllRootTypes()) {
                index.putInfo(fileSystem.findFileByPath(this.getRootPath(r)), r);
            }
        });
        this.initFileOpenedListener();
    }

    @NotNull
    public String getRootPath(@NotNull RootType rootType) {
        return ScratchFileServiceImpl.getScratchesPath() + "/" + rootType.getId();
    }

    @Nullable
    public RootType getRootType(@Nullable VirtualFile file2) {
        if (file2 == null || !file2.isInLocalFileSystem()) {
            return null;
        }
        VirtualFile directory = file2.isDirectory() ? file2 : file2.getParent();
        RootType result2 = this.myIndex.getInfoForFile(directory);
        return result2 == NO_ROOT_TYPE ? null : result2;
    }

    private void initFileOpenedListener() {
        FileEditorManagerListener editorListener = new FileEditorManagerListener(){

            public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
                if (!this.isEditable(file2)) {
                    return;
                }
                RootType rootType = ScratchFileServiceImpl.this.getRootType(file2);
                if (rootType == null) {
                    return;
                }
                rootType.fileOpened(file2, source);
            }

            public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
                if (Boolean.TRUE.equals(file2.getUserData(FileEditorManagerImpl.CLOSING_TO_REOPEN))) {
                    return;
                }
                if (!this.isEditable(file2)) {
                    return;
                }
                RootType rootType = ScratchFileServiceImpl.this.getRootType(file2);
                if (rootType == null) {
                    return;
                }
                rootType.fileClosed(file2, source);
            }

            boolean isEditable(@NotNull VirtualFile file2) {
                return FileDocumentManager.getInstance().getDocument(file2) != null;
            }
        };
        ScratchFileServiceImpl.processOpenFiles((file2, manager) -> {
            RootType rootType = this.getRootType((VirtualFile)file2);
            if (rootType == null) {
                return;
            }
            rootType.fileOpened(file2, manager);
        });
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)editorListener);
        RootType.ROOT_EP.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<RootType>(){

            public void extensionAdded(@NotNull RootType rootType, @NotNull PluginDescriptor pluginDescriptor) {
                ScratchFileServiceImpl.this.myIndex.resetIndex();
                ScratchFileServiceImpl.processOpenFiles((file2, manager) -> {
                    if (ScratchFileServiceImpl.this.getRootType((VirtualFile)file2) != rootType) {
                        return;
                    }
                    rootType.fileOpened(file2, manager);
                });
                for (Project project : ProjectManager.getInstance().getOpenProjects()) {
                    FileContentUtil.reparseFiles((Project)project, Collections.emptyList(), (boolean)true);
                }
            }

            public void extensionRemoved(@NotNull RootType rootType, @NotNull PluginDescriptor pluginDescriptor) {
                VirtualFile rootFile = LocalFileSystem.getInstance().findFileByPath(ScratchFileServiceImpl.this.getRootPath(rootType));
                if (rootFile != null) {
                    ScratchFileServiceImpl.processOpenFiles((file2, manager) -> {
                        if (VfsUtilCore.isAncestor((VirtualFile)rootFile, (VirtualFile)file2, (boolean)true)) {
                            rootType.fileClosed(file2, manager);
                        }
                    });
                }
                ScratchFileServiceImpl.this.myIndex.resetIndex();
                for (Project project : ProjectManager.getInstance().getOpenProjects()) {
                    FileContentUtil.reparseFiles((Project)project, Collections.emptyList(), (boolean)true);
                }
            }
        }, (Disposable)ApplicationManager.getApplication());
    }

    private static void processOpenFiles(@NotNull BiConsumer<? super VirtualFile, ? super FileEditorManager> consumer) {
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            FileEditorManager editorManager = FileEditorManager.getInstance((Project)project);
            for (VirtualFile virtualFile : editorManager.getOpenFiles()) {
                if (fileDocumentManager.getDocument(virtualFile) == null) continue;
                consumer.accept((VirtualFile)virtualFile, (FileEditorManager)editorManager);
            }
        }
    }

    @NotNull
    static @SystemIndependent String getScratchesPath() {
        return FileUtil.toSystemIndependentName((String)PathManager.getScratchPath());
    }

    @NotNull
    public PerFileMappings<Language> getScratchesMapping() {
        return new PerFileMappings<Language>(){

            public void setMapping(@Nullable VirtualFile file2, @Nullable Language value2) {
                ScratchFileServiceImpl.this.myScratchMapping.setMapping(file2, value2 == null ? null : value2.getID());
            }

            @Nullable
            public Language getMapping(@Nullable VirtualFile file2) {
                return Language.findLanguageByID((String)((String)ScratchFileServiceImpl.this.myScratchMapping.getMapping(file2)));
            }
        };
    }

    @Nullable
    public Element getState() {
        return this.myScratchMapping.getState();
    }

    public void loadState(@NotNull Element state) {
        this.myScratchMapping.loadState(state);
    }

    public void dispose() {
    }

    public VirtualFile findFile(@NotNull RootType rootType, @NotNull String pathName, @NotNull ScratchFileService.Option option2) throws IOException {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        String fullPath = this.getRootPath(rootType) + "/" + pathName;
        if (option2 != ScratchFileService.Option.create_new_always) {
            VirtualFile file2 = LocalFileSystem.getInstance().findFileByPath(fullPath);
            if (file2 != null && !file2.isDirectory()) {
                return file2;
            }
            if (option2 == ScratchFileService.Option.existing_only) {
                return null;
            }
        }
        String ext = PathUtil.getFileExtension((String)pathName);
        String fileNameExt = PathUtil.getFileName((String)pathName);
        String fileName = StringUtil.trimEnd((String)fileNameExt, (String)(ext == null ? "" : "." + ext));
        return (VirtualFile)WriteAction.compute(() -> {
            VirtualFile dir = VfsUtil.createDirectories((String)PathUtil.getParentPath((String)fullPath));
            if (option2 == ScratchFileService.Option.create_new_always) {
                return VfsUtil.createChildSequent((Object)LocalFileSystem.getInstance(), (VirtualFile)dir, (String)fileName, (String)StringUtil.notNullize((String)ext));
            }
            return dir.findOrCreateChildData((Object)LocalFileSystem.getInstance(), fileNameExt);
        });
    }

    @Nullable
    private static Language getLanguageByFileName(@Nullable VirtualFile file2) {
        return file2 == null ? null : LanguageUtil.getFileTypeLanguage((FileType)FileTypeManager.getInstance().getFileTypeByFileName(file2.getNameSequence()));
    }

    public static class IndexSetContributor
    extends IndexableSetContributor {
        @NotNull
        public Set<VirtualFile> getAdditionalRootsToIndex() {
            ScratchFileService instance = ScratchFileService.getInstance();
            LocalFileSystem fileSystem = LocalFileSystem.getInstance();
            HashSet<VirtualFile> result2 = new HashSet<VirtualFile>();
            for (RootType rootType : RootType.getAllRootTypes()) {
                if (rootType.isHidden()) continue;
                ContainerUtil.addIfNotNull(result2, (Object)fileSystem.findFileByPath(instance.getRootPath(rootType)));
            }
            return result2;
        }
    }

    public static class UsageTypeExtension
    implements UsageTypeProvider {
        private static final ConcurrentMap<RootType, UsageType> ourUsageTypes = ConcurrentFactoryMap.createMap(key -> new UsageType(LangBundle.messagePointer((String)"usage.type.usage.in.0", (Object[])new Object[]{key.getDisplayName()})));

        @Nullable
        public UsageType getUsageType(PsiElement element2) {
            VirtualFile file2 = PsiUtilCore.getVirtualFile((PsiElement)element2);
            RootType rootType = ScratchFileService.getInstance().getRootType(file2);
            return rootType == null ? null : (UsageType)ourUsageTypes.get(rootType);
        }
    }

    public static class UseScopeExtension
    extends UseScopeEnlarger {
        @Nullable
        public SearchScope getAdditionalUseScope(@NotNull PsiElement element2) {
            SearchScope useScope = element2.getUseScope();
            if (useScope instanceof LocalSearchScope) {
                return null;
            }
            return ScratchesSearchScope.getScratchesScope(element2.getProject());
        }
    }

    public static class NavBarExtension
    extends AbstractNavBarModelExtension {
        @Override
        @Nullable
        public Icon getIcon(Object object) {
            VirtualFile file2;
            VirtualFile virtualFile = file2 = object instanceof PsiFileSystemItem ? ((PsiFileSystemItem)object).getVirtualFile() : null;
            if (file2 == null) {
                return null;
            }
            RootType rootType = ScratchFileService.getInstance().getRootType(file2);
            if (rootType == null) {
                return null;
            }
            Icon icon2 = rootType.substituteIcon(((PsiFileSystemItem)object).getProject(), file2);
            return icon2 == null && file2.isDirectory() ? AllIcons.Nodes.Folder : icon2;
        }

        @Override
        @Nullable
        public String getPresentableText(Object object) {
            if (!(object instanceof PsiElement)) {
                return null;
            }
            Project project = ((PsiElement)object).getProject();
            VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)((PsiElement)object));
            if (virtualFile == null || !virtualFile.isValid()) {
                return null;
            }
            RootType rootType = ScratchFileService.getInstance().getRootType(virtualFile);
            if (rootType == null) {
                return null;
            }
            if (virtualFile.isDirectory() && this.additionalRoots(project).contains(virtualFile)) {
                return rootType.getDisplayName();
            }
            return rootType.substituteName(project, virtualFile);
        }

        @Override
        @NotNull
        public Collection<VirtualFile> additionalRoots(Project project) {
            LinkedHashSet<VirtualFile> result2 = new LinkedHashSet<VirtualFile>();
            LocalFileSystem fileSystem = LocalFileSystem.getInstance();
            ScratchFileService app = ScratchFileService.getInstance();
            for (RootType r : RootType.getAllRootTypes()) {
                ContainerUtil.addIfNotNull(result2, (Object)fileSystem.findFileByPath(app.getRootPath(r)));
            }
            return result2;
        }
    }

    public static class AccessExtension
    implements NonProjectFileWritingAccessExtension {
        @Override
        public boolean isWritable(@NotNull VirtualFile file2) {
            return ScratchUtil.isScratch(file2);
        }
    }

    public static class FilePresentation
    implements FileIconProvider,
    EditorTabTitleProvider,
    ProjectViewNodeDecorator,
    DumbAware {
        @Override
        public void decorate(ProjectViewNode<?> node, PresentationData data2) {
            String text;
            RootType rootType;
            Object value2 = node.getValue();
            VirtualFile virtualFile = null;
            if (value2 instanceof RootType) {
                rootType = (RootType)value2;
            } else {
                virtualFile = node.getVirtualFile();
                if (virtualFile == null || !virtualFile.isValid()) {
                    return;
                }
                rootType = ScratchFileService.getInstance().getRootType(virtualFile);
                if (rootType == null) {
                    return;
                }
            }
            ScratchFileService scratchFileService = ScratchFileService.getInstance();
            VirtualFile rootFile = LocalFileSystem.getInstance().findFileByPath(scratchFileService.getRootPath(rootType));
            Icon icon2 = null;
            if (virtualFile == null || virtualFile.isDirectory() && virtualFile.equals(rootFile)) {
                text = rootType.getDisplayName();
            } else {
                Project project = Objects.requireNonNull(node.getProject());
                text = rootType.substituteName(project, virtualFile);
                icon2 = rootType.substituteIcon(project, virtualFile);
            }
            if (text != null) {
                data2.clearText();
                data2.addText(text, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                data2.setPresentableText(text);
            }
            if (icon2 != null) {
                data2.setIcon(icon2);
            }
        }

        @Override
        public void decorate(PackageDependenciesNode node, ColoredTreeCellRenderer cellRenderer) {
        }

        @Nullable
        public Icon getIcon(@NotNull VirtualFile file2, @Iconable.IconFlags int flags, @Nullable Project project) {
            if (project == null || file2.isDirectory()) {
                return null;
            }
            RootType rootType = ScratchFileService.getInstance().getRootType(file2);
            if (rootType == null) {
                return null;
            }
            return (Icon)ObjectUtils.notNull((Object)rootType.substituteIcon(project, file2), (Object)AllIcons.FileTypes.Text);
        }

        @Override
        @Nullable
        public String getEditorTabTitle(@NotNull Project project, @NotNull VirtualFile file2) {
            RootType rootType = ScratchFileService.getInstance().getRootType(file2);
            if (rootType == null) {
                return null;
            }
            return rootType.substituteName(project, file2);
        }
    }

    public static class Highlighter
    implements SyntaxHighlighterProvider {
        @Nullable
        public SyntaxHighlighter create(@NotNull FileType fileType, @Nullable Project project, @Nullable VirtualFile file2) {
            if (project == null || file2 == null) {
                return null;
            }
            if (!ScratchUtil.isScratch(file2)) {
                return null;
            }
            Language language = LanguageUtil.getLanguageForPsi((Project)project, (VirtualFile)file2);
            return language == null ? null : SyntaxHighlighterFactory.getSyntaxHighlighter((Language)language, (Project)project, (VirtualFile)file2);
        }
    }

    public static class Substitutor
    extends LanguageSubstitutor {
        @Nullable
        public Language getLanguage(@NotNull VirtualFile file2, @NotNull Project project) {
            return Substitutor.substituteLanguage(project, file2);
        }

        @Nullable
        public static Language substituteLanguage(@NotNull Project project, @NotNull VirtualFile file2) {
            RootType rootType = ScratchFileService.getInstance().getRootType(file2);
            if (rootType == null) {
                return null;
            }
            Language language = rootType.substituteLanguage(project, file2);
            Language adjusted = language != null ? language : ScratchFileServiceImpl.getLanguageByFileName(file2);
            Language result2 = adjusted != null && adjusted != PlainTextLanguage.INSTANCE ? LanguageSubstitutors.getInstance().substituteLanguage(adjusted, file2, project) : adjusted;
            return result2 == Language.ANY ? null : result2;
        }
    }

    private static class MyLanguages
    extends PerFileMappingsBase<String> {
        private MyLanguages() {
        }

        @Override
        @NotNull
        public List<String> getAvailableValues() {
            return ContainerUtil.map((Collection)LanguageUtil.getFileLanguages(), Language::getID);
        }

        @Override
        @Nullable
        protected String serialize(String languageID) {
            return languageID;
        }

        @Override
        @Nullable
        protected String handleUnknownMapping(VirtualFile file2, String value2) {
            return PlainTextLanguage.INSTANCE.getID();
        }
    }
}

