/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.ide.util.treeView.TreeAnchorizer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiTreeAnchorizer
extends TreeAnchorizer {
    @NotNull
    public Object createAnchor(@NotNull Object element2) {
        if (element2 instanceof PsiElement) {
            PsiElement psi = (PsiElement)element2;
            return ReadAction.compute(() -> {
                if (!psi.isValid()) {
                    return psi;
                }
                return SmartPointerManager.getInstance((Project)psi.getProject()).createSmartPsiElementPointer(psi);
            });
        }
        return super.createAnchor(element2);
    }

    @Nullable
    public Object retrieveElement(@NotNull Object pointer) {
        if (pointer instanceof SmartPsiElementPointer) {
            return ReadAction.compute(() -> ((SmartPsiElementPointer)pointer).getElement());
        }
        return super.retrieveElement(pointer);
    }

    public void freeAnchor(Object element2) {
        if (element2 instanceof SmartPsiElementPointer) {
            ApplicationManager.getApplication().runReadAction(() -> {
                SmartPsiElementPointer pointer = (SmartPsiElementPointer)element2;
                Project project = pointer.getProject();
                if (!project.isDisposed()) {
                    SmartPointerManager.getInstance((Project)project).removePointer(pointer);
                }
            });
        }
    }
}

