/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.ProjectViewModuleNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PlatformIcons;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class ModuleListNode
extends ProjectViewNode<Module> {
    public ModuleListNode(Project project, @NotNull Module value2, ViewSettings viewSettings) {
        super(project, (Object)value2, viewSettings);
    }

    @NotNull
    public Collection<AbstractTreeNode<?>> getChildren() {
        Module module = (Module)this.getValue();
        Module[] deps = ModuleRootManager.getInstance((Module)module).getDependencies(true);
        ArrayList children2 = new ArrayList();
        for (Module dependency : deps) {
            children2.add((AbstractTreeNode<?>)new ProjectViewModuleNode(this.myProject, dependency, this.getSettings()){

                @Override
                protected boolean showModuleNameInBold() {
                    return false;
                }
            });
        }
        return children2;
    }

    public String getTestPresentation() {
        return "Modules";
    }

    public boolean contains(@NotNull VirtualFile file2) {
        return this.someChildContainsFile(file2);
    }

    public void update(@NotNull PresentationData presentation2) {
        presentation2.setPresentableText(LangBundle.message((String)"presentable.text.module.dependencies", (Object[])new Object[0]));
        presentation2.setIcon(PlatformIcons.CLOSED_MODULE_GROUP_ICON);
    }

    public boolean isAlwaysExpand() {
        return true;
    }
}

