/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.ModuleGroup;
import com.intellij.ide.projectView.impl.ProjectViewPane;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.module.LoadedModuleDescription;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleDescription;
import com.intellij.openapi.module.ModuleGrouper;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.OptionalLong;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractProjectNode
extends ProjectViewNode<Project> {
    protected AbstractProjectNode(Project project, @NotNull Project value2, ViewSettings viewSettings) {
        super(project, (Object)value2, viewSettings);
    }

    @NotNull
    protected Collection<AbstractTreeNode<?>> modulesAndGroups(@NotNull Collection<? extends ModuleDescription> modules2) {
        if (this.getSettings().isFlattenModules()) {
            return ContainerUtil.mapNotNull(modules2, moduleDescription -> {
                try {
                    return this.createModuleNode((ModuleDescription)moduleDescription);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    LOG.error((Throwable)e);
                    return null;
                }
            });
        }
        LinkedHashSet<String> topLevelGroups = new LinkedHashSet<String>();
        LinkedHashSet<? extends ModuleDescription> nonGroupedModules = new LinkedHashSet<ModuleDescription>(modules2);
        List commonGroupsPath = null;
        for (ModuleDescription moduleDescription2 : modules2) {
            List list2 = ModuleGrouper.instanceFor((Project)this.myProject).getGroupPath(moduleDescription2);
            if (list2.isEmpty()) continue;
            String topLevelGroupName = (String)list2.get(0);
            topLevelGroups.add(topLevelGroupName);
            nonGroupedModules.remove(moduleDescription2);
            if (commonGroupsPath == null) {
                commonGroupsPath = list2;
                continue;
            }
            int commonPartLen = Math.min(commonGroupsPath.size(), list2.size());
            OptionalLong firstDifference = StreamEx.zip(commonGroupsPath.subList(0, commonPartLen), list2.subList(0, commonPartLen), String::equals).indexOf((Object)false);
            if (!firstDifference.isPresent()) continue;
            commonGroupsPath = commonGroupsPath.subList(0, (int)firstDifference.getAsLong());
        }
        ArrayList result2 = new ArrayList();
        try {
            if (modules2.size() > 1) {
                if (commonGroupsPath != null && !commonGroupsPath.isEmpty()) {
                    result2.add(this.createModuleGroupNode(new ModuleGroup(commonGroupsPath)));
                } else {
                    for (String string : topLevelGroups) {
                        result2.add(this.createModuleGroupNode(new ModuleGroup(Collections.singletonList(string))));
                    }
                }
                for (ModuleDescription moduleDescription3 : nonGroupedModules) {
                    ContainerUtil.addIfNotNull(result2, this.createModuleNode(moduleDescription3));
                }
            } else {
                ContainerUtil.addIfNotNull(result2, this.createModuleNode((ModuleDescription)ContainerUtil.getFirstItem(modules2)));
            }
        }
        catch (ProcessCanceledException processCanceledException) {
            throw processCanceledException;
        }
        catch (Exception exception) {
            LOG.error((Throwable)exception);
            return new ArrayList();
        }
        return result2;
    }

    @NotNull
    protected abstract AbstractTreeNode<?> createModuleGroup(@NotNull Module var1) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException;

    @Nullable
    private AbstractTreeNode<?> createModuleNode(ModuleDescription moduleDescription) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        if (moduleDescription instanceof LoadedModuleDescription) {
            return this.createModuleGroup(((LoadedModuleDescription)moduleDescription).getModule());
        }
        if (moduleDescription instanceof UnloadedModuleDescription) {
            return this.createUnloadedModuleNode((UnloadedModuleDescription)moduleDescription);
        }
        return null;
    }

    protected AbstractTreeNode<?> createUnloadedModuleNode(UnloadedModuleDescription moduleDescription) {
        return null;
    }

    @NotNull
    protected abstract AbstractTreeNode<?> createModuleGroupNode(@NotNull ModuleGroup var1) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException;

    public void update(@NotNull PresentationData presentation2) {
        presentation2.setIcon(PlatformIcons.PROJECT_ICON);
        presentation2.setPresentableText(this.getProject().getName());
    }

    public String getTestPresentation() {
        return "Project";
    }

    public boolean contains(@NotNull VirtualFile vFile) {
        assert (this.myProject != null);
        return ProjectViewPane.canBeSelectedInProjectView(this.myProject, vFile);
    }
}

