/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.TitledHandler;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleWithNameAlreadyExists;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.rename.RenameHandler;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenameModuleHandler
implements RenameHandler,
TitledHandler {
    private static final Logger LOG = Logger.getInstance(RenameModuleHandler.class);

    public boolean isAvailableOnDataContext(@NotNull DataContext dataContext) {
        Module module = (Module)LangDataKeys.MODULE_CONTEXT.getData(dataContext);
        return module != null;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2, DataContext dataContext) {
        LOG.assertTrue(false);
    }

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements2, @NotNull DataContext dataContext) {
        Module module = (Module)LangDataKeys.MODULE_CONTEXT.getData(dataContext);
        LOG.assertTrue(module != null);
        Messages.showInputDialog((Project)project, (String)IdeBundle.message((String)"prompt.enter.new.module.name", (Object[])new Object[0]), (String)IdeBundle.message((String)"title.rename.module", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon(), (String)module.getName(), (InputValidator)new MyInputValidator(project, module));
    }

    public String getActionTitle() {
        return RefactoringBundle.message((String)"rename.module.title");
    }

    private static class MyInputValidator
    implements InputValidator {
        private final Project myProject;
        private final Module myModule;

        MyInputValidator(Project project, Module module) {
            this.myProject = project;
            this.myModule = module;
        }

        public boolean checkInput(String inputString) {
            return inputString != null && inputString.length() > 0;
        }

        public boolean canClose(String inputString) {
            String oldName = this.myModule.getName();
            ModifiableModuleModel modifiableModel = this.renameModule(inputString);
            if (modifiableModel == null) {
                return false;
            }
            CommandProcessor.getInstance().executeCommand(this.myProject, () -> ApplicationManager.getApplication().runWriteAction(() -> modifiableModel.commit()), IdeBundle.message((String)"command.renaming.module", (Object[])new Object[]{oldName}), null);
            return true;
        }

        @Nullable
        private ModifiableModuleModel renameModule(String inputString) {
            ModifiableModuleModel modifiableModel = ModuleManager.getInstance((Project)this.myProject).getModifiableModel();
            try {
                modifiableModel.renameModule(this.myModule, inputString);
            }
            catch (ModuleWithNameAlreadyExists moduleWithNameAlreadyExists) {
                Messages.showErrorDialog((Project)this.myProject, (String)IdeBundle.message((String)"error.module.already.exists", (Object[])new Object[]{inputString}), (String)IdeBundle.message((String)"title.rename.module", (Object[])new Object[0]));
                return null;
            }
            return modifiableModel;
        }
    }
}

