/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ProjectViewPaneSelectionHelper {
    private static final ExtensionPointName<ProjectViewPaneSelectionHelper> EP_NAME = ExtensionPointName.create((String)"com.intellij.projectViewPaneSelectionHelper");

    @Nullable
    protected abstract List<? extends TreePath> computeAdjustedPaths(@NotNull SelectionDescriptor var1);

    @NotNull
    static List<? extends TreePath> getAdjustedPaths(@NotNull SelectionDescriptor selectionDescriptor) {
        for (ProjectViewPaneSelectionHelper helper : EP_NAME.getExtensionList()) {
            List<? extends TreePath> adjustedPaths = helper.computeAdjustedPaths(selectionDescriptor);
            if (adjustedPaths == null) continue;
            return adjustedPaths;
        }
        return selectionDescriptor.originalTreePaths;
    }

    public static class SelectionDescriptor {
        @Nullable
        public final PsiElement targetPsiElement;
        @Nullable
        public final VirtualFile targetVirtualFile;
        @NotNull
        public final List<TreePath> originalTreePaths;

        public SelectionDescriptor(@Nullable PsiElement targetPsiElement, @Nullable VirtualFile targetVirtualFile, @NotNull List<TreePath> originalTreePaths) {
            this.targetPsiElement = targetPsiElement;
            this.targetVirtualFile = targetVirtualFile;
            this.originalTreePaths = ContainerUtil.immutableList(originalTreePaths);
        }
    }
}

