/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.newui.HiDPIPluginLogoIcon;
import com.intellij.ide.plugins.newui.PluginLogo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.ui.JBColor;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginLogoApi {
    private final int myWidth;
    private final int myHeight;
    private final Logger myLogger;

    @NotNull
    public static Icon getIcon(@NotNull IdeaPluginDescriptor descriptor2, int width, int height, @Nullable Logger logger) {
        return new PluginLogoApi(width, height, logger).getIcon(descriptor2);
    }

    private PluginLogoApi(int width, int height, @Nullable Logger logger) {
        this.myWidth = width;
        this.myHeight = height;
        this.myLogger = logger;
    }

    @NotNull
    private Icon getIcon(@NotNull IdeaPluginDescriptor descriptor2) {
        Path path = descriptor2.getPluginPath();
        if (path == null) {
            return this.getDefaultIcon();
        }
        if (Files.isDirectory(path, new LinkOption[0])) {
            Icon icon2;
            if (System.getProperty("idea.required.plugins.id") != null && (icon2 = this.tryLoadDirIcon(path.resolve("classes"))) != null) {
                return icon2;
            }
            icon2 = this.tryLoadDirIcon(path);
            if (icon2 != null) {
                return icon2;
            }
            Path libFile = path.resolve("lib");
            if (!Files.isDirectory(libFile, new LinkOption[0])) {
                return this.getDefaultIcon();
            }
            Object[] files2 = libFile.toFile().listFiles();
            if (ArrayUtil.isEmpty((Object[])files2)) {
                return this.getDefaultIcon();
            }
            for (Object file2 : files2) {
                Icon dirIcon = this.tryLoadDirIcon(((File)file2).toPath());
                if (dirIcon != null) {
                    return dirIcon;
                }
                Icon jarIcon = this.tryLoadJarIcon((File)file2);
                if (jarIcon == null) continue;
                return jarIcon;
            }
        } else {
            Icon icon3 = this.tryLoadJarIcon(path.toFile());
            if (icon3 != null) {
                return icon3;
            }
        }
        return this.getDefaultIcon();
    }

    @Nullable
    private Icon tryLoadDirIcon(@NotNull Path path) {
        boolean light = JBColor.isBright();
        Icon icon2 = this.tryLoadIcon(path, light);
        return icon2 == null ? this.tryLoadIcon(path, !light) : icon2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private Icon tryLoadJarIcon(@NotNull File path) {
        if (!FileUtilRt.isJarOrZip((File)path)) return null;
        if (!path.exists()) {
            return null;
        }
        try (ZipFile zipFile = new ZipFile(path);){
            boolean light = JBColor.isBright();
            Icon icon3 = this.tryLoadIcon(zipFile, light);
            Icon icon2 = icon3 == null ? this.tryLoadIcon(zipFile, !light) : icon3;
            return icon2;
        }
        catch (Exception e) {
            if (this.myLogger == null) return null;
            this.myLogger.error((Throwable)e);
            return null;
        }
    }

    @Nullable
    private Icon tryLoadIcon(@NotNull Path dirFile, boolean light) {
        try {
            Path iconFile = dirFile.resolve(PluginLogo.getIconFileName(light));
            return Files.size(iconFile) > 0L ? this.loadFileIcon(Files.newInputStream(iconFile, new OpenOption[0])) : null;
        }
        catch (NoSuchFileException ignore) {
            return null;
        }
        catch (IOException e) {
            if (this.myLogger != null) {
                this.myLogger.error((Throwable)e);
            }
            return null;
        }
    }

    @Nullable
    private Icon tryLoadIcon(@NotNull ZipFile zipFile, boolean light) {
        try {
            ZipEntry iconEntry = zipFile.getEntry(PluginLogo.getIconFileName(light));
            return iconEntry == null ? null : this.loadFileIcon(zipFile.getInputStream(iconEntry));
        }
        catch (IOException e) {
            if (this.myLogger != null) {
                this.myLogger.error((Throwable)e);
            }
            return null;
        }
    }

    @NotNull
    private Icon loadFileIcon(@NotNull InputStream stream) throws IOException {
        return HiDPIPluginLogoIcon.loadSVG(stream, this.myWidth, this.myHeight);
    }

    private Icon getDefaultIcon() {
        block3: {
            URL url;
            if (AllIcons.Plugins.PluginLogo instanceof IconLoader.CachedImageIcon && (url = ((IconLoader.CachedImageIcon)AllIcons.Plugins.PluginLogo).getURL()) != null) {
                try {
                    return HiDPIPluginLogoIcon.loadSVG(url.openStream(), this.myWidth, this.myHeight);
                }
                catch (IOException e) {
                    if (this.myLogger == null) break block3;
                    this.myLogger.error((Throwable)e);
                }
            }
        }
        return AllIcons.Plugins.PluginLogo;
    }
}

