/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.ClassPathXmlPathResolver;
import com.intellij.ide.plugins.DescriptorListLoadingContext;
import com.intellij.ide.plugins.DescriptorLoadingContext;
import com.intellij.ide.plugins.DisabledPluginsState;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PathBasedJdomXIncluder;
import com.intellij.ide.plugins.PluginLoadingResult;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginXmlPathResolver;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.SafeJdomFactory;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.serialization.SerializationException;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.PlatformUtils;
import com.intellij.util.io.Decompressor;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class PluginDescriptorLoader {
    @ApiStatus.Internal
    @Nullable
    public static IdeaPluginDescriptorImpl loadDescriptor(@NotNull Path file2, boolean isBundled, @NotNull DescriptorListLoadingContext parentContext) {
        try (DescriptorLoadingContext context = new DescriptorLoadingContext(parentContext, isBundled, false, PathBasedJdomXIncluder.DEFAULT_PATH_RESOLVER);){
            IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = PluginDescriptorLoader.loadDescriptorFromFileOrDir(file2, "plugin.xml", context, Files.isDirectory(file2, new LinkOption[0]));
            return ideaPluginDescriptorImpl;
        }
    }

    @Nullable
    static IdeaPluginDescriptorImpl loadDescriptorFromDir(@NotNull Path file2, @NotNull String descriptorRelativePath, @Nullable Path pluginPath, @NotNull DescriptorLoadingContext context) {
        Path descriptorFile = file2.resolve(descriptorRelativePath);
        try {
            IdeaPluginDescriptorImpl descriptor2 = new IdeaPluginDescriptorImpl(pluginPath == null ? file2 : pluginPath, descriptorFile.getParent(), context.isBundled);
            Element element2 = JDOMUtil.load((Path)descriptorFile, (SafeJdomFactory)context.parentContext.getXmlFactory());
            descriptor2.readExternal(element2, context.pathResolver, context.parentContext, descriptor2);
            return descriptor2;
        }
        catch (NoSuchFileException e) {
            return null;
        }
        catch (SerializationException | IOException | JDOMException e) {
            if (context.isEssential) {
                ExceptionUtil.rethrow((Throwable)e);
            }
            context.parentContext.result.reportCannotLoad(file2, (Exception)e);
        }
        catch (Throwable e) {
            if (context.isEssential) {
                ExceptionUtil.rethrow((Throwable)e);
            }
            DescriptorListLoadingContext.LOG.warn("Cannot load " + descriptorFile, e);
        }
        return null;
    }

    @Nullable
    static IdeaPluginDescriptorImpl loadDescriptorFromJar(@NotNull Path file2, @NotNull String fileName, @NotNull PathBasedJdomXIncluder.PathResolver<?> pathResolver, @NotNull DescriptorLoadingContext context, @Nullable Path pluginPath) {
        SafeJdomFactory factory2 = context.parentContext.getXmlFactory();
        try {
            Element element2;
            Path metaInf = context.open(file2).getPath("/META-INF", new String[0]);
            try {
                element2 = JDOMUtil.load((Path)metaInf.resolve(fileName), (SafeJdomFactory)factory2);
            }
            catch (NoSuchFileException ignore) {
                return null;
            }
            IdeaPluginDescriptorImpl descriptor2 = new IdeaPluginDescriptorImpl(pluginPath == null ? file2 : pluginPath, metaInf, context.isBundled);
            if (descriptor2.readExternal(element2, pathResolver, context.parentContext, descriptor2)) {
                descriptor2.jarFiles = Collections.singletonList(descriptor2.getPluginPath());
            }
            return descriptor2;
        }
        catch (InvalidDataException | SerializationException e) {
            if (context.isEssential) {
                ExceptionUtil.rethrow((Throwable)e);
            }
            context.parentContext.result.reportCannotLoad(file2, (Exception)e);
        }
        catch (Throwable e) {
            if (context.isEssential) {
                ExceptionUtil.rethrow((Throwable)e);
            }
            DescriptorListLoadingContext.LOG.info("Cannot load " + file2 + "!/META-INF/" + fileName, e);
        }
        return null;
    }

    @Nullable
    static IdeaPluginDescriptorImpl loadDescriptorFromFileOrDir(@NotNull Path file2, @NotNull String pathName, @NotNull DescriptorLoadingContext context, boolean isDirectory) {
        if (isDirectory) {
            return PluginDescriptorLoader.loadDescriptorFromDirAndNormalize(file2, pathName, context);
        }
        if (StringUtilRt.endsWithIgnoreCase((CharSequence)file2.getFileName().toString(), (CharSequence)".jar")) {
            return PluginDescriptorLoader.loadDescriptorFromJar(file2, pathName, context.pathResolver, context, null);
        }
        return null;
    }

    @Nullable
    private static IdeaPluginDescriptorImpl loadDescriptorFromDirAndNormalize(@NotNull Path file2, @NotNull String pathName, @NotNull DescriptorLoadingContext context) {
        String descriptorRelativePath = "META-INF/" + pathName;
        IdeaPluginDescriptorImpl descriptor2 = PluginDescriptorLoader.loadDescriptorFromDir(file2, descriptorRelativePath, null, context);
        if (descriptor2 != null) {
            return descriptor2;
        }
        ArrayList<Path> pluginJarFiles = new ArrayList<Path>();
        ArrayList<Path> dirs = new ArrayList<Path>();
        if (!PluginDescriptorLoader.collectPluginDirectoryContents(file2, pluginJarFiles, dirs)) {
            return null;
        }
        if (!pluginJarFiles.isEmpty()) {
            PluginXmlPathResolver pathResolver = new PluginXmlPathResolver(pluginJarFiles, context);
            for (Path jarFile : pluginJarFiles) {
                descriptor2 = PluginDescriptorLoader.loadDescriptorFromJar(jarFile, pathName, pathResolver, context, file2);
                if (descriptor2 == null) continue;
                descriptor2.jarFiles = pluginJarFiles;
                return descriptor2;
            }
        }
        for (Path dir : dirs) {
            IdeaPluginDescriptorImpl otherDescriptor = PluginDescriptorLoader.loadDescriptorFromDir(dir, descriptorRelativePath, file2, context);
            if (otherDescriptor == null) continue;
            if (descriptor2 != null) {
                DescriptorListLoadingContext.LOG.info("Cannot load " + file2 + " because two or more plugin.xml's detected");
                return null;
            }
            descriptor2 = otherDescriptor;
        }
        return descriptor2;
    }

    static boolean collectPluginDirectoryContents(@NotNull Path file2, @NotNull List<Path> pluginJarFiles, @NotNull List<Path> dirs) {
        try (DirectoryStream<Path> s = Files.newDirectoryStream(file2.resolve("lib"));){
            for (Path childFile : s) {
                if (Files.isDirectory(childFile, new LinkOption[0])) {
                    dirs.add(childFile);
                    continue;
                }
                String path = childFile.toString();
                if (!StringUtilRt.endsWithIgnoreCase((CharSequence)path, (CharSequence)".jar") && !StringUtilRt.endsWithIgnoreCase((CharSequence)path, (CharSequence)".zip")) continue;
                pluginJarFiles.add(childFile);
            }
        }
        catch (IOException e) {
            return false;
        }
        if (!pluginJarFiles.isEmpty()) {
            PluginDescriptorLoader.putMoreLikelyPluginJarsFirst(file2, pluginJarFiles);
        }
        return true;
    }

    private static void putMoreLikelyPluginJarsFirst(@NotNull Path pluginDir, @NotNull List<Path> filesInLibUnderPluginDir) {
        String pluginDirName = pluginDir.getFileName().toString();
        filesInLibUnderPluginDir.sort((o1, o2) -> {
            boolean o1StartsWithNeededName;
            boolean o1IsVersioned;
            boolean o1StartsWithResources;
            String o2Name = o2.getFileName().toString();
            String o1Name = o1.getFileName().toString();
            boolean o2StartsWithResources = o2Name.startsWith("resources");
            if (o2StartsWithResources != (o1StartsWithResources = o1Name.startsWith("resources"))) {
                return o2StartsWithResources ? -1 : 1;
            }
            boolean o2IsVersioned = PluginDescriptorLoader.fileNameIsLikeVersionedLibraryName(o2Name);
            if (o2IsVersioned != (o1IsVersioned = PluginDescriptorLoader.fileNameIsLikeVersionedLibraryName(o1Name))) {
                return o2IsVersioned ? -1 : 1;
            }
            boolean o2StartsWithNeededName = StringUtil.startsWithIgnoreCase((String)o2Name, (String)pluginDirName);
            if (o2StartsWithNeededName != (o1StartsWithNeededName = StringUtil.startsWithIgnoreCase((String)o1Name, (String)pluginDirName))) {
                return o2StartsWithNeededName ? 1 : -1;
            }
            return o1Name.length() - o2Name.length();
        });
    }

    private static boolean fileNameIsLikeVersionedLibraryName(@NotNull String name) {
        int i2 = name.lastIndexOf(45);
        if (i2 == -1) {
            return false;
        }
        if (i2 + 1 < name.length()) {
            char c = name.charAt(i2 + 1);
            if (Character.isDigit(c)) {
                return true;
            }
            return (c == 'm' || c == 'M') && i2 + 2 < name.length() && Character.isDigit(name.charAt(i2 + 2));
        }
        return false;
    }

    private static void loadDescriptorsFromDir(@NotNull Path dir, boolean isBundled, @NotNull DescriptorListLoadingContext context) throws ExecutionException, InterruptedException {
        ArrayList<Future<IdeaPluginDescriptorImpl>> tasks = new ArrayList<Future<IdeaPluginDescriptorImpl>>();
        ExecutorService executorService = context.getExecutorService();
        try {
            Throwable throwable = null;
            try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(dir);){
                for (Path file2 : dirStream) {
                    tasks.add(executorService.submit(() -> PluginDescriptorLoader.loadDescriptor(file2, isBundled, context)));
                }
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
        }
        catch (IOException ignore) {
            return;
        }
        for (Future future2 : tasks) {
            IdeaPluginDescriptorImpl descriptor2 = (IdeaPluginDescriptorImpl)future2.get();
            if (descriptor2 == null) continue;
            context.result.add(descriptor2, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static IdeaPluginDescriptorImpl loadDescriptorFromResource(@NotNull URL resource, @NotNull String pathName, @NotNull DescriptorLoadingContext loadingContext) {
        try {
            if ("file".equals(resource.getProtocol())) {
                Path file2 = Paths.get(StringUtil.trimEnd((String)FileUtilRt.toSystemIndependentName((String)PluginDescriptorLoader.urlToFile(resource).toString()), (String)pathName), new String[0]).getParent();
                IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = PluginDescriptorLoader.loadDescriptorFromFileOrDir(file2, pathName, loadingContext, Files.isDirectory(file2, new LinkOption[0]));
                return ideaPluginDescriptorImpl;
            }
            if ("jar".equals(resource.getProtocol())) {
                String path = resource.getFile();
                Path file3 = PluginDescriptorLoader.urlToFile(path.substring(0, path.indexOf("!/")));
                Path pluginPath = null;
                if (file3.getParent() != null && file3.getParent().endsWith("lib")) {
                    pluginPath = file3.getParent().getParent();
                }
                IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = PluginDescriptorLoader.loadDescriptorFromJar(file3, pathName, loadingContext.pathResolver, loadingContext, pluginPath);
                return ideaPluginDescriptorImpl;
            }
            IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = null;
            return ideaPluginDescriptorImpl;
        }
        catch (Throwable e) {
            if (loadingContext.isEssential) {
                ExceptionUtil.rethrow((Throwable)e);
            }
            DescriptorListLoadingContext.LOG.info("Cannot load " + resource, e);
            IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = null;
            return ideaPluginDescriptorImpl;
        }
        finally {
            loadingContext.close();
        }
    }

    @NotNull
    private static Path urlToFile(@NotNull String url) throws URISyntaxException {
        try {
            return Paths.get(new URI(url));
        }
        catch (URISyntaxException e) {
            if (url.indexOf(32) > 0) {
                return Paths.get(new URI(StringUtil.replace((String)url, (String)" ", (String)"%20")));
            }
            throw e;
        }
    }

    @NotNull
    private static Path urlToFile(URL url) throws URISyntaxException, MalformedURLException {
        try {
            return Paths.get(url.toURI());
        }
        catch (URISyntaxException e) {
            String str = url.toString();
            if (str.indexOf(32) > 0) {
                return Paths.get(new URL(StringUtil.replace((String)str, (String)" ", (String)"%20")).toURI());
            }
            throw e;
        }
    }

    private static void loadDescriptorsFromProperty(@NotNull PluginLoadingResult result2, @NotNull DescriptorListLoadingContext context) {
        String pathProperty = System.getProperty("plugin.path");
        if (pathProperty == null) {
            return;
        }
        StringTokenizer t = new StringTokenizer(pathProperty, File.pathSeparator + ",");
        while (t.hasMoreTokens()) {
            String s = t.nextToken();
            IdeaPluginDescriptorImpl descriptor2 = PluginDescriptorLoader.loadDescriptor(Paths.get(s, new String[0]), false, context);
            if (descriptor2 == null) continue;
            result2.add(descriptor2, true);
        }
    }

    @NotNull
    static DescriptorListLoadingContext loadDescriptors() {
        int flags = 5;
        boolean isUnitTestMode = PluginManagerCore.isUnitTestMode;
        if (isUnitTestMode) {
            flags |= 2;
        }
        if (isUnitTestMode || PluginManagerCore.isRunningFromSources()) {
            flags |= 8;
        }
        PluginLoadingResult result2 = PluginManagerCore.createLoadingResult(null);
        try (DescriptorListLoadingContext context = new DescriptorListLoadingContext(flags, DisabledPluginsState.disabledPlugins(), result2);){
            PluginDescriptorLoader.loadBundledDescriptorsAndDescriptorsFromDir(context, Paths.get(PathManager.getPluginsPath(), new String[0]));
            PluginDescriptorLoader.loadDescriptorsFromProperty(result2, context);
            if (isUnitTestMode && result2.enabledPluginCount() <= 1) {
                context.usePluginClassLoader = true;
                PluginDescriptorLoader.loadDescriptorsFromDir(context.getBundledPluginsPath(), true, context);
            }
        }
        context.result.finishLoading();
        return context;
    }

    static void loadBundledDescriptorsAndDescriptorsFromDir(DescriptorListLoadingContext context, Path dir) throws ExecutionException, InterruptedException {
        ClassLoader classLoader = PluginManagerCore.class.getClassLoader();
        LinkedHashMap<URL, String> urlsFromClassPath = new LinkedHashMap<URL, String>();
        URL platformPluginURL = PluginDescriptorLoader.computePlatformPluginUrlAndCollectPluginUrls(classLoader, urlsFromClassPath);
        try (DescriptorLoadingContext loadingContext = new DescriptorLoadingContext(context, true, true, new ClassPathXmlPathResolver(classLoader));){
            PluginDescriptorLoader.loadDescriptorsFromClassPath(urlsFromClassPath, loadingContext, platformPluginURL);
        }
        PluginDescriptorLoader.loadDescriptorsFromDir(dir, false, context);
        if (context.loadBundledPlugins) {
            PluginDescriptorLoader.loadDescriptorsFromDir(context.getBundledPluginsPath(), true, context);
        }
    }

    static void loadDescriptorsFromClassPath(@NotNull Map<URL, String> urls, @NotNull DescriptorLoadingContext context, @Nullable URL platformPluginURL) throws ExecutionException, InterruptedException {
        if (urls.isEmpty()) {
            return;
        }
        ArrayList<Future<IdeaPluginDescriptorImpl>> tasks = new ArrayList<Future<IdeaPluginDescriptorImpl>>(urls.size());
        ExecutorService executorService = context.parentContext.getExecutorService();
        for (Map.Entry<URL, String> entry : urls.entrySet()) {
            URL uRL = entry.getKey();
            tasks.add(executorService.submit(() -> PluginDescriptorLoader.loadDescriptorFromResource(url, (String)entry.getValue(), context.copy(url.equals(platformPluginURL)))));
        }
        PluginLoadingResult result2 = context.parentContext.result;
        for (Future future2 : tasks) {
            String id2;
            IdeaPluginDescriptorImpl descriptor2 = (IdeaPluginDescriptorImpl)future2.get();
            if (descriptor2 == null || PlatformUtils.isAndroidStudio() && ((id2 = descriptor2.getPluginId().getIdString()).equals("org.jetbrains.idea.maven") || id2.equals("org.jetbrains.plugins.gradle.maven"))) continue;
            if (!PluginManagerCore.usePluginClassLoader) {
                descriptor2.setUseCoreClassLoader();
            }
            result2.add(descriptor2, false);
        }
    }

    @Nullable
    private static URL computePlatformPluginUrlAndCollectPluginUrls(@NotNull ClassLoader loader, @NotNull Map<URL, String> urls) {
        String platformPrefix = System.getProperty("idea.platform.prefix");
        URL result2 = null;
        if (platformPrefix != null) {
            if ((platformPrefix.equals("idea") || platformPrefix.equals("WebStorm")) && !PluginManagerCore.isRunningFromSources()) {
                urls.put(loader.getResource("META-INF/plugin.xml"), "plugin.xml");
                return null;
            }
            String fileName = platformPrefix + "Plugin.xml";
            URL resource = loader.getResource("META-INF/" + fileName);
            if (resource != null) {
                urls.put(resource, fileName);
                result2 = resource;
            }
        }
        PluginDescriptorLoader.collectPluginFilesInClassPath(loader, urls);
        return result2;
    }

    static void collectPluginFilesInClassPath(@NotNull ClassLoader loader, @NotNull Map<URL, String> urls) {
        try {
            Enumeration<URL> enumeration = loader.getResources("META-INF/plugin.xml");
            while (enumeration.hasMoreElements()) {
                urls.put(enumeration.nextElement(), "plugin.xml");
            }
        }
        catch (IOException e) {
            PluginManagerCore.getLogger().info((Throwable)e);
        }
    }

    @ApiStatus.Internal
    @NotNull
    public static List<IdeaPluginDescriptorImpl> loadUncachedDescriptors() {
        return PluginDescriptorLoader.loadDescriptors().result.getEnabledPlugins();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static IdeaPluginDescriptorImpl loadDescriptorFromArtifact(@NotNull Path file2, @Nullable BuildNumber buildNumber) throws IOException {
        DescriptorListLoadingContext parentContext = new DescriptorListLoadingContext(4, DisabledPluginsState.disabledPlugins(), PluginManagerCore.createLoadingResult(buildNumber));
        try (DescriptorLoadingContext context = new DescriptorLoadingContext(parentContext, false, false, PathBasedJdomXIncluder.DEFAULT_PATH_RESOLVER);){
            IdeaPluginDescriptorImpl descriptor2 = PluginDescriptorLoader.loadDescriptorFromFileOrDir(file2, "plugin.xml", context, false);
            if (descriptor2 == null && file2.getFileName().toString().endsWith(".zip")) {
                File outputDir = FileUtil.createTempDirectory((String)"plugin", (String)"");
                try {
                    new Decompressor.Zip(file2.toFile()).extract(outputDir);
                    File[] files2 = outputDir.listFiles();
                    if (files2 != null && files2.length == 1) {
                        descriptor2 = PluginDescriptorLoader.loadDescriptorFromFileOrDir(files2[0].toPath(), "plugin.xml", context, true);
                    }
                }
                finally {
                    FileUtil.delete((File)outputDir);
                }
            }
            IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = descriptor2;
            return ideaPluginDescriptorImpl;
        }
    }

    @Nullable
    public static IdeaPluginDescriptorImpl tryLoadFullDescriptor(@NotNull IdeaPluginDescriptorImpl descriptor2) {
        PathBasedJdomXIncluder.PathResolver<?> resolver = PluginDescriptorLoader.createPathResolverForPlugin(descriptor2, null);
        return PluginManager.loadDescriptor(descriptor2.getPluginPath(), "plugin.xml", Collections.emptySet(), descriptor2.isBundled(), resolver);
    }

    @NotNull
    static PathBasedJdomXIncluder.PathResolver<?> createPathResolverForPlugin(@NotNull IdeaPluginDescriptorImpl descriptor2, @Nullable DescriptorLoadingContext context) {
        PathBasedJdomXIncluder.PathResolver<Path> resolver;
        if (PluginManagerCore.isRunningFromSources() && descriptor2.getPluginPath().getFileSystem().equals(FileSystems.getDefault()) && descriptor2.getPluginPath().toString().contains("out/classes")) {
            return new ClassPathXmlPathResolver(descriptor2.getPluginClassLoader());
        }
        if (context != null && (resolver = PluginManagerCore.createPluginJarsPathResolver(descriptor2.getPluginPath(), context)) != null) {
            return resolver;
        }
        return PathBasedJdomXIncluder.DEFAULT_PATH_RESOLVER;
    }

    @NotNull
    public static IdeaPluginDescriptorImpl loadFullDescriptor(@NotNull IdeaPluginDescriptorImpl descriptor2) {
        IdeaPluginDescriptorImpl fullDescriptor = PluginDescriptorLoader.tryLoadFullDescriptor(descriptor2);
        if (fullDescriptor == null) {
            PluginManagerCore.getLogger().error("Could not load full descriptor for plugin " + descriptor2.getPluginPath());
            fullDescriptor = descriptor2;
        }
        return fullDescriptor;
    }
}

