/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.passwordSafe.impl.providers.memory;

import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.Credentials;
import com.intellij.credentialStore.OneTimeString;
import com.intellij.ide.passwordSafe.PasswordStorage;
import com.intellij.ide.passwordSafe.impl.PasswordSafeTimed;
import com.intellij.ide.passwordSafe.impl.providers.ByteArrayWrapper;
import com.intellij.ide.passwordSafe.impl.providers.EncryptionUtil;
import com.intellij.openapi.util.registry.Registry;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public class MemoryPasswordSafe
implements PasswordStorage {
    private final transient AtomicReference<byte[]> key = new AtomicReference();
    private final transient PasswordSafeTimed<Map<ByteArrayWrapper, byte[]>> database = new PasswordSafeTimed<Map<ByteArrayWrapper, byte[]>>(){

        @Override
        protected Map<ByteArrayWrapper, byte[]> compute() {
            return Collections.synchronizedMap(new HashMap());
        }

        @Override
        protected int getMinutesToLive() {
            return MemoryPasswordSafe.this.getMinutesToLive();
        }
    };

    protected int getMinutesToLive() {
        return Registry.intValue((String)"passwordSafe.memorySafe.ttl");
    }

    protected byte @NotNull [] key() {
        if (this.key.get() == null) {
            byte[] rnd = new byte[256];
            new SecureRandom().nextBytes(rnd);
            this.key.compareAndSet(null, EncryptionUtil.genKey(EncryptionUtil.hash(new byte[][]{rnd})));
        }
        return this.key.get();
    }

    protected byte[] getEncryptedPassword(byte @NotNull [] key) {
        return this.database.get().get(new ByteArrayWrapper(key));
    }

    protected void removeEncryptedPassword(byte[] key) {
        this.database.get().remove(new ByteArrayWrapper(key));
    }

    protected void storeEncryptedPassword(byte[] key, byte[] encryptedPassword) {
        this.database.get().put(new ByteArrayWrapper(key), encryptedPassword);
    }

    public void clear() {
        this.database.get().clear();
    }

    @Nullable
    public Credentials get(@NotNull CredentialAttributes attributes) {
        byte[] masterKey = this.key();
        byte[] encryptedPassword = this.getEncryptedPassword(EncryptionUtil.encryptKey(masterKey, EncryptionUtil.rawKey(attributes)));
        OneTimeString password = encryptedPassword == null ? null : EncryptionUtil.decryptText(masterKey, encryptedPassword);
        return password == null ? null : new Credentials(attributes.getUserName(), password);
    }

    public final void set(@NotNull CredentialAttributes attributes, @Nullable Credentials value2) {
        byte[] key = EncryptionUtil.encryptKey(this.key(), EncryptionUtil.rawKey(attributes));
        if (value2 == null || value2.getPassword() == null) {
            this.removeEncryptedPassword(key);
        } else {
            this.storeEncryptedPassword(key, EncryptionUtil.encryptText(this.key(), value2.getPassword()));
        }
    }
}

