/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.passwordSafe.impl;

import com.intellij.util.TimedReference;
import org.jetbrains.annotations.NotNull;

public abstract class PasswordSafeTimed<T>
extends TimedReference<T> {
    private int myCheckCount;

    protected PasswordSafeTimed() {
        super(null);
    }

    protected abstract T compute();

    @NotNull
    public synchronized T get() {
        Object value2 = super.get();
        if (value2 == null) {
            value2 = this.compute();
            this.set(value2);
        }
        this.myCheckCount = 0;
        return (T)value2;
    }

    protected synchronized boolean checkLocked() {
        int ttlCount = this.getMinutesToLive() * 60 / 60;
        if (ttlCount >= 0 && ++this.myCheckCount > ttlCount) {
            return super.checkLocked();
        }
        return true;
    }

    protected int getMinutesToLive() {
        return 60;
    }
}

