/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.navigationToolbar;

import com.intellij.ProjectTopics;
import com.intellij.ide.actions.CopyAction;
import com.intellij.ide.actions.CutAction;
import com.intellij.ide.navigationToolbar.NavBarActions;
import com.intellij.ide.navigationToolbar.NavBarItem;
import com.intellij.ide.navigationToolbar.NavBarModelListener;
import com.intellij.ide.navigationToolbar.NavBarPanel;
import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PopupAction;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.FileStatusListener;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.problems.ProblemListener;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.ui.ListActions;
import com.intellij.ui.ScrollingUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Robot;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public final class NavBarListener
implements ProblemListener,
FocusListener,
FileStatusListener,
AnActionListener,
FileEditorManagerListener,
PsiTreeChangeListener,
ModuleRootListener,
NavBarModelListener,
PropertyChangeListener,
KeyListener,
WindowFocusListener,
LafManagerListener,
DynamicPluginListener {
    private static final String LISTENER = "NavBarListener";
    private static final String BUS = "NavBarMessageBus";
    private final NavBarPanel myPanel;
    private boolean shouldFocusEditor;

    static void subscribeTo(@NotNull NavBarPanel panel2) {
        if (panel2.getClientProperty(LISTENER) != null) {
            NavBarListener.unsubscribeFrom(panel2);
        }
        NavBarListener listener2 = new NavBarListener(panel2);
        Project project = panel2.getProject();
        panel2.putClientProperty(LISTENER, listener2);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener(listener2);
        FileStatusManager.getInstance((Project)project).addFileStatusListener((FileStatusListener)listener2);
        PsiManager.getInstance((Project)project).addPsiTreeChangeListener((PsiTreeChangeListener)listener2);
        MessageBusConnection connection = project.getMessageBus().connect();
        connection.subscribe(AnActionListener.TOPIC, (Object)listener2);
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)listener2);
        connection.subscribe(NavBarModelListener.NAV_BAR, (Object)listener2);
        connection.subscribe(ProblemListener.TOPIC, (Object)listener2);
        connection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)listener2);
        connection.subscribe(DynamicPluginListener.TOPIC, (Object)listener2);
        panel2.putClientProperty(BUS, connection);
        panel2.addKeyListener(listener2);
        if (panel2.isInFloatingMode()) {
            Window window = SwingUtilities.windowForComponent(panel2);
            if (window != null) {
                window.addWindowFocusListener(listener2);
            }
        } else {
            ApplicationManager.getApplication().getMessageBus().connect((Disposable)connection).subscribe(LafManagerListener.TOPIC, (Object)listener2);
        }
    }

    static void unsubscribeFrom(@NotNull NavBarPanel panel2) {
        NavBarListener listener2 = (NavBarListener)panel2.getClientProperty(LISTENER);
        panel2.putClientProperty(LISTENER, null);
        if (listener2 == null) {
            return;
        }
        Project project = panel2.getProject();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener(listener2);
        FileStatusManager.getInstance((Project)project).removeFileStatusListener((FileStatusListener)listener2);
        PsiManager.getInstance((Project)project).removePsiTreeChangeListener((PsiTreeChangeListener)listener2);
        MessageBusConnection connection = (MessageBusConnection)panel2.getClientProperty(BUS);
        panel2.putClientProperty(BUS, null);
        if (connection != null) {
            connection.disconnect();
        }
    }

    NavBarListener(NavBarPanel panel2) {
        this.myPanel = panel2;
        this.myPanel.addFocusListener(this);
        if (this.myPanel.allowNavItemsFocus()) {
            this.myPanel.addNavBarItemFocusListener(this);
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (this.myPanel.allowNavItemsFocus() && UIUtil.isAncestor((Component)this.myPanel, (Component)e.getOppositeComponent())) {
            return;
        }
        if (e.getOppositeComponent() == null && this.shouldFocusEditor) {
            this.shouldFocusEditor = false;
            ToolWindowManager.getInstance((Project)this.myPanel.getProject()).activateEditorComponent();
            return;
        }
        this.myPanel.updateItems();
        List<NavBarItem> items = this.myPanel.getItems();
        if (!this.myPanel.isInFloatingMode() && items.size() > 0) {
            this.myPanel.setContextComponent((Component)((Object)items.get(items.size() - 1)));
        } else {
            this.myPanel.setContextComponent(null);
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (this.myPanel.allowNavItemsFocus() && UIUtil.isAncestor((Component)this.myPanel, (Component)e.getOppositeComponent())) {
            return;
        }
        if (this.myPanel.getProject().isDisposed()) {
            this.myPanel.setContextComponent(null);
            this.myPanel.hideHint();
            return;
        }
        DialogWrapper dialog2 = DialogWrapper.findInstance((Component)e.getOppositeComponent());
        boolean bl = this.shouldFocusEditor = dialog2 != null;
        if (dialog2 != null) {
            Disposable parent = dialog2.getDisposable();
            Disposable onParentDispose = () -> {
                if (dialog2.getExitCode() == 1) {
                    this.shouldFocusEditor = false;
                }
            };
            if (dialog2.isDisposed()) {
                Disposer.dispose((Disposable)onParentDispose);
            } else {
                Disposer.register((Disposable)parent, (Disposable)onParentDispose);
            }
        }
        SwingUtilities.invokeLater(() -> this.processFocusLost(e));
    }

    private void processFocusLost(FocusEvent e) {
        boolean childPopupInactive;
        Component opposite = e.getOppositeComponent();
        if (this.myPanel.isInFloatingMode() && opposite != null && DialogWrapper.findInstance((Component)opposite) != null) {
            this.myPanel.hideHint();
            return;
        }
        boolean nodePopupInactive = !this.myPanel.isNodePopupActive();
        boolean bl = childPopupInactive = !JBPopupFactory.getInstance().isChildPopupFocused((Component)this.myPanel);
        if (nodePopupInactive && childPopupInactive && opposite != null && opposite != this.myPanel && !this.myPanel.isAncestorOf(opposite) && !e.isTemporary()) {
            this.myPanel.setContextComponent(null);
            this.myPanel.hideHint();
        }
        this.myPanel.updateItems();
    }

    private void rebuildUI() {
        if (this.myPanel.isShowing()) {
            this.myPanel.getUpdateQueue().queueRebuildUi();
        }
    }

    private void updateModel() {
        if (this.myPanel.isShowing()) {
            this.myPanel.getModel().setChanged(true);
            this.myPanel.getUpdateQueue().queueModelUpdateFromFocus();
        }
    }

    public void fileStatusesChanged() {
        this.rebuildUI();
    }

    public void fileStatusChanged(@NotNull VirtualFile virtualFile) {
        this.rebuildUI();
    }

    public void childAdded(@NotNull PsiTreeChangeEvent event) {
        this.updateModel();
    }

    public void childReplaced(@NotNull PsiTreeChangeEvent event) {
        this.updateModel();
    }

    public void childMoved(@NotNull PsiTreeChangeEvent event) {
        this.updateModel();
    }

    public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
        this.updateModel();
    }

    public void propertyChanged(@NotNull PsiTreeChangeEvent event) {
        this.updateModel();
    }

    public void rootsChanged(@NotNull ModuleRootEvent event) {
        this.updateModel();
    }

    public void problemsAppeared(@NotNull VirtualFile file2) {
        this.updateModel();
    }

    public void problemsDisappeared(@NotNull VirtualFile file2) {
        this.updateModel();
    }

    @Override
    public void modelChanged() {
        this.rebuildUI();
    }

    @Override
    public void selectionChanged() {
        this.myPanel.updateItems();
        this.myPanel.scrollSelectionToVisible();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name;
        if (this.myPanel.isShowing() && ("focusOwner".equals(name = evt.getPropertyName()) || "permanentFocusOwner".equals(name))) {
            this.myPanel.getUpdateQueue().restartRebuild();
        }
    }

    public void afterActionPerformed(@NotNull AnAction action2, @NotNull DataContext dataContext, @NotNull AnActionEvent event) {
        if (NavBarListener.shouldSkipAction(action2)) {
            return;
        }
        if (this.myPanel.isInFloatingMode()) {
            this.myPanel.hideHint();
        } else {
            this.myPanel.cancelPopup();
        }
    }

    private static boolean shouldSkipAction(AnAction action2) {
        return action2 instanceof PopupAction || action2 instanceof CopyAction || action2 instanceof CutAction || action2 instanceof ListActions || action2 instanceof NavBarActions || action2 instanceof ScrollingUtil.ScrollingAction;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (!(e.isAltDown() || e.isMetaDown() || e.isControlDown() || this.myPanel.isNodePopupActive())) {
            if (!Character.isLetter(e.getKeyChar())) {
                return;
            }
            IdeFocusManager focusManager = IdeFocusManager.getInstance((Project)this.myPanel.getProject());
            ActionCallback firstCharTyped = new ActionCallback();
            focusManager.typeAheadUntil(firstCharTyped);
            this.myPanel.moveDown();
            SwingUtilities.invokeLater(() -> {
                try {
                    Robot robot = new Robot();
                    boolean shiftOn = e.isShiftDown();
                    int code = e.getKeyCode();
                    if (shiftOn) {
                        robot.keyPress(16);
                    }
                    robot.keyPress(code);
                    robot.keyRelease(code);
                    firstCharTyped.setDone();
                }
                catch (AWTException aWTException) {
                    // empty catch block
                }
            });
        }
    }

    public void fileOpened(@NotNull FileEditorManager manager, @NotNull VirtualFile file2) {
        ApplicationManager.getApplication().invokeLater(() -> {
            if (this.myPanel.isFocused()) {
                manager.openFile(file2, true);
            }
        });
    }

    public void lookAndFeelChanged(@NotNull LafManager source) {
        this.myPanel.getNavBarUI().clearItems();
        this.myPanel.revalidate();
        this.myPanel.repaint();
    }

    @Override
    public void windowLostFocus(WindowEvent e) {
    }

    @Override
    public void windowGainedFocus(WindowEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    public void beforeChildAddition(@NotNull PsiTreeChangeEvent event) {
    }

    public void beforeChildRemoval(@NotNull PsiTreeChangeEvent event) {
    }

    public void beforeChildReplacement(@NotNull PsiTreeChangeEvent event) {
    }

    public void beforeChildMovement(@NotNull PsiTreeChangeEvent event) {
    }

    public void beforeChildrenChange(@NotNull PsiTreeChangeEvent event) {
    }

    public void beforePropertyChange(@NotNull PsiTreeChangeEvent event) {
    }

    public void childRemoved(@NotNull PsiTreeChangeEvent event) {
    }

    @Override
    public void beforePluginUnload(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
        this.myPanel.getNavBarUI().clearItems();
    }
}

