/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.macro;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Macro {
    public static final ExtensionPointName<Macro> EP_NAME = ExtensionPointName.create((String)"com.intellij.macro");
    protected String myCachedPreview;

    @NonNls
    @NotNull
    public abstract String getName();

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public abstract String getDescription();

    @Nullable
    public abstract String expand(@NotNull DataContext var1) throws ExecutionCancelledException;

    @Nullable
    public String expand(@NotNull DataContext dataContext, String ... args) throws ExecutionCancelledException {
        return this.expand(dataContext);
    }

    public void cachePreview(@NotNull DataContext dataContext) {
        try {
            this.myCachedPreview = this.expand(dataContext);
        }
        catch (ExecutionCancelledException e) {
            this.myCachedPreview = "";
        }
    }

    public final String preview() {
        return this.myCachedPreview;
    }

    @NotNull
    protected static String getPath(@NotNull VirtualFile file2) {
        return file2.getPath().replace('/', File.separatorChar);
    }

    @NotNull
    static File getIOFile(@NotNull VirtualFile file2) {
        return new File(Macro.getPath(file2));
    }

    @Nullable
    protected static VirtualFile getVirtualDirOrParent(@NotNull DataContext dataContext) {
        VirtualFile vFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext);
        if (vFile != null && !vFile.isDirectory()) {
            vFile = vFile.getParent();
        }
        return vFile;
    }

    public static class Silent
    extends Macro {
        private final Macro myDelegate;
        private final String myValue;

        public Silent(@NotNull Macro delegate, String value2) {
            this.myDelegate = delegate;
            this.myValue = value2;
        }

        @Override
        public String expand(@NotNull DataContext dataContext) {
            return this.myValue;
        }

        @Override
        @NotNull
        public String getDescription() {
            return this.myDelegate.getDescription();
        }

        @Override
        @NotNull
        public String getName() {
            return this.myDelegate.getName();
        }
    }

    public static final class ExecutionCancelledException
    extends Exception {
    }
}

