/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.macro;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.macro.Macro;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class FileDirRelativeToSourcepathMacro
extends Macro {
    @Override
    @NotNull
    public String getName() {
        return "FileDirRelativeToSourcepath";
    }

    @Override
    @NotNull
    public String getDescription() {
        return IdeBundle.message((String)"macro.file.dir.relative.to.sourcepath.root", (Object[])new Object[0]);
    }

    @Override
    public String expand(@NotNull DataContext dataContext) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return null;
        }
        VirtualFile file2 = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext);
        if (file2 == null) {
            return null;
        }
        if (!file2.isDirectory() && (file2 = file2.getParent()) == null) {
            return null;
        }
        VirtualFile sourceRoot = ProjectRootManager.getInstance((Project)project).getFileIndex().getSourceRootForFile(file2);
        if (sourceRoot == null) {
            return null;
        }
        return FileUtil.getRelativePath((File)FileDirRelativeToSourcepathMacro.getIOFile(sourceRoot), (File)FileDirRelativeToSourcepathMacro.getIOFile(file2));
    }
}

