/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.lightEdit.intentions.openInProject;

import com.intellij.ide.lightEdit.LightEditFeatureUsagesUtil;
import com.intellij.ide.lightEdit.LightEditUtil;
import com.intellij.ide.lightEdit.intentions.openInProject.GitProjectRootFinder;
import com.intellij.ide.lightEdit.intentions.openInProject.GradleProjectRootFinder;
import com.intellij.ide.lightEdit.intentions.openInProject.IntellijProjectRootFinder;
import com.intellij.ide.lightEdit.intentions.openInProject.ProjectRootFinder;
import com.intellij.ide.lightEdit.intentions.openInProject.SimpleParentRootFinder;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ProjectRootSearchUtil {
    private static final ProjectRootFinder[] ROOT_FINDERS = new ProjectRootFinder[]{new IntellijProjectRootFinder(), new GradleProjectRootFinder(), new GitProjectRootFinder(), new SimpleParentRootFinder()};

    private ProjectRootSearchUtil() {
    }

    @Nullable
    static VirtualFile findProjectRoot(@NotNull VirtualFile sourceFile) {
        Ref result2 = Ref.create();
        Ref requiresConfirmation = Ref.create((Object)false);
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            for (ProjectRootFinder finder : ROOT_FINDERS) {
                VirtualFile root = finder.findProjectRoot(sourceFile);
                if (root == null) continue;
                result2.set((Object)root);
                requiresConfirmation.set((Object)finder.requiresConfirmation());
                break;
            }
        }, ApplicationBundle.message((String)"light.edit.open.in.project.progress.message", (Object[])new Object[0]), true, LightEditUtil.getProject());
        if (((Boolean)requiresConfirmation.get()).booleanValue()) {
            VirtualFile newProjectRoot = ProjectRootSearchUtil.confirmOrChooseProjectDir((VirtualFile)result2.get());
            if (newProjectRoot != null) {
                LightEditFeatureUsagesUtil.logOpenFileInProject(LightEditFeatureUsagesUtil.ProjectStatus.New);
            }
            result2.set((Object)newProjectRoot);
        } else {
            LightEditFeatureUsagesUtil.logOpenFileInProject(LightEditFeatureUsagesUtil.ProjectStatus.Existing);
        }
        return (VirtualFile)result2.get();
    }

    @Nullable
    private static VirtualFile confirmOrChooseProjectDir(@Nullable VirtualFile suggestedRoot) {
        if (suggestedRoot != null) {
            FileChooserDescriptor descriptor2 = FileChooserDescriptorFactory.createSingleFolderDescriptor();
            descriptor2.setTitle(ApplicationBundle.message((String)"light.edit.open.in.project.dialog.title", (Object[])new Object[0]));
            return FileChooser.chooseFile((FileChooserDescriptor)descriptor2, (Project)LightEditUtil.getProject(), (VirtualFile)suggestedRoot);
        }
        return null;
    }
}

